
<?php $__env->startSection('title','Con. Success'); ?>

<?php $__env->startSection('content'); ?>
<?php
    $points = (int) $conversion->points;
    $amount = (float) $conversion->amount;
    $ratePoints = (int) ($conversion->rate_points ?? 0);
    $rateAmount = (float) ($conversion->rate_amount ?? 0);
    $created = optional($conversion->created_at)->format('d-m-Y');

    $rateText = $ratePoints > 0
        ? "{$ratePoints} পয়েন্ট = ৳" . number_format($rateAmount, 2)
        : '—';
?>

<div class="min-h-screen bg-[#f5f7fb] flex items-center justify-center px-4 py-10">
    <div class="w-full max-w-sm">

        
        <div class="bg-white rounded-3xl shadow-[0_14px_40px_rgba(0,0,0,0.08)] px-6 py-7 text-center">

            
            <div class="flex justify-center mb-4">
                <div class="h-16 w-16 rounded-full bg-emerald-500 flex items-center justify-center">
                    <svg class="h-8 w-8 text-white" viewBox="0 0 24 24" fill="none">
                        <path d="M5 13l4 4L19 7"
                              stroke="currentColor"
                              stroke-width="2.5"
                              stroke-linecap="round"
                              stroke-linejoin="round" />
                    </svg>
                </div>
            </div>

            
            <h1 class="text-[18px] font-extrabold text-gray-800 leading-tight">
                কনভার্সন সফল হয়েছে
            </h1>
            <p class="text-sm text-sky-600 mt-1">
                Reward Conversion
            </p>

            
            <div class="mt-5 bg-white rounded-2xl border border-gray-200 overflow-hidden text-sm text-gray-700">

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">কনভার্ট পয়েন্টঃ</span>
                    <span class="font-semibold text-gray-800">
                        <?php echo e(number_format($points)); ?> pts
                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">অ্যামাউন্টঃ</span>
                    <span class="font-semibold text-gray-800">
                        ৳<?php echo e(number_format($amount, 2)); ?>

                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">রেটঃ</span>
                    <span class="font-semibold text-gray-800">
                        <?php echo e($rateText); ?>

                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2">
                    <span class="text-gray-600">তারিখঃ</span>
                    <span class="font-semibold text-gray-800">
                        <?php echo e($created); ?>

                    </span>
                </div>
            </div>
        </div>

        
        <a href="<?php echo e(route('rewards.convert.index')); ?>"
           class="mt-5 block w-full text-center bg-emerald-500 hover:bg-emerald-600 text-white font-semibold text-sm py-3 rounded-full shadow-md transition">
            রিওয়ার্ড পেজে ফিরে যান
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/rewards/convert_success.blade.php ENDPATH**/ ?>