
<?php $__env->startSection('title','লোন আবেদন'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }

        .chip,
        .pchip {
            border-radius: 9999px;
            border: 1px solid rgba(148, 163, 184, 0.7);
            background: rgba(15, 23, 42, 0.85);
            color: #e2e8f0;
            cursor: pointer;
            transition: background .15s ease, border-color .15s ease, color .15s ease, box-shadow .15s ease;
        }
        .chip:hover,
        .pchip:hover {
            border-color: rgba(45, 212, 191, 0.8);
            background: rgba(15, 23, 42, 0.95);
        }
        .chip.active,
        .pchip.active {
            border-color: rgba(16, 185, 129, 0.95);
            background: linear-gradient(to right, #10b981, #22d3ee);
            color: #020617;
            box-shadow: 0 14px 30px -20px rgba(16, 185, 129, 0.9);
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <main class="w-full max-w-[520px] mx-auto relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Loan Apply
            </span>
        </div>

        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm overflow-hidden">

            
            <div class="bg-gradient-to-r from-emerald-500 via-cyan-500 to-teal-500 px-6 py-6 text-white text-center">
                <div class="text-5xl mb-2">💸</div>
                <h1 class="text-lg sm:text-2xl font-extrabold leading-snug">
                    ন্যূনতম <?php echo e(number_format($required,0)); ?> টাকা লেনদেন করলে লোন আবেদন করতে পারবেন!
                </h1>
                <div class="mt-3 inline-flex items-center gap-2 rounded-full bg-black/15 px-3 py-1 text-[11px] sm:text-xs font-semibold backdrop-blur shadow-sm">
                    বর্তমান টার্নওভার: ৳<?php echo e(number_format($turnover,2)); ?>

                    <?php if($eligible): ?>
                        <span class="ml-1 rounded-full bg-emerald-500/90 px-2 py-0.5 text-white">যোগ্য</span>
                    <?php else: ?>
                        <span class="ml-1 rounded-full bg-rose-500/90 px-2 py-0.5 text-white">অযোগ্য</span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="p-5 sm:p-6">

                
                <div class="rounded-2xl border px-4 py-3 text-sm shadow-md
                            <?php echo e($eligible ? 'border-emerald-500/40 bg-emerald-500/10 text-emerald-100' : 'border-rose-500/40 bg-rose-500/10 text-rose-100'); ?>">
                    <div class="flex items-start gap-2">
                        <?php if($eligible): ?>
                            <span class="mt-0.5">✔</span>
                            <div><b>অভিনন্দন!</b> আপনি লোনের যোগ্য। নিচের ফর্ম পূরণ করে আবেদন করুন।</div>
                        <?php else: ?>
                            <span class="mt-0.5">✖</span>
                            <div>
                                <b>সর্বনিম্ন <?php echo e(number_format($required,0)); ?> টাকা</b> লেনদেন সম্পন্ন করলে লোনের যোগ্যতা অর্জন করবেন।
                                <div class="text-[11px] mt-1 text-slate-300">অতিরিক্ত তথ্যের জন্য আপনার এজেন্টের সাথে যোগাযোগ করুন।</div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                
                <div class="my-5 h-px bg-slate-800/80"></div>

                
                <?php if($errors->any()): ?>
                    <div class="mb-4 rounded-2xl border border-rose-500/40 bg-rose-500/10 px-4 py-3 text-[11px] text-rose-100 shadow-sm">
                        <ul class="list-disc list-inside space-y-0.5">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($e); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?php if(session('success')): ?>
                    <div class="mb-4 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-4 py-3 text-[11px] text-emerald-100 shadow-sm">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                
                <form method="POST" action="<?php echo e(route('loans.apply.store')); ?>" enctype="multipart/form-data" class="space-y-5" id="loan-form">
                    <?php echo csrf_field(); ?>

                    
                    <div>
                        <label class="block text-[11px] font-semibold mb-2 text-slate-200 tracking-wide uppercase">
                            লোনের পরিমাণ
                        </label>
                        <div class="grid grid-cols-3 gap-2 mb-2">
                            <?php $__currentLoopData = ($settings->loan_options ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button style=" border-radius: 9999px;
            border: 1px solid rgba(148, 163, 184, 0.7);
            background: rgba(15, 23, 42, 0.85);
            color: #e2e8f0;
            cursor: pointer;
            transition: background .15s ease, border-color .15s ease, color .15s ease, box-shadow .15s ease;" type="button"
                                        class="chip px-4 py-2 text-sm font-semibold shadow-sm"
                                        data-amount="<?php echo e($opt); ?>">৳<?php echo e(number_format($opt)); ?></button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="relative">
                            <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-emerald-400 text-xs">৳</span>
                            <input type="number" name="loan_amount" min="1000"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-8 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                          focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500"
                                   placeholder="কাস্টম পরিমাণ লিখুন"
                                   value="<?php echo e(old('loan_amount')); ?>"
                                   <?php echo e($eligible ? '' : 'disabled'); ?> required>
                        </div>
                        <div class="mt-1 text-[10px] text-slate-400">সর্বনিম্ন ১,০০০ টাকা</div>
                        <?php $__errorArgs = ['loan_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-[11px] text-rose-300 mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    
                    <div>
                        <label class="block text-[11px] font-semibold mb-2 text-slate-200 tracking-wide uppercase">
                            লোন মেয়াদ (মাস)
                        </label>
                        <div class="flex flex-wrap gap-2 mb-2">
                            <?php $__currentLoopData = ($settings->loan_periods ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button style=" border-radius: 9999px;
            border: 1px solid rgba(148, 163, 184, 0.7);
            background: rgba(15, 23, 42, 0.85);
            color: #e2e8f0;
            cursor: pointer;
            transition: background .15s ease, border-color .15s ease, color .15s ease, box-shadow .15s ease;" type="button"
                                        class="pchip px-4 py-2 text-sm font-semibold shadow-sm"
                                        data-period="<?php echo e($m); ?>"><?php echo e($m); ?> মাস</button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="relative">
                            <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-emerald-400 text-xs">🗓️</span>
                            <input type="number" name="loan_period" min="1"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-9 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                          focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500"
                                   placeholder="মাসের সংখ্যা"
                                   value="<?php echo e(old('loan_period')); ?>"
                                   <?php echo e($eligible ? '' : 'disabled'); ?> required>
                        </div>
                        <?php $__errorArgs = ['loan_period'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-[11px] text-rose-300 mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    
                    <div>
                        <label class="block text-[11px] font-semibold mb-2 text-slate-200 tracking-wide uppercase">
                            ডকুমেন্ট (ঐচ্ছিক)
                        </label>
                        <input type="file" name="document" accept="image/*,application/pdf"
                               class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2 text-xs text-slate-100 outline-none transition
                                      file:mr-4 file:rounded-xl file:border-0 file:bg-emerald-500/10 file:px-4 file:py-2 file:text-emerald-300 hover:file:bg-emerald-500/20"
                               <?php echo e($eligible ? '' : 'disabled'); ?>>
                        <?php $__errorArgs = ['document'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-[11px] text-rose-300 mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    
                    <?php
                      $monthlyRatePercent   = $settings->monthly_rate_percent   ?? 2;
                      $processingFeePercent = $settings->processing_fee_percent ?? 1;
                      $vatPercent           = $settings->vat_percent            ?? 15;
                    ?>

                    <div id="calc-card"
                         class="rounded-2xl border border-slate-700 bg-slate-900/80 p-4 shadow-xl text-sm text-slate-100"
                         data-rate="<?php echo e($monthlyRatePercent); ?>"
                         data-fee="<?php echo e($processingFeePercent); ?>"
                         data-vat="<?php echo e($vatPercent); ?>">
                      <div class="mb-1 font-semibold text-slate-50 text-sm">ক্যালকুলেশন সারসংক্ষেপ</div>
                      <div class="mb-3 text-[11px] text-slate-400">
                        ( ভ্যাট: <b id="v-p"><?php echo e($vatPercent); ?></b>% )
                      </div>

                      <div class="grid grid-cols-2 gap-3">
                        <div class="rounded-xl bg-slate-900 p-3 border border-slate-800">
                          <div class="text-[11px] text-slate-400">মাসিক কিস্তি (EMI)</div>
                          <div class="mt-1 text-lg font-extrabold text-emerald-300">৳<span id="emi">0.00</span></div>
                        </div>
                        <div class="rounded-xl bg-slate-900 p-3 border border-slate-800">
                          <div class="text-[11px] text-slate-400">মোট পরিশোধ</div>
                          <div class="mt-1 text-lg font-extrabold text-slate-50">৳<span id="total-pay">0.00</span></div>
                        </div>
                        <div class="rounded-xl bg-slate-900 p-3 border border-slate-800">
                          <div class="text-[11px] text-slate-400">মোট সুদ</div>
                          <div class="mt-1 text-lg font-extrabold text-slate-50">৳<span id="total-int">0.00</span></div>
                        </div>
                        <div class="rounded-xl bg-slate-900 p-3 border border-slate-800">
                          <div class="text-[11px] text-slate-400">ভ্যাট + ফি</div>
                          <div class="mt-1 text-lg font-extrabold text-slate-50">৳<span id="fees">0.00</span></div>
                        </div>
                        <div class="col-span-2 rounded-xl bg-emerald-500/10 p-3 border border-emerald-500/30">
                          <div class="flex items-center justify-between">
                            <div class="text-sm text-slate-100 font-semibold">হাতে পাওয়া টাকা</div>
                            <div class="text-lg font-extrabold text-emerald-300">৳<span id="net">0.00</span></div>
                          </div>
                        </div>
                      </div>

                      
                      <input type="hidden" name="calc_emi">
                      <input type="hidden" name="calc_total_interest">
                      <input type="hidden" name="calc_total_payment">
                      <input type="hidden" name="calc_processing_fee">
                      <input type="hidden" name="calc_vat">
                      <input type="hidden" name="calc_net_disbursed">
                    </div>

                    
                    <button
                      class="w-full rounded-2xl px-5 py-3 text-center text-sm font-semibold transition
                             <?php echo e($eligible
                                ? 'bg-gradient-to-r from-emerald-500 to-cyan-500 text-slate-950 shadow-[0_18px_45px_-20px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400 active:scale-[0.98]'
                                : 'bg-slate-600/60 text-slate-300 cursor-not-allowed'); ?>">
                      <?php echo e($eligible ? 'আবেদন সাবমিট করুন' : 'এখনও যোগ্য নন'); ?>

                    </button>
                </form>
            </div>
        </div>
    </main>

    
    <script>
      (function(){
        const amountInput = document.querySelector('input[name="loan_amount"]');
        const periodInput = document.querySelector('input[name="loan_period"]');
        const chips = document.querySelectorAll('.chip');
        const pchips = document.querySelectorAll('.pchip');
        const card = document.getElementById('calc-card');

        const out = {
          emi: document.getElementById('emi'),
          totalPay: document.getElementById('total-pay'),
          totalInt: document.getElementById('total-int'),
          fees: document.getElementById('fees'),
          net: document.getElementById('net'),
        };

        const hidden = {
          emi: document.querySelector('input[name="calc_emi"]'),
          totalInterest: document.querySelector('input[name="calc_total_interest"]'),
          totalPayment: document.querySelector('input[name="calc_total_payment"]'),
          fee: document.querySelector('input[name="calc_processing_fee"]'),
          vat: document.querySelector('input[name="calc_vat"]'),
          net: document.querySelector('input[name="calc_net_disbursed"]'),
        };

        function fmt(n){ return (Math.round((+n || 0)*100)/100).toFixed(2); }

        function recalc(){
          const P = Math.max(0, parseFloat(amountInput?.value || '0'));
          const n = Math.max(0, parseInt(periodInput?.value || '0', 10));
          const ratePct = parseFloat(card?.dataset.rate || '2');
          const feePct  = parseFloat(card?.dataset.fee  || '1');
          const vatPct  = parseFloat(card?.dataset.vat  || '15');

          if(!P || !n){
            out.emi.textContent = out.totalPay.textContent = out.totalInt.textContent = out.fees.textContent = out.net.textContent = '0.00';
            Object.values(hidden).forEach(h=>{ if(h) h.value = '0'; });
            return;
          }

          const r = ratePct/100;
          let emi = 0, total=0, interest=0;

          if(r > 0){
            const pow = Math.pow(1+r, n);
            emi = P * r * pow / (pow - 1);
          } else {
            emi = P / n;
          }
          total = emi * n;
          interest = total - P;

          const processing = P * (feePct/100);
          const vat = processing * (vatPct/100);
          const fees = processing + vat;
          const net = P - fees;

          out.emi.textContent = fmt(emi);
          out.totalPay.textContent = fmt(total);
          out.totalInt.textContent = fmt(interest);
          out.fees.textContent = fmt(fees);
          out.net.textContent = fmt(net);

          if(hidden.emi) hidden.emi.value = fmt(emi);
          if(hidden.totalPayment) hidden.totalPayment.value = fmt(total);
          if(hidden.totalInterest) hidden.totalInterest.value = fmt(interest);
          if(hidden.fee) hidden.fee.value = fmt(processing);
          if(hidden.vat) hidden.vat.value = fmt(vat);
          if(hidden.net) hidden.net.value = fmt(net);
        }

        function setActive(btns, btn) {
          btns.forEach(b => b.classList.toggle('active', b === btn));
        }

        chips.forEach(b => b.addEventListener('click', () => {
          if (amountInput) amountInput.value = b.dataset.amount || '';
          setActive(chips, b);
          amountInput?.dispatchEvent(new Event('input'));
        }));
        pchips.forEach(b => b.addEventListener('click', () => {
          if (periodInput) periodInput.value = b.dataset.period || '';
          setActive(pchips, b);
          periodInput?.dispatchEvent(new Event('input'));
        }));

        amountInput?.addEventListener('input', recalc);
        periodInput?.addEventListener('input', recalc);

        // initial calc (old values থাকলে)
        recalc();
      })();
    </script>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/frontend/loans/apply.blade.php ENDPATH**/ ?>