

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .btn-create{ background:#5b21b6; border-color:#5b21b6 } .btn-create:hover{ background:#4c1d95; border-color:#4c1d95 }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-boxes-stacked me-2"></i> Deposit Packages</h5>
    <a class="btn btn-create text-white" href="<?php echo e(url('/admin/deposit-packages/create')); ?>">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <form class="card-edge p-3 mb-3" method="GET" action="<?php echo e(url('/admin/deposit-packages')); ?>">
    <div class="row g-2">
      <div class="col-md-5">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="<?php echo e(request('q')); ?>" class="form-control" placeholder="Search title">
        </div>
      </div>
      <div class="col-md-3">
        <select name="status" class="form-select">
          <option value="">Any status</option>
          <option value="active"   <?php if(request('status')==='active'): echo 'selected'; endif; ?>>Active</option>
          <option value="inactive" <?php if(request('status')==='inactive'): echo 'selected'; endif; ?>>Inactive</option>
        </select>
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-outline-secondary"><i class="fa-solid fa-filter me-1"></i> Filter</button>
      </div>
    </div>
  </form>

  <?php if(session('success')): ?>
    <div class="alert alert-success card-edge p-2"><i class="fa-regular fa-circle-check me-1"></i><?php echo e(session('success')); ?></div>
  <?php endif; ?>

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Title</th>
          <th>Principal</th>
          <th>Bonus %</th>
          <th>Badge</th>
          <th>Validity</th>
          <th>Sort</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
          <td data-label="#" class="text-muted"><?php echo e($p->id); ?></td>
          <td data-label="Title" class="fw-semibold">
            <a class="text-decoration-none" href="<?php echo e(url('/admin/deposit-packages/'.$p->id)); ?>">
              <i class="fa-solid fa-ticket text-secondary me-1"></i><?php echo e($p->title); ?>

            </a>
          </td>
          <td data-label="Principal"><?php echo e(number_format($p->principal_amount,2)); ?></td>
          <td data-label="Bonus %"><?php echo e(number_format($p->bonus_percent,2)); ?></td>
          <td data-label="Badge">
            <?php if($p->badge_text): ?>
              <span class="badge-soft gray"><?php echo e($p->badge_text); ?></span>
            <?php else: ?>
              —
            <?php endif; ?>
          </td>
          <td data-label="Validity">—</td>
          <td data-label="Sort"><?php echo e($p->sort_order); ?></td>
          <td data-label="Status">
            <span class="badge-soft <?php echo e($p->status==='active' ? 'green' : 'red'); ?>">
              <i class="fa-solid <?php echo e($p->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off'); ?> me-1"></i><?php echo e(ucfirst($p->status)); ?>

            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <form action="<?php echo e(url('/admin/deposit-packages/'.$p->id.'/toggle')); ?>" method="POST"><?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                <button class="btn btn-warning btn-sm"><i class="fa-solid fa-arrows-rotate"></i> Toggle</button>
              </form>
              <a class="btn btn-primary btn-sm" href="<?php echo e(url('/admin/deposit-packages/'.$p->id.'/edit')); ?>"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
              <form action="<?php echo e(url('/admin/deposit-packages/'.$p->id)); ?>" method="POST" onsubmit="return confirm('Delete this item?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr><td colspan="9" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No packages</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="mt-3"><?php echo e($packages->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/deposit_packages/index.blade.php ENDPATH**/ ?>