
<?php $__env->startSection('title','লোন ডিটেইলস'); ?>

<?php $__env->startSection('content'); ?>
<main class="mx-auto max-w-[520px] p-4" style="margin-bottom:100px;">
  <div class="rounded-3xl bg-white border border-slate-100 shadow-[0_24px_70px_-28px_rgba(47,170,166,.35)] overflow-hidden">

    
    <div class="h-2 w-full bg-gradient-to-r from-[#2FAAA6] via-[#1f8f8b] to-[#197c78]"></div>

    <div class="p-6">
      <div class="flex items-center justify-between gap-3">
        <h1 class="text-xl font-extrabold text-slate-800">
          লোন #<?php echo e($loan->id); ?>

        </h1>
        <span class="rounded-full px-2.5 py-1 text-xs font-semibold shadow-sm
          <?php if($loan->status === 'approved'): ?>
            bg-emerald-100 text-emerald-700
          <?php elseif($loan->status === 'rejected'): ?>
            bg-rose-100 text-rose-700
          <?php else: ?>
            bg-amber-100 text-amber-700
          <?php endif; ?>">
          <?php echo e(__('status.'. $loan->status) ?? ucfirst($loan->status)); ?>

        </span>
      </div>

      <?php if(session('success')): ?>
        <div class="mt-3 rounded-2xl border border-[#2FAAA6]/30 bg-[#2FAAA6]/10 px-4 py-3 text-[#2FAAA6] shadow-sm">
          <?php echo e(session('success')); ?>

        </div>
      <?php endif; ?>

      
      <div class="mt-4 grid grid-cols-2 gap-3 text-sm">
        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-3 shadow-xl">
          <div class="text-slate-500">লোনের পরিমাণ</div>
          <div class="mt-0.5 font-extrabold text-[#1f8f8b]">৳<?php echo e(number_format($loan->loan_amount)); ?></div>
        </div>
        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-3 shadow-xl">
          <div class="text-slate-500">মেয়াদ</div>
          <div class="mt-0.5 font-extrabold"><?php echo e($loan->loan_period); ?> মাস</div>
        </div>
        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-3 shadow-xl">
          <div class="text-slate-500">সুদের হার</div>
          <div class="mt-0.5 font-extrabold"><?php echo e(number_format($loan->interest_rate,2)); ?>%</div>
        </div>
        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-3 shadow-xl">
          <div class="text-slate-500">আনুমানিক মোট পরিশোধ</div>
          <div class="mt-0.5 font-extrabold">৳<?php echo e(number_format($loan->estimated_total,2)); ?></div>
        </div>
      </div>

      
      <?php if(isset($loan->calc_emi) || isset($loan->calc_total_interest) || isset($loan->calc_net_disbursed)): ?>
        <div class="mt-4 rounded-2xl border border-slate-200 bg-white p-4 shadow-xl text-sm">
          <div class="mb-2 font-semibold text-slate-800">ক্যালকুলেশন সারসংক্ষেপ</div>
          <div class="grid grid-cols-2 gap-3">
            <?php if(isset($loan->calc_emi)): ?>
              <div class="rounded-xl bg-slate-50 p-3">
                <div class="text-slate-500">মাসিক কিস্তি (EMI)</div>
                <div class="mt-0.5 text-lg font-extrabold text-[#2FAAA6]">৳<?php echo e(number_format($loan->calc_emi,2)); ?></div>
              </div>
            <?php endif; ?>
            <?php if(isset($loan->calc_total_interest)): ?>
              <div class="rounded-xl bg-slate-50 p-3">
                <div class="text-slate-500">মোট সুদ</div>
                <div class="mt-0.5 text-lg font-extrabold">৳<?php echo e(number_format($loan->calc_total_interest,2)); ?></div>
              </div>
            <?php endif; ?>
            <?php if(isset($loan->calc_total_payment)): ?>
              <div class="rounded-xl bg-slate-50 p-3">
                <div class="text-slate-500">মোট পরিশোধ</div>
                <div class="mt-0.5 text-lg font-extrabold">৳<?php echo e(number_format($loan->calc_total_payment,2)); ?></div>
              </div>
            <?php endif; ?>
            <?php if(isset($loan->calc_net_disbursed)): ?>
              <div class="rounded-xl bg-[#2FAAA6]/10 p-3">
                <div class="text-slate-700 font-semibold">হাতে পাওয়া টাকা</div>
                <div class="mt-0.5 text-lg font-extrabold text-[#1f8f8b]">৳<?php echo e(number_format($loan->calc_net_disbursed,2)); ?></div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      <?php endif; ?>

      
      <?php if($loan->image_path): ?>
        <div class="mt-5">
          <div class="mb-1 text-sm text-slate-500">ডকুমেন্ট</div>
          <img src="<?php echo e($loan->image_path); ?>" alt="Loan Document"
               class="rounded-2xl border border-slate-200 shadow-xl">
        </div>
      <?php endif; ?>

      
      <?php if($loan->repayments->count()): ?>
        <div class="mt-6">
          <div class="mb-2 font-semibold text-slate-800">রিপেমেন্ট সিডিউল</div>
          <div class="space-y-2">
            <?php $__currentLoopData = $loan->repayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="flex items-center justify-between rounded-2xl border border-slate-200 bg-white px-3 py-2 text-sm shadow-sm">
                <div class="text-slate-600"><?php echo e($r->due_date->format('d M Y')); ?></div>
                <div class="<?php echo e($r->status==='paid' ? 'text-emerald-700 font-semibold' : 'text-slate-700'); ?>">
                  ৳<?php echo e(number_format($r->amount,2)); ?>

                </div>
                <span class="rounded-full px-2 py-0.5 text-xs font-semibold
                  <?php echo e($r->status==='paid'
                      ? 'bg-emerald-100 text-emerald-700'
                      : ($r->status==='overdue' ? 'bg-rose-100 text-rose-700' : 'bg-amber-100 text-amber-700')); ?>">
                  <?php echo e(__('status.'.$r->status) ?? ucfirst($r->status)); ?>

                </span>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      <?php endif; ?>

      
    </div>
  </div>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_1\resources\views/frontend/loans/show.blade.php ENDPATH**/ ?>