<?php

use App\Http\Controllers\AddMoneyBankController;
use App\Http\Controllers\AddMoneyBankMethodController;
use App\Http\Controllers\AddMoneyCardSubmitController;
use App\Http\Controllers\AddMoneyController;
use App\Http\Controllers\Admin\ContactInboxController;
use App\Http\Controllers\Admin\LoanAdminController;
use App\Http\Controllers\Admin\PurchaseController as AdminPurchaseController;
use App\Http\Controllers\Admin\RateAdminController;
use App\Http\Controllers\Admin\UserBalanceController;
use App\Http\Controllers\AdminNotificationController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\PinController;
use App\Http\Controllers\backend\AddMoneyBankManager;
use App\Http\Controllers\backend\AddMoneyCardSubmitManager;
use App\Http\Controllers\backend\AddMoneyManager;
use App\Http\Controllers\backend\AdminDashboard;
use App\Http\Controllers\backend\AdminProfile;
use App\Http\Controllers\backend\BankController;
use App\Http\Controllers\backend\BankTransferManager;
use App\Http\Controllers\backend\BannerController;
use App\Http\Controllers\backend\BillerCategoryController;
use App\Http\Controllers\backend\BillerController;
use App\Http\Controllers\backend\BillPaymentManager;
use App\Http\Controllers\backend\CompanySetupController;
use App\Http\Controllers\backend\DepositPackageController;
use App\Http\Controllers\backend\ExchangeCountryController;
use App\Http\Controllers\backend\HeadlineController;
use App\Http\Controllers\backend\LoanManager;
use App\Http\Controllers\backend\LoanSettingController;
use App\Http\Controllers\backend\MobileGatewayController;
use App\Http\Controllers\backend\MobileTransactionManager;
use App\Http\Controllers\backend\OfferController;
use App\Http\Controllers\backend\OperatorController;
use App\Http\Controllers\backend\PaymentMethodController;
use App\Http\Controllers\backend\PurchaseManager;
use App\Http\Controllers\backend\RechargeManager;
use App\Http\Controllers\backend\RewardConversionManager;
use App\Http\Controllers\backend\RewardSettingController;
use App\Http\Controllers\backend\SettingController;
use App\Http\Controllers\backend\TransferManager;
use App\Http\Controllers\backend\UserController;
use App\Http\Controllers\BellNotificationController;
use App\Http\Controllers\ContactPageController;
use App\Http\Controllers\DownloadApp;
use App\Http\Controllers\Frontend\DepositPageController;
use App\Http\Controllers\Frontend\PaybillController;
use App\Http\Controllers\HelpController;
use App\Http\Controllers\HistoryController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Loan\ApplyController;
use App\Http\Controllers\NoticeActionController;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\Offers\BrowseController;
use App\Http\Controllers\PhoneLoginController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RechargeController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\RewardConversionController;
use App\Http\Controllers\SendMoneyController;
use App\Http\Controllers\StatementController;
use App\Http\Controllers\UploadAppController;
use App\Http\Controllers\User\BankTransferController as BankUser;
use App\Http\Controllers\User\MobileBankingController as UserMobile;

use App\Http\Controllers\User\RateController;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;


Route::get('/migrate', function () {
    Artisan::call('config:cache');
    Artisan::call('route:cache');
    Artisan::call('migrate');
    return 'migrate successfully!';
});

Route::middleware(['auth'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {

        Route::get('/users/balance', [UserBalanceController::class, 'index'])
            ->name('users.balance.index');

        Route::get('/users/{user}/balance', [UserBalanceController::class, 'edit'])
            ->name('users.balance.edit');

        Route::post('/users/{user}/balance', [UserBalanceController::class, 'update'])
            ->name('users.balance.update');
    });


Route::middleware(['auth'])->group(function () {

    // Full list page (See More)
    Route::get('/notifications', [BellNotificationController::class, 'index'])
        ->name('notifications.index');

    // Header dropdown real-time poll
    Route::get('/notifications/poll', [BellNotificationController::class, 'poll'])
        ->name('notifications.poll');

    // Single notification read
    Route::post('/notifications/{notification}/read', [BellNotificationController::class, 'markRead'])
        ->name('notifications.read');

    // All notifications read
    Route::post('/notifications/read-all', [BellNotificationController::class, 'markAllRead'])
        ->name('notifications.readAll');
});


// ==========================================
// =============frontend===================

Route::middleware(['auth', 'role:user', 'not.blocked','pin.verified'])->group(function () {

// ==========user-dashboard===========
    Route::get('/dashboard', [HomeController::class, 'dashboard'])->name('dashboard');


// ======add money===========
    Route::get('/add-money-methods',function(){return view("frontend.add-money-methods.index");});
    // =====add-money card and bank
    Route::get('/add-money/cards', [AddMoneyCardSubmitController::class, 'cards'])->name('add-money.cards.index');
    Route::get('/add-money/cards/{card}', [AddMoneyCardSubmitController::class, 'create'])->name('add-money.cards.create');
    Route::post('/add-money/cards/{card}', [AddMoneyCardSubmitController::class, 'store'])->name('add-money.cards.store');
    Route::get('/add-money-bank/methods',      [AddMoneyBankController::class, 'methods'])->name('addmoney_bank.methods');
    Route::get('/add-money-bank/transactions', [AddMoneyBankController::class, 'transactions'])->name('addmoney_bank.transactions');
    Route::get('/add-money-bank/success/{bank}', [AddMoneyBankController::class, 'success'])->name('addmoney_bank.success')->whereNumber('bank');
    Route::get('/add-money-bank/{slug}', [AddMoneyBankController::class, 'create'])->name('addmoney_bank.create')->where('slug', '[A-Za-z0-9\-_]+');
    Route::post('/add-money-bank/{slug}', [AddMoneyBankController::class, 'store'])->name('addmoney_bank.store')->where('slug', '[A-Za-z0-9\-_]+');
    Route::get('/add-money/cards/{submit}/success', [AddMoneyCardSubmitController::class, 'success'])->name('add-money.cards.success');
    // ====mobile-addmoney
    Route::get('/add-money', [AddMoneyController::class, 'methods'])->name('add-money.methods');
    Route::get('/add-money/{slug}', [AddMoneyController::class, 'create'])->name('add-money.create');
    Route::post('/add-money/{slug}', [AddMoneyController::class, 'store'])->name('add-money.store');
    Route::get('/transactions', [AddMoneyController::class, 'transactions'])->name('add-money.transactions');
    Route::get('/add-money/{deposit}/success', [AddMoneyController::class, 'success'])->name('add-money.success');
// ======add money===========



// =======send-money==========
    Route::get('/wallet/send', [SendMoneyController::class, 'create'])->name('wallet.send');
    Route::post('/wallet/send', [SendMoneyController::class, 'store'])->name('wallet.send.store');
    Route::get('/wallet/search-user', [SendMoneyController::class, 'searchUser'])->name('wallet.search');
    Route::get('/wallet/send/success/{transfer}', [SendMoneyController::class, 'success'])->name('wallet.send.success');
// =======send-money==========



// =======drive offer==========
    Route::get('/offers', [BrowseController::class, 'index'])->name('offers.index');
    Route::get('/offers/{offer}', [BrowseController::class, 'show'])->name('offers.show');
    Route::post('/offers/{offer}/purchase', [BrowseController::class, 'purchase'])->name('offers.purchase');
    Route::get('/offers/purchase/{purchase}/success', [BrowseController::class, 'success'])->name('offers.purchase.success');

// =======drive offer==========


// ======mobile recharge==========
    Route::get('/recharge', [RechargeController::class, 'index'])->name('recharge.index');
    Route::post('/recharge', [RechargeController::class, 'store'])->name('recharge.store');
    Route::get('/recharge/success/{recharge}', [RechargeController::class, 'success'])->name('recharge.success');
// ======mobile recharge==========


// =======spacial-offer==========
Route::get('/deposits', [DepositPageController::class, 'index'])->name('deposits.index');
// =======spacial-offer==========

// =========commition========
    Route::get('/rewards/convert', [RewardConversionController::class, 'index'])->name('rewards.convert.index');
    Route::post('/rewards/convert', [RewardConversionController::class, 'store'])->name('rewards.convert.store');
    Route::get('/rewards/convert/{conversion}/success', [RewardConversionController::class, 'success'])->name('rewards.convert.success');

// =========commition========

// ==========loan============
    Route::get('/loans/apply', [ApplyController::class, 'create'])->name('loans.apply');
    Route::post('/loans/apply', [ApplyController::class, 'store'])->name('loans.apply.store');
    Route::get('/loans/{loan}', [ApplyController::class, 'show'])->name('loans.show');
    Route::get('/loans/{loan}/success', [ApplyController::class, 'success'])->name('loans.success');
// ==========loan============


// ==========paybills============
    Route::get('/paybills', [PaybillController::class, 'index'])->name('paybills.index');
    Route::get('/paybills/{biller}', [PaybillController::class, 'show'])->name('paybills.show');
    Route::post('/paybills/{biller}', [PaybillController::class, 'pay'])->name('paybills.pay');
    Route::get('/paybills/success/{payment}', [PaybillController::class, 'success'])->name('paybills.success');
// ==========paybills============


// ========history-statement==========
    Route::get('/history', [HistoryController::class, 'index'])->name('history.index');
    Route::get('/statement', [StatementController::class, 'showForm'])->name('statement.form');
    Route::post('/statement', [StatementController::class, 'generate'])->name('statement.generate');
    Route::get('/statement/pdf/{transaction}', [StatementController::class, 'downloadPdf'])->name('statement.pdf');
// ========history-statement==========



// =====mobile banking==========
    Route::get('/mobile-banking', [UserMobile::class, 'redirectToDefault'])->name('user.mobile-banking.redirect');
    Route::get('/mobile-banking/{code}', [UserMobile::class, 'show'])->whereIn('code', ['bkash', 'nagad', 'rocket'])->name('user.mobile-banking.show');
    Route::post('/mobile-banking', [UserMobile::class, 'store'])->name('user.mobile-banking.store');
    Route::get('/mobile-banking/transactions/{transaction}/success',[UserMobile::class, 'success'])->name('user.mobile-banking.success');

// =====mobile banking==========


// ========banking===========
    Route::get('/banks', [BankUser::class, 'index'])->name('user.bank.index');
    Route::get('/banks/{bank:slug}', [BankUser::class, 'show'])->name('user.bank.show');
    Route::post('/banks/{bank:slug}', [BankUser::class, 'store'])->name('user.bank.store');
    Route::get('/bank-transfers/{transfer}/success', [BankUser::class, 'success'])->name('user.bank.transfer.success');
// ========banking===========


// ===========country-rates=======
    Route::get('/rates', [RateController::class, 'index'])->name('rates.index');
    Route::get('/rates/{country:slug}', [RateController::class, 'show'])->name('rates.show');
// ===========country-rates=======


// ==========contact============
Route::get('/contact', [ContactPageController::class, 'form'])->name('contact.simple');
Route::post('/contact', [ContactPageController::class, 'submit'])->name('contact.submit');
// ==========contact============

// ==========download-app==========
Route::get('/download-app', [DownloadApp::class, 'download'])->name('download.app');
// ==========download-app==========

// =============notice===============
    Route::get('/notices', [NoticeController::class, 'index'])->name('notices.index');
    Route::get('/notices/list', [NoticeController::class, 'list'])->name('notices.list');
    Route::get('/notices/unread-count', [NoticeActionController::class, 'count']);
    Route::post('/notices/read-all', [NoticeActionController::class, 'readAll'])->name('notices.readAll');
// =============notice===============

// =========profile==============
    Route::get('/account', [ProfileController::class, 'index'])->name('account.index');
    Route::post('/account/change-password', [ProfileController::class, 'changePassword'])->name('account.change-password');
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::get('/live-chat', [HelpController::class, 'help_desk'])->name('help_desk');
// =========profile==============
});
// =============frontend===================
// ========================================



// ============================================================================================================================
// ============================================================================================================================






// =========================================
// ============backend======================

// =======add money=========

Route::prefix('admin')->name('admin.')->group(function () {
    Route::resource('add-money-cards', \App\Http\Controllers\backend\AddMoneyCardController::class)->except(['show']);
});


Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/bank-deposits',                 [AddMoneyBankManager::class, 'index'])->name('bank-deposits.index');
    Route::post('/bank-deposits/{bank}/approve', [AddMoneyBankManager::class, 'approve'])->name('bank-deposits.approve');
    Route::post('/bank-deposits/{bank}/reject',  [AddMoneyBankManager::class, 'reject'])->name('bank-deposits.reject');
});


Route::prefix('admin/card-deposits')->name('admin.card-deposits.')->group(function () {
    Route::get('/', [AddMoneyCardSubmitManager::class, 'index'])->name('index');
    Route::post('{submit}/approve', [AddMoneyCardSubmitManager::class, 'approve'])->name('approve');
    Route::post('{submit}/reject', [AddMoneyCardSubmitManager::class, 'reject'])->name('reject');
});

 

Route::get('/bank-methods',            [AddMoneyBankMethodController::class, 'index'])->name('bank_methods.index');
Route::get('/bank-methods/create',      [AddMoneyBankMethodController::class, 'create'])->name('bank_methods.create');
Route::post('/bank-methods',           [AddMoneyBankMethodController::class, 'store'])->name('bank_methods.store');
Route::get('/bank-methods/{id}/edit',   [AddMoneyBankMethodController::class, 'edit'])->name('bank_methods.edit');
Route::put('/bank-methods/{id}',        [AddMoneyBankMethodController::class, 'update'])->name('bank_methods.update');
Route::delete('/bank-methods/{id}',     [AddMoneyBankMethodController::class, 'destroy'])->name('bank_methods.destroy');
Route::patch('/bank-methods/{id}/toggle', [AddMoneyBankMethodController::class, 'toggle'])->name('bank_methods.toggle');

// =======add money=========




Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {

        // List + single-blade actions page
        Route::get('/deposits', [\App\Http\Controllers\backend\AddMoneyManager::class, 'index'])
            ->name('deposits.index');

        // Approve / Reject (correct URI and route names)
        Route::post('/deposits/{deposit}/approve', [\App\Http\Controllers\backend\AddMoneyManager::class, 'approve'])
            ->name('deposits.approve');

        Route::post('/deposits/{deposit}/reject', [\App\Http\Controllers\backend\AddMoneyManager::class, 'reject'])
            ->name('deposits.reject');
            
    Route::get('/dashboard', [\App\Http\Controllers\backend\AdminDashboard::class, 'dashboard'])->name('dashboard');

    // ===============bank transfer======================
    Route::get('/bank-transfers', [BankTransferManager::class, 'index'])
        ->name('bank_transfers.index');

    Route::post('/bank-transfers/{transfer}/approve', [BankTransferManager::class, 'approve'])
        ->name('bank_transfers.approve');

    Route::post('/bank-transfers/{transfer}/reject', [BankTransferManager::class, 'reject'])
        ->name('bank_transfers.reject');

    // ==============mobile - transaction================

    Route::get('/mobile-transactions', [MobileTransactionManager::class, 'index'])
        ->name('mobile_tx.index');

    Route::post('/mobile-transactions/{tx}/approve', [MobileTransactionManager::class, 'approve'])
        ->name('mobile_tx.approve');

    Route::post('/mobile-transactions/{tx}/reject', [MobileTransactionManager::class, 'reject'])
        ->name('mobile_tx.reject');

    // =============Loan applications =============
    Route::get('/loans', [LoanManager::class, 'index'])->name('loans.index');
    Route::post('/loans/{loan}/approve', [LoanManager::class, 'approve'])->name('loans.approve');
    Route::post('/loans/{loan}/reject', [LoanManager::class, 'reject'])->name('loans.reject');
    Route::get('/loans/{loan}/repayments', [LoanManager::class, 'repayments'])->name('loans.repayments');
    Route::post('/loans/repayments/{repayment}/mark-paid', [LoanManager::class, 'markPaid'])->name('loans.repayments.mark_paid');

    // ==========bill payment=================

    Route::get('/bill-payments', [BillPaymentManager::class, 'index'])
        ->name('bill_payments.index');

    Route::post('/bill-payments/{payment}/succeed', [BillPaymentManager::class, 'succeed'])
        ->name('bill_payments.succeed');

    Route::post('/bill-payments/{payment}/fail', [BillPaymentManager::class, 'fail'])
        ->name('bill_payments.fail');

    // ========reward-conversions===============

    Route::get('/reward-conversions', [RewardConversionManager::class, 'index'])->name('reward_conversions.index');
    Route::delete('/reward-conversions/{conversion}', [RewardConversionManager::class, 'destroy'])->name('reward_conversions.destroy');

    // ========recharges==============
    Route::get('/recharges', [RechargeManager::class, 'index'])->name('recharges.index');
    Route::post('/recharges/{recharge}/succeed', [RechargeManager::class, 'succeed'])->name('recharges.succeed');
    Route::post('/recharges/{recharge}/fail', [RechargeManager::class, 'fail'])->name('recharges.fail');

    // =======purchases================
    // Purchases list
    Route::get('/purchases', [PurchaseManager::class, 'index'])->name('purchases.index');
    Route::post('/purchases/{purchase}/succeed', [PurchaseManager::class, 'succeed'])->name('purchases.succeed');
    Route::post('/purchases/{purchase}/fail', [PurchaseManager::class, 'fail'])->name('purchases.fail');

    // ============ Transfers =====================
    Route::get('/transfers', [TransferManager::class, 'index'])->name('transfers.index');



    Route::post('/transfers/{transfer}/approve', [TransferManager::class, 'approve'])->name('transfers.approve');
    Route::post('/transfers/{transfer}/reject',  [TransferManager::class, 'reject'])->name('transfers.reject');
    Route::post('/transfers/{transfer}/reverse', [TransferManager::class, 'reverse'])->name('transfers.reverse');

});



// ============backend======================
// =========================================













Route::prefix('admin')->middleware(['auth'])->group(function () {
    Route::get('upload-apps',          [UploadAppController::class, 'index'])->name('upload-apps.index');
    Route::get('upload-apps/create',   [UploadAppController::class, 'create'])->name('upload-apps.create');
    Route::post('upload-apps',         [UploadAppController::class, 'store'])->name('upload-apps.store');
    Route::get('upload-apps/{app}/edit', [UploadAppController::class, 'edit'])->name('upload-apps.edit');
    Route::put('upload-apps/{app}',    [UploadAppController::class, 'update'])->name('upload-apps.update');
    Route::delete('upload-apps/{app}', [UploadAppController::class, 'destroy'])->name('upload-apps.destroy');
});







Route::get('/storage-link', function () {
    Artisan::call('config:cache');
    Artisan::call('route:cache');
    Artisan::call('storage:link');
    return 'Storage link created successfully!';
});



// Headlines (single page index/create/edit)
Route::get('/headlines',                [HeadlineController::class, 'index'])->name('headlines.index');
Route::post('/headlines',               [HeadlineController::class, 'store'])->name('headlines.store');
Route::get('/headlines/{id}/edit',      [HeadlineController::class, 'edit'])->name('headlines.edit');
Route::put('/headlines/{id}',           [HeadlineController::class, 'update'])->name('headlines.update');
Route::delete('/headlines/{id}',        [HeadlineController::class, 'destroy'])->name('headlines.destroy');
 

// ইচ্ছা করলে middleware('auth') ব্যবহার করুন
Route::get('/company-setups',                [CompanySetupController::class, 'index'])->name('company-setups.index');
Route::get('/company-setups/create',         [CompanySetupController::class, 'create'])->name('company-setups.create');
Route::post('/company-setups',               [CompanySetupController::class, 'store'])->name('company-setups.store');
Route::get('/company-setups/{companySetup}/edit', [CompanySetupController::class, 'edit'])->name('company-setups.edit');
Route::put('/company-setups/{companySetup}', [CompanySetupController::class, 'update'])->name('company-setups.update');
Route::delete('/company-setups/{companySetup}', [CompanySetupController::class, 'destroy'])->name('company-setups.destroy');





// Public/User contact page


// Admin inbox
Route::prefix('admin')->middleware('auth')->group(function(){
    Route::get('/contact-inbox', [ContactInboxController::class, 'index'])->name('admin.contact.index');
    Route::get('/contact-inbox/{message}', [ContactInboxController::class, 'show'])->name('admin.contact.show');
    Route::post('/contact-inbox/{message}/read', [ContactInboxController::class, 'markRead'])->name('admin.contact.read');
    Route::post('/contact-inbox/{message}/unread', [ContactInboxController::class, 'markUnread'])->name('admin.contact.unread');
    Route::post('/contact-inbox/{message}/archive', [ContactInboxController::class, 'archive'])->name('admin.contact.archive');
    Route::delete('/contact-inbox/{message}', [ContactInboxController::class, 'destroy'])->name('admin.contact.destroy');
});



 
 
 Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    // List + basic actions
    Route::get('/users',            [UserController::class, 'list'])->name('users.list');
    Route::get('/users/create',     [UserController::class, 'create'])->name('users.create');
    Route::post('/users/store',     [UserController::class, 'store'])->name('users.store');
    Route::get('/users/{user}/edit',[UserController::class, 'edit'])->name('users.edit');
    Route::post('/users/{user}/update', [UserController::class, 'update'])->name('users.update'); // no PUT
    Route::post('/users/{user}/delete', [UserController::class, 'destroy'])->name('users.delete'); // no DELETE
    Route::post('/users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggle-status'); // no PATCH
    Route::post('/users/{user}/device-lock', [UserController::class, 'deviceLock'])
        ->name('users.device-lock');
});
// ✅ Admin Dashboard Routes


Route::middleware(['auth'])->group(function () {
    Route::get('/admin/notifications', [AdminNotificationController::class, 'index'])
        ->name('admin.notifications.index');
    Route::post('/admin/notifications/{id}/read', [AdminNotificationController::class, 'markRead'])
        ->name('admin.notifications.read');
    Route::post('/admin/notifications/read-all', [AdminNotificationController::class, 'markAllRead'])
        ->name('admin.notifications.readAll');
});

Route::get('admin/notf', function () {
    return view('layouts.admin');
});

// =================================================
// ==================== backend ============================
Route::middleware(['auth', 'role:admin'])->group(function () {
    Route::resource('reward-settings', \App\Http\Controllers\backend\RewardSettingController::class);
    // =========payment-methods==============
    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/payment-methods', [\App\Http\Controllers\backend\PaymentMethodController::class, 'index']);
        Route::get('/admin/payment-methods/create', [\App\Http\Controllers\backend\PaymentMethodController::class, 'create']);
        Route::post('/admin/payment-methods', [\App\Http\Controllers\backend\PaymentMethodController::class, 'store']);
        Route::get('/admin/payment-methods/{id}', [\App\Http\Controllers\backend\PaymentMethodController::class, 'show']);
        Route::get('/admin/payment-methods/{id}/edit', [\App\Http\Controllers\backend\PaymentMethodController::class, 'edit']);
        Route::put('/admin/payment-methods/{id}', [\App\Http\Controllers\backend\PaymentMethodController::class, 'update']);
        Route::delete('/admin/payment-methods/{id}', [\App\Http\Controllers\backend\PaymentMethodController::class, 'destroy']);
        Route::patch('/admin/payment-methods/{id}/toggle', [\App\Http\Controllers\backend\PaymentMethodController::class, 'toggle']);
    });

    // =========operators==============
    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/operators', [OperatorController::class, 'index']);
        Route::get('/admin/operators/create', [OperatorController::class, 'create']);
        Route::post('/admin/operators', [OperatorController::class, 'store']);
        Route::get('/admin/operators/{id}', [OperatorController::class, 'show']);
        Route::get('/admin/operators/{id}/edit', [OperatorController::class, 'edit']);
        Route::put('/admin/operators/{id}', [OperatorController::class, 'update']);
        Route::delete('/admin/operators/{id}', [OperatorController::class, 'destroy']);
        Route::patch('/admin/operators/{id}/toggle', [OperatorController::class, 'toggle']);
    });

    // =========offers==============
    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/offers', [OfferController::class, 'index']);
        Route::get('/admin/offers/create', [OfferController::class, 'create']);
        Route::post('/admin/offers', [OfferController::class, 'store']);
        Route::get('/admin/offers/{id}', [OfferController::class, 'show']);
        Route::get('/admin/offers/{id}/edit', [OfferController::class, 'edit']);
        Route::put('/admin/offers/{id}', [OfferController::class, 'update']);
        Route::delete('/admin/offers/{id}', [OfferController::class, 'destroy']);
        Route::patch('/admin/offers/{id}/toggle', [OfferController::class, 'toggle']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        // Deposit Packages
        Route::get('/admin/deposit-packages', [DepositPackageController::class, 'index']);
        Route::get('/admin/deposit-packages/create', [DepositPackageController::class, 'create']);
        Route::post('/admin/deposit-packages', [DepositPackageController::class, 'store']);
        Route::get('/admin/deposit-packages/{id}', [DepositPackageController::class, 'show']);
        Route::get('/admin/deposit-packages/{id}/edit', [DepositPackageController::class, 'edit']);
        Route::put('/admin/deposit-packages/{id}', [DepositPackageController::class, 'update']);
        Route::delete('/admin/deposit-packages/{id}', [DepositPackageController::class, 'destroy']);
        Route::patch('/admin/deposit-packages/{id}/toggle', [DepositPackageController::class, 'toggle']);

        // Settings
        // Route::get('/admin/settings', [SettingController::class, 'index']);
        // Route::post('/admin/settings', [SettingController::class, 'store']);   // add new row
        // Route::put('/admin/settings', [SettingController::class, 'update']);  // bulk update
        // Route::delete('/admin/settings/{id}', [SettingController::class, 'destroy']);
    });


    

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/biller-categories', [BillerCategoryController::class, 'index']);
        Route::get('/admin/biller-categories/create', [BillerCategoryController::class, 'create']);
        Route::post('/admin/biller-categories', [BillerCategoryController::class, 'store']);
        Route::get('/admin/biller-categories/{id}', [BillerCategoryController::class, 'show']);
        Route::get('/admin/biller-categories/{id}/edit', [BillerCategoryController::class, 'edit']);
        Route::put('/admin/biller-categories/{id}', [BillerCategoryController::class, 'update']);
        Route::delete('/admin/biller-categories/{id}', [BillerCategoryController::class, 'destroy']);
        Route::patch('/admin/biller-categories/{id}/toggle', [BillerCategoryController::class, 'toggle']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/billers', [BillerController::class, 'index']);
        Route::get('/admin/billers/create', [BillerController::class, 'create']);
        Route::post('/admin/billers', [BillerController::class, 'store']);
        Route::get('/admin/billers/{id}', [BillerController::class, 'show']);
        Route::get('/admin/billers/{id}/edit', [BillerController::class, 'edit']);
        Route::put('/admin/billers/{id}', [BillerController::class, 'update']);
        Route::delete('/admin/billers/{id}', [BillerController::class, 'destroy']);
        Route::patch('/admin/billers/{id}/toggle', [BillerController::class, 'toggle']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/loan-settings', [LoanSettingController::class, 'index']);
        Route::get('/admin/loan-settings/create', [LoanSettingController::class, 'create']);
        Route::post('/admin/loan-settings', [LoanSettingController::class, 'store']);
        Route::get('/admin/loan-settings/{id}', [LoanSettingController::class, 'show']);
        Route::get('/admin/loan-settings/{id}/edit', [LoanSettingController::class, 'edit']);
        Route::put('/admin/loan-settings/{id}', [LoanSettingController::class, 'update']);
        Route::delete('/admin/loan-settings/{id}', [LoanSettingController::class, 'destroy']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/mobile-gateways', [MobileGatewayController::class, 'index']);
        Route::get('/admin/mobile-gateways/create', [MobileGatewayController::class, 'create']);
        Route::post('/admin/mobile-gateways', [MobileGatewayController::class, 'store']);
        Route::get('/admin/mobile-gateways/{id}', [MobileGatewayController::class, 'show']);
        Route::get('/admin/mobile-gateways/{id}/edit', [MobileGatewayController::class, 'edit']);
        Route::put('/admin/mobile-gateways/{id}', [MobileGatewayController::class, 'update']);
        Route::delete('/admin/mobile-gateways/{id}', [MobileGatewayController::class, 'destroy']);
        Route::patch('/admin/mobile-gateways/{id}/toggle', [MobileGatewayController::class, 'toggle']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/banks', [BankController::class, 'index']);
        Route::get('/admin/banks/create', [BankController::class, 'create']);
        Route::post('/admin/banks', [BankController::class, 'store']);
        Route::get('/admin/banks/{id}', [BankController::class, 'show']);
        Route::get('/admin/banks/{id}/edit', [BankController::class, 'edit']);
        Route::put('/admin/banks/{id}', [BankController::class, 'update']);
        Route::delete('/admin/banks/{id}', [BankController::class, 'destroy']);
        Route::patch('/admin/banks/{id}/toggle', [BankController::class, 'toggle']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/exchange-countries', [ExchangeCountryController::class, 'index']);
        Route::get('/admin/exchange-countries/create', [ExchangeCountryController::class, 'create']);
        Route::post('/admin/exchange-countries', [ExchangeCountryController::class, 'store']);
        Route::get('/admin/exchange-countries/{id}', [ExchangeCountryController::class, 'show']);
        Route::get('/admin/exchange-countries/{id}/edit', [ExchangeCountryController::class, 'edit']);
        Route::put('/admin/exchange-countries/{id}', [ExchangeCountryController::class, 'update']);
        Route::delete('/admin/exchange-countries/{id}', [ExchangeCountryController::class, 'destroy']);
        Route::patch('/admin/exchange-countries/{id}/toggle', [ExchangeCountryController::class, 'toggle']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/banners', [BannerController::class, 'index']);
        Route::get('/admin/banners/create', [BannerController::class, 'create']);
        Route::post('/admin/banners', [BannerController::class, 'store']);
        Route::get('/admin/banners/{id}', [BannerController::class, 'show']);
        Route::get('/admin/banners/{id}/edit', [BannerController::class, 'edit']);
        Route::put('/admin/banners/{id}', [BannerController::class, 'update']);
        Route::delete('/admin/banners/{id}', [BannerController::class, 'destroy']);
        Route::patch('/admin/banners/{id}/toggle', [BannerController::class, 'toggle']);
    });

    Route::middleware(['web', 'auth'])->group(function () {
        Route::get('/admin/notices', [\App\Http\Controllers\backend\NoticeController::class, 'index']);
        Route::get('/admin/notices/create', [\App\Http\Controllers\backend\NoticeController::class, 'create']);
        Route::post('/admin/notices', [\App\Http\Controllers\backend\NoticeController::class, 'store']);
        Route::get('/admin/notices/{id}', [\App\Http\Controllers\backend\NoticeController::class, 'show']);
        Route::get('/admin/notices/{id}/edit', [\App\Http\Controllers\backend\NoticeController::class, 'edit']);
        Route::put('/admin/notices/{id}', [\App\Http\Controllers\backend\NoticeController::class, 'update']);
        Route::delete('/admin/notices/{id}', [\App\Http\Controllers\backend\NoticeController::class, 'destroy']);
    });
});


Route::prefix('admin')->group(function () {
    Route::get('settings', [SettingController::class, 'index'])->name('admin.settings.index');
    Route::post('settings', [SettingController::class, 'store'])->name('admin.settings.store');
    // bulk update (PUT to /admin/settings)
    Route::put('settings', [SettingController::class, 'update'])->name('admin.settings.update');
    // single delete (DELETE to /admin/settings/{id})
    Route::delete('settings/{id}', [SettingController::class, 'destroy'])->name('admin.settings.destroy');
});

// ==================== backend ============================
// =================================================


Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/rates', [RateAdminController::class, 'index'])->name('rates.index');
    Route::post('/rates', [RateAdminController::class, 'store'])->name('rates.store');
    Route::post('/rates/{country}', [RateAdminController::class, 'update'])->name('rates.update');
    Route::post('/rates/{country}/toggle', [RateAdminController::class, 'toggle'])->name('rates.toggle');
});


// Admin
Route::prefix('admin')->name('admin.')->middleware(['web', 'auth'])->group(function () {
    Route::get('/loans', [LoanAdminController::class, 'index'])->name('loans.index');
    Route::get('/loans/{loan}', [LoanAdminController::class, 'show'])->name('loans.show');
    Route::post('/loans/{loan}/approve', [LoanAdminController::class, 'approve'])->name('loans.approve');
    Route::post('/loans/{loan}/reject', [LoanAdminController::class, 'reject'])->name('loans.reject');
    Route::post('/loans/{loan}/repayments/{repayment}/paid', [LoanAdminController::class, 'markPaid'])->name('loans.repayments.paid');
});



Route::get('admin/purchases', [AdminPurchaseController::class, 'index'])->name('admin.purchases.index');
Route::get('admin/purchases/{purchase}', [AdminPurchaseController::class, 'show'])->name('admin.purchases.show');

Route::get('/admin/offers', [OfferController::class, 'index'])->name('admin.offers.index');
Route::get('/admin/offers/create', [OfferController::class, 'create'])->name('admin.offers.create');
Route::post('/admin/offers', [OfferController::class, 'store'])->name('admin.offers.store');
Route::get('/admin/offers/{offer}/edit', [OfferController::class, 'edit'])->name('admin.offers.edit');
Route::put('/admin/offers/{offer}', [OfferController::class, 'update'])->name('admin.offers.update');
Route::delete('/admin/offers/{offer}', [OfferController::class, 'destroy'])->name('admin.offers.destroy');
Route::get('/admin/offers/{offer}', [OfferController::class, 'show'])->name('admin.offers.show');


 // (optional) create UI
    Route::get('/notices/create', [NoticeController::class, 'create'])->name('notices.create');
    Route::post('/notices', [NoticeController::class, 'store'])->name('notices.store');





Route::get('/me/balance', function () {
    abort_unless(auth()->check(), 403);

    return response()->json([
        'balance' => number_format(auth()->user()->balance ?? 0, 2),
    ]);
})->name('me.balance')->middleware('auth');


 

Route::get('/register', [RegisterController::class, 'create'])->name('register.create');
Route::post('/register/step1', [RegisterController::class, 'storeStep1'])->name('register.step1.store');
Route::get('/register/password', [RegisterController::class, 'showStep2'])->name('register.step2.show');
Route::post('/register/password', [RegisterController::class, 'storeStep2'])->name('register.step2.store');
Route::get('/register/pin', [RegisterController::class, 'showStep3'])->name('register.step3.show');
Route::post('/register/pin', [RegisterController::class, 'storeStep3'])->name('register.step3.store');
Route::get('/register/otp', [RegisterController::class, 'showOtpForm'])->name('register.otp.form');
Route::post('/register/otp', [RegisterController::class, 'verifyOtp'])->name('register.otp.verify');
Route::get('/login', [LoginController::class, 'showLogin'])->name('login');
Route::post('/login', [LoginController::class, 'attemptLogin'])->middleware('throttle:5,1')->name('login.attempt');
Route::get('/verify-otp', [LoginController::class, 'showOtpForm'])->name('otp.verify.form');
Route::post('/verify-otp', [LoginController::class, 'verifyOtp'])->middleware('throttle:10,1')->name('otp.verify');
Route::post('/resend-otp', [LoginController::class, 'resendOtp'])->middleware('throttle:3,1')->name('otp.resend');
Route::get('/pin', [PinController::class, 'show'])->name('pin.form');
Route::post('/pin', [PinController::class, 'verify'])->name('pin.verify');




// =====================
// PHONE PREFIXED ROUTES
// =====================
    Route::get('/phone/login', [PhoneLoginController::class, 'showLoginForm'])->name('phone.login');
    Route::post('/phone/login', [PhoneLoginController::class, 'login'])->name('phone.login.submit');
    Route::get('/phone/login/otp', [PhoneLoginController::class, 'showOtpForm'])->name('phone.login.otp');
    Route::post('/phone/login/otp', [PhoneLoginController::class, 'submitOtp'])->name('phone.login.otp.submit');
    Route::get('/phone/login/pin', [PhoneLoginController::class, 'showPinForm'])->name('phone.login.pin');
    Route::post('/phone/login/pin', [PhoneLoginController::class, 'verifyPin'])->name('phone.login.pin.submit');

 




Route::post('/logout', function () {
    auth()->logout();
    request()->session()->invalidate();
    request()->session()->regenerateToken();
    request()->session()->forget('pin.verified');

    return redirect()->route('login');
})->name('logout')->middleware('auth');











// Route::middleware(['auth'])->group(function () {
// Route::get('admin/profile', [AdminProfile::class, 'edit'])->name('admin.profile.edit');
// Route::put('admin/profile', [AdminProfile::class, 'update'])->name('admin.profile.update');
// });


Route::middleware(['auth','verified'])->group(function () {
    Route::get('/admin/profile', [AdminProfile::class,'edit'])->name('admin.profile.edit');

    // Card 1: avatar
    Route::post('/admin/profile/avatar', [AdminProfile::class,'updateAvatar'])->name('admin.profile.avatar.update');
    Route::delete('/admin/profile/avatar', [AdminProfile::class,'destroyAvatar'])->name('admin.profile.avatar.destroy');

    // Card 2: info
    Route::put('/admin/profile/info', [AdminProfile::class,'updateInfo'])->name('admin.profile.info.update');

    // Card 4: password
    Route::put('/admin/profile/password', [AdminProfile::class,'updatePassword'])->name('admin.profile.password.update');
});



Route::get('/', function () {
    if (auth()->check()) {
        return redirect()->route(auth()->user()->role === 'admin' ? 'admin.dashboard' : 'dashboard');
    }
    return redirect()->route('phone.login');
});
