@extends('layouts.app')
@section('title','লেনদেন সফল হয়েছে')

@push('styles')
  <style>
    body {
      font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }
  </style>
@endpush

@section('content')
@php
    $amount = (float) $transfer->amount;
    $date   = optional($transfer->created_at)->format('d-m-Y');
    $status = $transfer->status;

    $statusText = 'অপেক্ষমান';
    $statusClass = 'text-amber-500';

    if ($status === 'succeeded' || $status === 'approved') {
        $statusText  = 'সফল হয়েছে';
        $statusClass = 'text-emerald-500';
    } elseif ($status === 'failed' || $status === 'rejected') {
        $statusText  = 'ব্যর্থ হয়েছে';
        $statusClass = 'text-rose-500';
    }
@endphp

<div class="min-h-screen bg-white flex items-center justify-center px-4 py-8">
  <div class="w-full max-w-sm">

    {{-- main card --}}
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 p-6 text-center">

      {{-- green icon --}}
      <div class="w-16 h-16 mx-auto rounded-full bg-emerald-500 flex items-center justify-center mb-3">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-9 w-9 text-white" viewBox="0 0 24 24" fill="none">
          <path d="M9.00039 16.2L4.80039 12L3.40039 13.4L9.00039 19L21.0004 7.00001L19.6004 5.60001L9.00039 16.2Z"
                fill="currentColor"/>
        </svg>
      </div>

      <h1 class="text-base sm:text-lg font-bold text-slate-900 mb-1">
        লেনদেন সফল হয়েছে
      </h1>

      <div class="text-xs text-sky-600 mb-4">
        Send Money
      </div>

      {{-- details box --}}
      <div class="mt-1 w-full rounded-xl border border-slate-200 bg-slate-50/60 text-sm text-slate-800 overflow-hidden">
        <div class="px-4 py-2.5 flex items-center justify-between border-b border-slate-200">
          <span>পরিমাণঃ</span>
          <span>৳{{ number_format($amount, 2) }}</span>
        </div>
        <div class="px-4 py-2.5 flex items-center justify-between border-b border-slate-200">
          <span>অবস্থাঃ</span>
          <span class="{{ $statusClass }}">{{ $statusText }}</span>
        </div>
        <div class="px-4 py-2.5 flex items-center justify-between">
          <span>তারিখঃ</span>
          <span>{{ $date }}</span>
        </div>
      </div>
    </div>

    {{-- bottom button --}}
    <div class="mt-4">
      <a href="{{ url('/') }}"
         class="block w-full text-center rounded-full bg-emerald-500 hover:bg-emerald-600 text-white font-semibold text-sm py-2.5 shadow-md">
        হোমে ফিরে যান
      </a>
    </div>
  </div>
</div>
@endsection
