{{-- resources/views/frontend/statement/pdf.blade.php --}}
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>Transaction Statement - #{{ $transaction->id }}</title>
    <style>
        /* PDF friendly basic styles */
        * {
            box-sizing: border-box;
        }
        body {
            margin: 0;
            padding: 24px;
            font-family: DejaVu Sans, Arial, Helvetica, sans-serif;
            font-size: 12px;
            color: #0f172a;
            background: #f3f4f6;
        }
        .page {
            background: #ffffff;
            padding: 20px 22px;
            border-radius: 12px;
        }
        h1,h2,h3,h4,h5,h6 {
            margin: 0;
            padding: 0;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 16px;
        }
        .brand-title {
            font-size: 18px;
            font-weight: 700;
            letter-spacing: .06em;
            text-transform: uppercase;
            color: #059669;
        }
        .sub-muted {
            font-size: 11px;
            color: #6b7280;
        }
        .chip {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 999px;
            font-size: 10px;
            font-weight: 600;
        }
        .chip-success {
            background: #dcfce7;
            color: #15803d;
        }
        .chip-danger {
            background: #fee2e2;
            color: #b91c1c;
        }
        .chip-neutral {
            background: #e5e7eb;
            color: #374151;
        }
        .section-title {
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: .12em;
            color: #6b7280;
            margin-bottom: 4px;
        }
        .divider {
            border-bottom: 1px solid #e5e7eb;
            margin: 10px 0 14px;
        }
        .grid-2 {
            display: table;
            width: 100%;
            table-layout: fixed;
        }
        .grid-2 > div {
            display: table-cell;
            vertical-align: top;
            padding-right: 16px;
        }
        .grid-2 > div:last-child {
            padding-right: 0;
        }
        .info-row {
            margin-bottom: 6px;
            font-size: 11px;
        }
        .info-label {
            color: #6b7280;
        }
        .info-value {
            font-weight: 600;
            color: #111827;
        }
        .amount-box {
            border-radius: 10px;
            border: 1px solid #e5e7eb;
            padding: 10px 12px;
            margin-top: 6px;
        }
        .amount-main {
            font-size: 18px;
            font-weight: 700;
        }
        .amount-credit {
            color: #15803d;
        }
        .amount-debit {
            color: #b91c1c;
        }
        .small-muted {
            font-size: 10px;
            color: #9ca3af;
        }
        .footer {
            margin-top: 20px;
            border-top: 1px dashed #d1d5db;
            padding-top: 8px;
            font-size: 9px;
            color: #9ca3af;
            display: flex;
            justify-content: space-between;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 6px;
        }
        .table td {
            padding: 5px 4px;
            font-size: 11px;
        }
        .table tr:nth-child(odd) {
            background: #f9fafb;
        }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
    </style>
</head>
<body>
@php
    // meta already passed from controller, but ensure array
    if (!is_array($meta)) {
        $meta = json_decode($meta ?? '[]', true) ?? [];
    }

    $ref        = $meta['reference_code'] ?? ('TX-'.$transaction->id);
    $status     = $meta['status'] ?? 'Success';
    $trxType    = $meta['trx_type'] ?? ucfirst($transaction->type);
    $cardBrand  = $meta['card_brand'] ?? null;
    $details    = $meta['details'] ?? $trxType;

    $isCredit   = $transaction->type === 'credit';
    $oldBalance = $isCredit
        ? $transaction->balance_after - $transaction->amount
        : $transaction->balance_after + $transaction->amount;

    $account    = $user->phone ?? $user->email ?? 'N/A';
@endphp

<div class="page">
    {{-- Header --}}
    <div class="header">
        <div>
            <div class="brand-title">ACCOUNT STATEMENT</div>
            <div class="sub-muted">
                Single Transaction Summary
            </div>
        </div>
        <div class="text-right">
            <div class="sub-muted">Generated At</div>
            <div style="font-size:11px;font-weight:600;color:#111827;">
                {{ now()->format('d M Y, h:i A') }}
            </div>
            <div style="margin-top:4px;">
                <span class="chip chip-neutral">ID: #{{ $transaction->id }}</span>
            </div>
        </div>
    </div>

    <div class="divider"></div>

    {{-- User + transaction overview --}}
    <div class="grid-2" style="margin-bottom: 10px;">
        {{-- Left: User info --}}
        <div>
            <div class="section-title">Account Holder</div>

            <div class="info-row">
                <span class="info-label">Name: </span>
                <span class="info-value">{{ $user->name }}</span>
            </div>

            <div class="info-row">
                <span class="info-label">Account: </span>
                <span class="info-value">{{ $account }}</span>
            </div>

            <div class="info-row">
                <span class="info-label">Transaction ID: </span>
                <span class="info-value">{{ $ref }}</span>
            </div>

            <div class="info-row">
                <span class="info-label">Date &amp; Time: </span>
                <span class="info-value">
                    {{ $transaction->created_at->format('d M Y, h:i A') }}
                </span>
            </div>
        </div>

        {{-- Right: Amount summary --}}
        <div>
            <div class="section-title">Transaction Summary</div>

            <div class="amount-box">
                <div class="info-row">
                    <span class="info-label">Type: </span>
                    <span class="info-value">{{ $trxType }}</span>
                </div>

                <div class="info-row">
                    <span class="info-label">Direction: </span>
                    <span class="info-value">{{ ucfirst($transaction->type) }}</span>
                </div>

                @if($cardBrand)
                    <div class="info-row">
                        <span class="info-label">Source: </span>
                        <span class="info-value">{{ $cardBrand }}</span>
                    </div>
                @endif

                <div style="margin-top:6px;">
                    <div class="small-muted">Amount</div>
                    <div class="amount-main {{ $isCredit ? 'amount-credit' : 'amount-debit' }}">
                        {{ $isCredit ? '+' : '-' }}৳{{ number_format($transaction->amount, 2) }}
                    </div>
                </div>

                <div style="margin-top:6px;font-size:10px;">
                    <div><span class="info-label">Old Balance:</span> ৳{{ number_format($oldBalance, 2) }}</div>
                    <div><span class="info-label">New Balance:</span> ৳{{ number_format($transaction->balance_after, 2) }}</div>
                </div>
            </div>
        </div>
    </div>

    {{-- Status / meta table --}}
    <div style="margin-top:4px;">
        <div class="section-title">Status &amp; Details</div>

        <table class="table">
            <tr>
                <td>Current Status</td>
                <td>
                    @php $statusLower = strtolower($status); @endphp
                    @if($statusLower === 'success' || $statusLower === 'approved' || $statusLower === 'completed')
                        <span class="chip chip-success">{{ ucfirst($statusLower) }}</span>
                    @elseif($statusLower === 'rejected' || $statusLower === 'failed')
                        <span class="chip chip-danger">{{ ucfirst($statusLower) }}</span>
                    @else
                        <span class="chip chip-neutral">{{ ucfirst($statusLower) }}</span>
                    @endif
                </td>
            </tr>
            <tr>
                <td>Description</td>
                <td>{{ $details }}</td>
            </tr>
            <tr>
                <td>Reference Code</td>
                <td>{{ $ref }}</td>
            </tr>
            <tr>
                <td>Account</td>
                <td>{{ $account }}</td>
            </tr>
            <tr>
                <td>Charge</td>
                <td>৳0.00</td>
            </tr>
            <tr>
                <td>Note</td>
                <td>
                    This is a system generated statement for a single transaction.
                    Keep this PDF for your records.
                </td>
            </tr>
        </table>
    </div>

    {{-- Footer --}}
    <div class="footer">
        <div>
            © {{ date('Y') }} &mdash; Your App Name  
            <br>Generated automatically. No signature required.
        </div>
        <div class="text-right">
            Transaction ID: {{ $ref }}<br>
            User ID: #{{ $user->id }}
        </div>
    </div>
</div>
</body>
</html>
