@extends('layouts.app')
@section('title','Recharge Success')

@section('content')
@php
    $status = $recharge->status;
    $isSuccess = in_array($status, ['success','completed','approved']);
    $statusLabel = $status === 'pending'
        ? 'অপেক্ষমান'
        : ($isSuccess ? 'সফল হয়েছে' : 'ব্যর্থ হয়েছে');

    $statusColor = $status === 'pending'
        ? 'text-orange-500'
        : ($isSuccess ? 'text-green-500' : 'text-red-500');
@endphp

<div class="min-h-screen bg-[#f5f7fb] flex items-center justify-center px-4 py-10">

    <div class="w-full max-w-sm">
        {{-- main white card --}}
        <div class="bg-white rounded-3xl shadow-[0_14px_40px_rgba(0,0,0,0.08)] px-6 py-7 text-center">

            {{-- green circle with check --}}
            <div class="flex justify-center mb-4">
                <div class="h-16 w-16 rounded-full bg-emerald-500 flex items-center justify-center">
                    <svg class="h-8 w-8 text-white" viewBox="0 0 24 24" fill="none">
                        <path d="M5 13l4 4L19 7"
                              stroke="currentColor" stroke-width="2.5"
                              stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </div>

            {{-- heading --}}
            <h1 class="text-[18px] font-extrabold text-gray-800 leading-tight">
                লেনদেন সফল হয়েছে
            </h1>
            <p class="text-sm text-sky-600 mt-1">
                Mobile Recharge
            </p>

            {{-- details box --}}
            <div class="mt-5 bg-white rounded-2xl border border-gray-200 overflow-hidden text-sm text-gray-700">

                {{-- amount row --}}
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">পরিমাণঃ</span>
                    <span class="font-semibold text-gray-800">
                        ৳{{ number_format($recharge->amount, 2) }}
                    </span>
                </div>

                {{-- status row --}}
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">অবস্থাঃ</span>
                    <span class="font-semibold {{ $statusColor }}">
                        {{ $statusLabel }}
                    </span>
                </div>

                {{-- date row --}}
                <div class="flex items-center justify-between px-4 py-2">
                    <span class="text-gray-600">তারিখঃ</span>
                    <span class="font-semibold text-gray-800">
                        {{ optional($recharge->created_at)->format('d-m-Y') }}
                    </span>
                </div>
            </div>
        </div>

        {{-- bottom green button --}}
        <a href="{{ url('/') }}"
           class="mt-5 block w-full text-center bg-emerald-500 hover:bg-emerald-600 text-white font-semibold text-sm py-3 rounded-full shadow-md transition">
            হোমে ফিরে যান
        </a>
    </div>
</div>
@endsection
