@extends('layouts.app')
@section('title','মোবাইল রিচার্জ')

@push('styles')
    {{-- Same fonts & blob animation --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }
        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }
        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }

        .amount-chip {
            border-radius: 9999px;
            border: 1px solid rgba(248, 250, 252, 0.45)!important;
            background: rgba(15, 23, 42, 0.3)!important;
            color: #ffffff!important;
            cursor: pointer;
            transition: background .15s ease, border-color .15s ease, color .15s ease;
        }
        .amount-chip:hover {
            border-color: rgba(45, 212, 191, 0.8)!important;
            background: rgba(15, 23, 42, 0.9)!important;
        }
        .amount-chip.active {
            border-color: rgba(16, 185, 129, 0.95)!important;
            background: linear-gradient(to right, #10b981, #22d3ee)!important;
            color: #c3c4ca!important;
        }
    </style>
@endpush

@section('content')
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    {{-- animated blobs --}}
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-[440px] relative z-10">

        {{-- top nav --}}
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Mobile Recharge
            </span>
        </div>

        {{-- main glass card --}}
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            {{-- small header --}}
            <div class="mb-3 flex items-center gap-3">
                <div class="h-10 w-10 rounded-2xl bg-gradient-to-br from-emerald-500 to-cyan-500 flex items-center justify-center text-white shadow-lg shadow-emerald-500/40">
                    <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M7 4h10a2 2 0 012 2v12a2 2 0 01-2 2H7a2 2 0 01-2-2V6a2 2 0 012-2z"/>
                        <path d="M7 16h10" fill="currentColor"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold text-slate-50">
                        আপনার মোবাইল রিচার্জ করুন
                    </div>
                    <p class="text-[11px] text-slate-400 mt-0.5">
                        সব অপারেটরের টকটাইম, ডাটা ও মিনিট রিচার্জ – এক জায়গা থেকেই।
                    </p>
                </div>
            </div>

            {{-- Info Banner --}}
            <div class="mb-4 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-3 py-2 text-[11px] text-emerald-100">
                <div class="flex items-start gap-2">
                    <div class="mt-0.5">📣</div>
                    <div>
                        <b>সকল অপারেটরের রিচার্জ সহ বায়ো প্যাকেজ, এমবি লোড ও মিনিট রিচার্জ করতে পারবেন।</b>
                        <div class="mt-1 text-[10px] text-emerald-200/90">(মিনিমাম রিচার্জ ১০ টাকা)</div>
                    </div>
                </div>
            </div>

            {{-- Alerts --}}
            @if(session('success'))
                <div class="mb-3 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-3 py-2 text-[11px] text-emerald-100">
                    {{ session('success') }}
                </div>
            @endif
            @if ($errors->any())
                <div class="mb-3 rounded-2xl border border-rose-500/40 bg-rose-500/10 px-3 py-2 text-[11px] text-rose-100">
                    <ul class="list-disc list-inside space-y-0.5">
                        @foreach ($errors->all() as $e) <li>{{ $e }}</li> @endforeach
                    </ul>
                </div>
            @endif

            @php
                $presets    = [50,100,200,500,1000];
                $oldAmount  = old('amount');
                $oldIsPreset = in_array((int)$oldAmount, $presets, true);
            @endphp

            {{-- Form --}}
            <form method="POST" action="{{ route('recharge.store') }}" id="recharge-form" class="space-y-4 mt-2">
                @csrf

                {{-- সেবার ধরন --}}
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        সেবার ধরন
                    </label>
                    <div class="relative">
                        <select name="service_type"
                                class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                       focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30"
                                required>
                            <option value="" disabled {{ old('service_type','')==='' ? 'selected' : '' }}>প্রিপেইড/পোস্টপেইড নির্বাচন করুন</option>
                            <option value="prepaid"  @selected(old('service_type')==='prepaid')>প্রিপেইড</option>
                            <option value="postpaid" @selected(old('service_type')==='postpaid')>পোস্টপেইড</option>
                        </select>
                        <div class="pointer-events-none absolute right-3 top-1/2 -translate-y-1/2 text-slate-400 text-xs">▾</div>
                    </div>
                </div>

                {{-- মোবাইল নম্বর --}}
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        মোবাইল নম্বর
                    </label>
                    <div class="relative">
                        <span class="absolute left-3 top-1/2 -translate-y-1/2 text-emerald-400">
                          <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none">
                            <rect x="6" y="3" width="12" height="18" rx="2" stroke="currentColor" stroke-width="1.6"/>
                            <path d="M8 16h8" stroke="currentColor" stroke-width="1.6"/>
                          </svg>
                        </span>
                        <input type="text"
                               name="msisdn"
                               value="{{ old('msisdn') }}"
                               class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-9 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                      focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500"
                               placeholder="১১ ডিজিটের মোবাইল নম্বর লিখুন"
                               required>
                    </div>
                    <div class="mt-1 text-[10px] text-slate-400">
                        উদাহরণ: 01XXXXXXXXX অথবা +8801XXXXXXXXX
                    </div>
                    @error('msisdn') <div class="text-[11px] text-rose-300">{{ $message }}</div> @enderror
                </div>

                {{-- দ্রুত পরিমাণ --}}
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        দ্রুত পরিমাণ
                    </label>
                    <div class="grid grid-cols-3 gap-2">
                        @foreach($presets as $p)
                            <button style=" border-radius: 9999px;
    border: 1px solid rgba(248, 250, 252, 0.45)!important; 
    background: rgba(15, 23, 42, 0.3)!important;           
    color: #ffffff!important;                               
    cursor: pointer;
    transition: background .15s ease, border-color .15s ease, color .15s ease;" type="button"
                                    class="amount-chip px-4 py-2 text-sm font-semibold shadow-sm {{ $oldIsPreset && (int)$oldAmount === $p ? 'active' : '' }}"
                                    data-amount="{{ $p }}">
                                ৳{{ number_format($p,0) }}
                            </button>
                        @endforeach
                        <button type="button"
                                class="amount-chip px-4 py-2 text-sm font-semibold shadow-sm {{ !$oldIsPreset && ($oldAmount!==null && $oldAmount!=='') ? 'active' : '' }}"
                                data-amount="other">
                            অন্যান্য
                        </button>
                    </div>
                </div>

                {{-- পরিমাণ --}}
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        পরিমাণ
                    </label>
                    <div class="relative">
                        <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-emerald-400 text-xs">৳</span>
                        <input type="number"
                               name="amount"
                               step="1" min="10" max="5000"
                               class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-8 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                      focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500"
                               placeholder="পরিমাণ লিখুন"
                               value="{{ $oldIsPreset ? $oldAmount : ($oldAmount ?? '') }}"
                               required>
                    </div>
                    <div class="mt-1 text-[10px] text-slate-400">
                        ন্যূনতম ১০, সর্বোচ্চ ৫০০০
                    </div>
                    @error('amount') <div class="text-[11px] text-rose-300">{{ $message }}</div> @enderror
                </div>

                {{-- রেফারেন্স --}}
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        রেফারেন্স (ঐচ্ছিক)
                    </label>
                    <input type="text"
                           name="reference"
                           value="{{ old('reference') }}"
                           class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                  focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500"
                           placeholder="পরিচয়/নোট লিখুন">
                </div>

                {{-- PIN (4 digits) --}}
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        PIN (৪ ডিজিট)
                    </label>
                    <input
                        type="password"
                        name="login_pin"
                        maxlength="4"
                        inputmode="numeric"
                        pattern="\d*"
                        class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 text-center tracking-[0.3em]
                               placeholder-slate-500 outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 @error('login_pin') border-rose-400 ring-rose-400/60 @enderror"
                        placeholder="••••"
                        required>
                    @error('login_pin') <div class="text-[11px] text-rose-300 mt-1">{{ $message }}</div> @enderror
                </div>

                {{-- submit --}}
                <button
                  class="mt-1 w-full rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 px-5 py-2.5 text-center text-sm font-semibold text-slate-950
                         shadow-[0_18px_45px_-20px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400 active:scale-[0.98] transition-transform">
                  🛩️ এখনই রিচার্জ করুন
                </button>
            </form>
        </div>
    </div>

    {{-- Amount chip interactions --}}
    <script>
        (function () {
            const presets = [50, 100, 200, 500, 1000];
            const chips = Array.from(document.querySelectorAll('.amount-chip'));
            const amountInput = document.querySelector('input[name="amount"]');

            function setActiveChipByValue(val) {
                const numericVal = Number(val);
                const isPreset = presets.includes(numericVal);

                chips.forEach(c => {
                    const v = c.getAttribute('data-amount');
                    const active =
                        (v === 'other' && (val === '' || !isPreset)) ||
                        (Number(v) === numericVal && isPreset);

                    c.classList.toggle('active', active);
                });
            }

            setActiveChipByValue(amountInput.value || '');

            chips.forEach(btn => {
                btn.addEventListener('click', () => {
                    const v = btn.getAttribute('data-amount');
                    if (v === 'other') {
                        amountInput.value = '';
                        amountInput.placeholder = 'পরিমাণ লিখুন';
                        setActiveChipByValue('');
                        amountInput.focus();
                    } else {
                        amountInput.value = parseInt(v, 10);
                        setActiveChipByValue(v);
                    }
                });
            });

            amountInput.addEventListener('input', () => {
                setActiveChipByValue(amountInput.value);
            });
        })();
    </script>
</div>
@endsection
