@extends('layouts.app')
@section('title','আজকের কোম্পানির চলমান রেট')

@section('content')
<main class="mx-auto w-full max-w-[1060px] px-3 sm:px-4 md:px-6" style="margin-bottom:96px;">
  @if($first)
    {{-- Featured country card --}}
    <section class="mt-4 sm:mt-5 overflow-hidden rounded-2xl sm:rounded-3xl bg-white ring-1 ring-[#2FAAA6]/10
                    shadow-[0_22px_60px_-26px_rgba(47,170,166,.32),0_8px_20px_-12px_rgba(2,6,23,.16)]">

      {{-- Hero header --}}
      <div class="relative px-4 sm:px-6 py-4 sm:py-6 text-white"
           style="background: {{ $first->header_bg ?: '#197c78' }}">
        <div class="absolute right-[-44px] top-[-44px] h-28 w-28 sm:h-40 sm:w-40 rounded-full bg-white/15"></div>
        <div class="absolute left-[-32px] bottom-[-32px] h-20 w-20 sm:h-28 sm:w-28 rounded-full bg-black/10"></div>

        <div class="flex items-center gap-2 sm:gap-3">
          <img src="{{ asset('storage/'.$first->flag_path) }}" alt="{{ $first->name }}"
               class="h-8 w-12 sm:h-10 sm:w-16 rounded-lg ring-2 ring-white/30 object-cover">
          <div>
            <div class="text-[10px] sm:text-xs opacity-90">বর্তমান সময়</div>
            <div id="clock" class="text-xs sm:text-sm font-semibold tracking-wide">--:--:--</div>
          </div>
          <div class="ms-auto inline-flex items-center gap-1.5 sm:gap-2 rounded-full bg-white/15 px-2.5 sm:px-3 py-0.5 sm:py-1 text-[10px] sm:text-xs font-semibold backdrop-blur">
            <span class="inline-block h-1.5 w-1.5 rounded-full bg-emerald-300"></span> লাইভ ভিউ
          </div>
        </div>

        <h3 class="mt-3 sm:mt-5 text-2xl sm:text-3xl font-extrabold drop-shadow-sm">{{ $first->name }}</h3>
        <p class="mt-1 text-[12px] sm:text-sm/relaxed text-white/90">
          {{ $first->share_title_bn ?: 'ফলো এবং আপডেটের জন্য' }}
        </p>
      </div>

    {{-- Body: all cards in ONE column --}}
<div class="p-4 sm:p-6 space-y-4">

  {{-- Rate cards (stacked) --}}
  <div class="space-y-4">
    {{-- Country --}}
    <div class="rounded-2xl bg-white p-4 ring-1 ring-slate-200
                shadow-[0_22px_60px_-26px_rgba(2,6,23,.16),0_10px_24px_-12px_rgba(47,170,166,.22)]">
      <div class="text-[11px] uppercase tracking-wider text-slate-500">Country</div>
      <div class="mt-1 text-lg font-extrabold text-slate-900">{{ $first->name }}</div>
    </div>

    {{-- Currency --}}
    <div class="rounded-2xl bg-white p-4 ring-1 ring-slate-200
                shadow-[0_22px_60px_-26px_rgba(2,6,23,.16),0_10px_24px_-12px_rgba(47,170,166,.22)]">
      <div class="text-[11px] uppercase tracking-wider text-slate-500">{{ strtoupper($first->currency_name) }}</div>
      <div class="mt-1 text-base font-semibold text-slate-800">
        {{ $first->unit_label ?: '1' }} {{ $first->currency_name }} =
      </div>
    </div>

    {{-- BDT --}}
    <div class="rounded-2xl bg-white p-4 ring-1 ring-slate-200
                shadow-[0_22px_60px_-26px_rgba(2,6,23,.16),0_10px_24px_-12px_rgba(47,170,166,.22)]">
      <div class="text-[11px] uppercase tracking-wider text-slate-500">Bangladeshi</div>
      <div class="mt-1 text-2xl font-extrabold text-emerald-700">
        ৳{{ number_format($first->rate_bdt,2) }}
      </div>
    </div>
  </div>

  {{-- CTA buttons (stack) --}}
  <div class="space-y-3">
    <button type="button"
            onclick="navigator.clipboard.writeText('{{ number_format($first->rate_bdt,2) }}')"
            class="w-full rounded-2xl bg-[#2FAAA6] px-5 py-3 text-sm font-semibold text-white
                   hover:bg-[#1f8f8b] active:scale-[.99] transition
                   shadow-[0_26px_70px_-28px_rgba(47,170,166,.45),0_12px_30px_-15px_rgba(2,6,23,.24)]">
      কপি করুন
    </button>
    <a href="{{ route('rates.show', $first) }}"
       class="block w-full rounded-2xl border border-slate-200 bg-white px-5 py-3 text-center text-sm font-semibold text-slate-700 hover:bg-slate-50
              shadow-[0_18px_45px_-20px_rgba(2,6,23,.18)]">
      বিস্তারিত দেখুন
    </a>
  </div>

  {{-- Share / info panel (stack) --}}
  <div class="rounded-3xl bg-white p-5 ring-1 ring-[#2FAAA6]/15
              shadow-[0_26px_70px_-28px_rgba(47,170,166,.28),0_10px_24px_-12px_rgba(2,6,23,.14)]">
    <div class="text-center">
      <div class="mb-3 text-base font-bold text-slate-800">আপডেট পেতে আমাদের সাথে থাকুন</div>

      <div class="mb-4 flex items-center justify-center gap-3">
        <a href="#" class="flex h-11 w-11 items-center justify-center rounded-full border-2 border-blue-600 text-blue-600 hover:bg-blue-50 shadow-sm">f</a>
        <a href="#" class="flex h-11 w-11 items-center justify-center rounded-full border-2 border-emerald-600 text-emerald-600 hover:bg-emerald-50 shadow-sm">🟢</a>
        <a href="#" class="flex h-11 w-11 items-center justify-center rounded-full border-2 border-sky-600 text-sky-600 hover:bg-sky-50 shadow-sm">✈</a>
      </div>

      <div class="text-xs text-slate-500">আজকের তারিখ: <b id="today">--</b></div>
      <p class="mt-2 text-sm text-slate-600">
        {{ $first->share_desc_bn ?? 'আজকের রেট দেখে সেরা ডিলটি বেছে নিন।' }}
      </p>

      <div class="mt-5 border-t border-slate-100 pt-4">
        <span class="inline-flex items-center gap-2 rounded-full bg-emerald-50 px-3 py-1 text-[11px] font-semibold text-emerald-700 shadow-sm">
          <span class="h-1.5 w-1.5 rounded-full bg-emerald-500"></span> লাইভ আপডেট সক্রিয়
        </span>
      </div>
    </div>
  </div>

</div>


    </section>
  @endif

  {{-- More countries (responsive grid) --}}
  <section class="mt-5 sm:mt-6">
    <div class="mb-2 flex items-center gap-2 text-slate-700">
      <span>🌍</span><span class="font-semibold">অন্যান্য দেশসমূহ</span>
    </div>

    <div class="grid gap-2.5 sm:gap-3 grid-cols-1 xs:grid-cols-2 sm:grid-cols-2 md:grid-cols-3">
      @foreach($countries as $c)
        <a href="{{ route('rates.show', $c) }}"
           class="flex items-center justify-between rounded-2xl bg-white p-3 ring-1 ring-[#2FAAA6]/10
                  shadow-[0_16px_40px_-22px_rgba(47,170,166,.22)] hover:shadow-[0_22px_60px_-26px_rgba(47,170,166,.28)]">
          <div class="flex items-center gap-2.5 sm:gap-3 min-w-0">
            <img src="{{ asset('storage/'.$c->flag_path) }}" alt="{{ $c->name }}"
                 class="h-7 w-10 sm:h-8 sm:w-12 rounded-md object-cover ring-1 ring-slate-200">
            <div class="min-w-0">
              <div class="truncate text-[13px] sm:text-sm font-semibold text-slate-800">{{ $c->name }}</div>
              <div class="truncate text-[11px] text-slate-500">{{ $c->unit_label ?: '1' }} {{ $c->currency_name }}</div>
            </div>
          </div>
          <div class="text-right shrink-0">
            <div class="text-sm sm:text-base font-extrabold text-emerald-700">৳{{ number_format($c->rate_bdt,2) }}</div>
            <div class="text-[10px] text-slate-400">আজ</div>
          </div>
        </a>
      @endforeach
    </div>
  </section>

</main>

{{-- Clock + Today --}}
<script>
  function pad(n){return n<10?('0'+n):n}
  function tick(){
    const d=new Date();
    const h=pad(d.getHours()), m=pad(d.getMinutes()), s=pad(d.getSeconds());
    const clock=document.getElementById('clock'); if(clock) clock.textContent=`${h}:${m}:${s}`;
    const today=document.getElementById('today'); if(today) today.textContent = `${pad(d.getDate())}-${pad(d.getMonth()+1)}-${d.getFullYear()}`;
  }
  tick(); setInterval(tick, 1000);
</script>
@endsection
