@extends('layouts.app')

@section('content')
{{-- যদি Tailwind আগে থেকেই লেআউটে থাকে, এখানে আর দরকার নেই। না থাকলে CDN ব্যবহার করতে পারেন:
<script src="https://cdn.tailwindcss.com"></script>
--}}

<div class="max-w-3xl mx-auto p-4 sm:p-6">
    {{-- Status alert --}}
    @if (session('status'))
        <div class="mb-4 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-emerald-800 flex items-start gap-2">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mt-0.5" viewBox="0 0 20 20" fill="currentColor">
                <path d="M10 18a8 8 0 100-16 8 8 0 000 16ZM9 9a1 1 0 112 0v4a1 1 0 11-2 0V9Zm1-5a1.5 1.5 0 100 3 1.5 1.5 0 000-3Z"/>
            </svg>
            <div class="flex-1">{{ session('status') }}</div>
            <button class="ms-2 text-emerald-700/70 hover:text-emerald-900" onclick="this.parentElement.remove()">✕</button>
        </div>
    @endif

    <div class="rounded-2xl border border-slate-200 bg-white shadow-sm overflow-hidden">
        {{-- Header --}}
        <div class="flex items-center gap-3 px-5 py-4">
            @php $avatar = $user->avatar ? asset('storage/'.$user->avatar) : 'https://placehold.co/96x96?text=Avatar'; @endphp
            <img id="avatarPreview" src="{{ $avatar }}" alt="Avatar"
                 class="h-14 w-14 rounded-full ring-2 ring-white shadow object-cover">
            <div class="min-w-0">
                <h1 class="text-base sm:text-lg font-semibold text-slate-900">{{ auth()->user()->name }}</h1>
                <p class="text-xs text-slate-500">{{ auth()->user()->phone }}</p>
            </div>
        </div>

        <div class="px-5 pb-5">
            <form action="{{ route('profile.update') }}" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 gap-4 sm:gap-5">
                @csrf
                @method('PUT')

                {{-- Name --}}
                <div>
                    <label for="name" class="mb-1.5 block text-sm font-medium text-slate-700">নাম</label>
                    <div class="relative">
                        <span class="pointer-events-none absolute inset-y-0 left-0 grid w-10 place-items-center text-slate-400">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5Zm7 9a7 7 0 0 0-14 0"/>
                            </svg>
                        </span>
                        <input id="name" name="name" type="text"
                               value="{{ old('name', $user->name) }}"
                               class="w-full rounded-lg border border-slate-300 bg-white pl-10 pr-3 py-2.5 text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-400 focus:border-sky-400 @error('name') border-red-400 focus:ring-red-300 focus:border-red-400 @enderror"
                               placeholder="আপনার নাম">
                    </div>
                    @error('name') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                </div>

                {{-- Email --}}
                <div>
                    <label for="email" class="mb-1.5 block text-sm font-medium text-slate-700">ইমেইল</label>
                    <div class="relative">
                        <span class="pointer-events-none absolute inset-y-0 left-0 grid w-10 place-items-center text-slate-400">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M4 6h16v12H4zM4 6l8 6 8-6"/>
                            </svg>
                        </span>
                        <input id="email" name="email" type="email"
                               value="{{ old('email', $user->email) }}"
                               class="w-full rounded-lg border border-slate-300 bg-white pl-10 pr-3 py-2.5 text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-400 focus:border-sky-400 @error('email') border-red-400 focus:ring-red-300 focus:border-red-400 @enderror"
                               placeholder="name@example.com">
                    </div>
                    @error('email') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    @if(!$user->email)
                        <p class="mt-1 text-xs text-slate-500">ইমেইল না দিলে লগইনের জন্য ফোন/ইউজারনেম ব্যবহার হবে।</p>
                    @endif
                </div>

                {{-- Phone --}}
                <div>
                    <label for="phone" class="mb-1.5 block text-sm font-medium text-slate-700">ফোন</label>
                    <div class="relative">
                        <span class="pointer-events-none absolute inset-y-0 left-0 grid w-10 place-items-center text-slate-400">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M21 15v3a2 2 0 0 1-2 2h-1c-7.18 0-13-5.82-13-13V4a2 2 0 0 1 2-2h3l1.5 4-2 2a12 12 0 0 0 6.5 6.5l2-2L19 16l-4 1.5"/>
                            </svg>
                        </span>
                        <input id="phone" name="phone" type="text"
                               value="{{ old('phone', $user->phone) }}"
                               class="w-full rounded-lg border border-slate-300 bg-white pl-10 pr-3 py-2.5 text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-400 focus:border-sky-400 @error('phone') border-red-400 focus:ring-red-300 focus:border-red-400 @enderror"
                               placeholder="01XXXXXXXXX">
                    </div>
                    @error('phone') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                </div>

                {{-- Avatar --}}
                <div>
                    <label for="avatar" class="mb-1.5 block text-sm font-medium text-slate-700">অ্যাভাটার</label>
                    <input id="avatar" name="avatar" type="file" accept="image/*"
                           class="block w-full rounded-lg border border-slate-300 bg-white px-3 py-2.5 text-slate-900 file:mr-3 file:rounded-md file:border-0 file:bg-slate-100 file:px-3 file:py-2 file:text-sm hover:file:bg-slate-200 focus:outline-none focus:ring-2 focus:ring-sky-400 focus:border-sky-400 @error('avatar') border-red-400 focus:ring-red-300 focus:border-red-400 @enderror">
                    @error('avatar') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    @if($user->avatar)
                        <p class="mt-1 text-xs text-slate-500">বর্তমান ছবি উপরে প্রিভিউতে দেখা যাচ্ছে।</p>
                    @endif
                </div>

                <div class="my-2 border-t border-slate-200"></div>

                {{-- Passwords (grid) --}}
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="password" class="mb-1.5 block text-sm font-medium text-slate-700">নতুন পাসওয়ার্ড (ঐচ্ছিক)</label>
                        <div class="relative">
                            <span class="pointer-events-none absolute inset-y-0 left-0 grid w-10 place-items-center text-slate-400">
                                <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5Zm7 9a7 7 0 0 0-14 0"/>
                                </svg>
                            </span>
                            <input id="password" name="password" type="password" autocomplete="new-password"
                                   class="w-full rounded-lg border border-slate-300 bg-white pl-10 pr-3 py-2.5 text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-400 focus:border-sky-400 @error('password') border-red-400 focus:ring-red-300 focus:border-red-400 @enderror"
                                   placeholder="••••••••">
                        </div>
                        @error('password') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
                    </div>

                    <div>
                        <label for="password_confirmation" class="mb-1.5 block text-sm font-medium text-slate-700">পাসওয়ার্ড কনফার্ম</label>
                        <div class="relative">
                            <span class="pointer-events-none absolute inset-y-0 left-0 grid w-10 place-items-center text-slate-400">
                                <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M20 6 9 17l-5-5"/>
                                </svg>
                            </span>
                            <input id="password_confirmation" name="password_confirmation" type="password" autocomplete="new-password"
                                   class="w-full rounded-lg border border-slate-300 bg-white pl-10 pr-3 py-2.5 text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-400 focus:border-sky-400"
                                   placeholder="••••••••">
                        </div>
                    </div>
                </div>

                {{-- Actions --}}
                <div class="flex justify-end gap-2 pt-1">
                    <a href="{{ url()->previous() }}"
                       class="inline-flex items-center gap-2 rounded-lg border border-slate-300 bg-white px-4 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50 focus:outline-none focus:ring-2 focus:ring-slate-300">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M15 19 8 12l7-7"/>
                        </svg>
                        বাতিল
                    </a>
                    <button type="submit"
                            class="inline-flex items-center gap-2 rounded-lg bg-sky-600 px-4 py-2 text-sm font-semibold text-white shadow hover:bg-sky-700 focus:outline-none focus:ring-2 focus:ring-sky-300">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M5 20h14a1 1 0 0 0 1-1v-9l-6-5H6a1 1 0 0 0-1 1v14ZM14 3v6h6"/>
                        </svg>
                        আপডেট করুন
                    </button>
                </div>
            </form>
        </div>

        {{-- Footer note --}}
        <div class="px-5 pb-5">
            <p class="rounded-lg bg-slate-50 px-3 py-2 text-xs text-slate-600">
                <svg class="mr-1 inline h-4 w-4 align-text-bottom" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 2a10 10 0 1 0 .001 20.001A10 10 0 0 0 12 2Zm1 15h-2v-2h2v2Zm0-4h-2V7h2v6Z"/>
                </svg>
                সর্বোত্তম ফলাফলের জন্য 512×512 পিক্সেল স্কোয়ার ছবি ব্যবহার করুন।
            </p>
        </div>
    </div>
</div>

{{-- Avatar preview --}}
@push('scripts')
<script>
  const avInput = document.getElementById('avatar');
  const avPrev  = document.getElementById('avatarPreview');
  if (avInput && avPrev) {
    avInput.addEventListener('change', (e) => {
      const file = e.target.files && e.target.files[0];
      if (!file) return;
      const reader = new FileReader();
      reader.onload = (ev) => avPrev.src = ev.target.result;
      reader.readAsDataURL(file);
    });
  }
</script>
@endpush
@endsection
