@extends('layouts.app', ['title' => 'নোটিফিকেশন'])

@section('content')
 {{-- Smooth fonts + AOS --}}
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://unpkg.com/aos@2.3.4/dist/aos.css"/>

  <style>
    :root{
      --bg: #eef6f7;
      --card-bg: #ffffff;
      --muted: #64748b;
      --text: #0f172a;
      --primary: #0ea5e9; /* teal-cyan */
      --primary-700: #0c87c7;
      --secondary: #2563eb; /* blue */
      --accent: #22c55e;
      --new: #ff7a1a;
      --yesterday: #f59e0b;
      --old: #9ca3af;
      --ring: rgba(37,99,235,.25);
      --shadow: 0 6px 26px rgba(16,24,40,.08);
      --radius: 14px;
    }
    body{font-family:"Hind Siliguri","Inter",system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;background:var(--bg);}
    .page-wrap{margin:10px 0 100px 0;padding:10px}
    .soft-bg{
      background:
        radial-gradient(1200px 400px at -20% -10%, rgba(34,197,94,.08), transparent 60%),
        radial-gradient(800px 400px at 120% 10%, rgba(14,165,233,.10), transparent 60%),
        linear-gradient(180deg, #f7fbff 0%, #eef6f7 100%);
      border-radius: var(--radius);
      padding: 4px;
    }

    /* Banner */
    .banner{
      border-radius: var(--radius);
      overflow:hidden;
      box-shadow: var(--shadow);
      margin-bottom:18px;
      /* background: linear-gradient(135deg,#1cc7b6 0%, #1f6feb 100%); */
          background: #24A8A4;
      color:#fff;
    }
    .banner-inner{
      padding:18px 16px;
      display:flex;flex-direction:column;gap:6px
    }
    .banner .title{
      display:flex;align-items:center;gap:10px;
      font-weight:800;font-size:22px; letter-spacing:.2px
    }
    .banner .subtitle{opacity:.95;font-size:13px}

    /* Section heading */
    .sectionH{
      display:flex;align-items:center;gap:8px;
      margin:16px 0 10px;font-weight:800;color:var(--text);
    }
    .sectionH i{font-size:18px;color:var(--secondary)}

    /* Card */
    .card{
      border:1px solid #e8eef5;
      border-radius: var(--radius);
      background:var(--card-bg);
      overflow:hidden;
      box-shadow: var(--shadow);
      transition: transform .18s ease, box-shadow .18s ease, border-color .18s ease;
    }
    .card:hover{ transform: translateY(-1px); box-shadow: 0 10px 34px rgba(16,24,40,.10); border-color:#e2ecff; }
    .card-hdr{
      display:flex;justify-content:space-between;align-items:center;gap:10px;
      background: linear-gradient(180deg,#f7fbff, #f1f5fa);
      padding:12px 14px;border-bottom:1px solid #eaf0f7;
    }
    .title-row{display:flex;align-items:center;gap:9px;font-weight:700;color:#0b2a4a}
    .dot{width:9px;height:9px;border-radius:50%;background:#3b82f6;display:inline-block;box-shadow:0 0 0 3px var(--ring)}
    .meta{display:flex;align-items:center;gap:14px;color:var(--muted);font-size:12px}
    .meta i{font-size:14px}
    .body{padding:14px 16px;white-space:pre-line;color:#0e1728}

    /* Pills */
    .pill{font-size:11.5px;padding:2px 8px;border-radius:999px;font-weight:700;letter-spacing:.2px}
    .pill-new{background:var(--new);color:#fff}
    .pill-yes{background:var(--yesterday);color:#fff}
    .pill-old{background:var(--old);color:#fff}

    /* Responsive tweaks for mobile */
    @media (max-width:480px){
      .banner .title{font-size:20px}
      .meta{gap:10px}
    }
  </style>
<div class="page-wrap soft-bg">

  {{-- Banner (same gradient as your mock) --}}
  <div class="banner" data-aos="fade-down">
    <div class="banner-inner">
      <div class="title">
        <i class="ri-notification-3-line" style="font-size:22px"></i>
        নোটিফিকেশন
      </div>
      <div class="subtitle">সর্বশেষ নোটিফিকেশনগুলো দেখুন</div>
    </div>
  </div>

  {{-- নতুন (আজ) --}}
  @if($today->count())
    <div class="sectionH" data-aos="fade-right"><i class="ri-flashlight-line"></i> নতুন</div>
    @foreach($today as $idx => $n)
      <div class="card" data-aos="fade-up" data-aos-delay="{{ 50 + ($idx*30) }}" style="margin-bottom:14px">
        <div class="card-hdr">
          <div class="title-row">
            <span class="dot"></span>
            <span>নোটিফিকেশন</span>
            <span class="pill pill-new">নতুন</span>
          </div>
          <div class="meta">
            <span><i class="ri-calendar-line"></i> {{ $n->created_at->format('d M Y') }}</span>
            <span><i class="ri-time-line"></i> {{ $n->created_at->format('h:i A') }}</span>
          </div>
        </div>
        <div class="body">
          @if($n->body)
            {!! nl2br(e($n->body)) !!}
          @else
            <strong>{{ $n->title }}</strong>
          @endif
        </div>
      </div>
    @endforeach
  @endif

  {{-- গতকাল --}}
  @if($yesterday->count())
    <div class="sectionH" data-aos="fade-right"><i class="ri-sun-foggy-line"></i> গতকাল</div>
    @foreach($yesterday as $idx => $n)
      <div class="card" data-aos="fade-up" data-aos-delay="{{ 50 + ($idx*30) }}" style="margin-bottom:14px">
        <div class="card-hdr">
          <div class="title-row">
            <span class="dot"></span>
            <span>নোটিফিকেশন</span>
            <span class="pill pill-yes">গতকাল</span>
          </div>
          <div class="meta">
            <span><i class="ri-calendar-line"></i> {{ $n->created_at->format('d M Y') }}</span>
            <span><i class="ri-time-line"></i> {{ $n->created_at->format('h:i A') }}</span>
          </div>
        </div>
        <div class="body">
          @if($n->body)
            {!! nl2br(e($n->body)) !!}
          @else
            <strong>{{ $n->title }}</strong>
          @endif
        </div>
      </div>
    @endforeach
  @endif

  {{-- পুরাতন --}}
  @if($older->count())
    <div class="sectionH" data-aos="fade-right"><i class="ri-archive-line"></i> পুরাতন</div>
    @foreach($older as $idx => $n)
      <div class="card" data-aos="fade-up" data-aos-delay="{{ 50 + ($idx*30) }}" style="margin-bottom:14px">
        <div class="card-hdr">
          <div class="title-row">
            <span class="dot"></span>
            <span>নোটিফিকেশন</span>
            <span class="pill pill-old">পুরাতন</span>
          </div>
          <div class="meta">
            <span><i class="ri-calendar-line"></i> {{ $n->created_at->format('d M Y') }}</span>
            <span><i class="ri-time-line"></i> {{ $n->created_at->format('h:i A') }}</span>
          </div>
        </div>
        <div class="body">
          @if($n->body)
            {!! nl2br(e($n->body)) !!}
          @else
            <strong>{{ $n->title }}</strong>
          @endif
        </div>
      </div>
    @endforeach
  @endif

  @if(!$today->count() && !$yesterday->count() && !$older->count())
    <p data-aos="fade-up">কোন নোটিফিকেশন নেই।</p>
  @endif
</div>
  <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
  <script>
    AOS.init({
      duration: 500,        // animation speed
      easing: 'ease-out',   // smoother
      once: true,           // animate once per element
      offset: 16            // small offset for mobile
    });
  </script>
@endsection
