@extends('layouts.app', ['title' => 'Create Notice'])

@section('content')
<div style="max-width:720px;margin:0 auto">
  <h1 style="font-size:22px;margin-bottom:14px">Create Notice</h1>

  {{-- Success flash --}}
  @if(session('status'))
    <div style="padding:10px 12px;border:1px solid #c7f0d2;background:#ecfdf5;color:#065f46;border-radius:8px;margin-bottom:14px">
      {{ session('status') }}
    </div>
  @endif

  {{-- Validation errors --}}
  @if ($errors->any())
    <div style="padding:10px 12px;border:1px solid #fecaca;background:#fff1f2;color:#991b1b;border-radius:8px;margin-bottom:14px">
      <strong>Fix the following:</strong>
      <ul style="margin:8px 0 0 18px">
        @foreach ($errors->all() as $error)
          <li>{{ $error }}</li>
        @endforeach
      </ul>
    </div>
  @endif

  <form method="POST" action="{{ route('notices.store') }}" id="noticeCreateForm"
        style="border:1px solid #eee;border-radius:12px;padding:18px;background:#fff">
    @csrf

    <label for="title" style="font-weight:600;display:block;margin-bottom:6px">Title <span style="color:#ef4444">*</span></label>
    <input id="title" name="title" value="{{ old('title') }}" required
           placeholder="Enter notice title"
           style="width:100%;padding:10px 12px;border:1px solid #ddd;border-radius:8px;margin-bottom:14px">

    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:6px">
      <label for="body" style="font-weight:600">Body</label>
      <small id="bodyCount" style="color:#6b7280">0 / 2000</small>
    </div>
    <textarea id="body" name="body" rows="8" placeholder="Write the notice details…"
              style="width:100%;padding:12px;border:1px solid #ddd;border-radius:8px;margin-bottom:16px">{{ old('body') }}</textarea>

    {{-- Optional: publish to all users info --}}
    <div style="display:flex;align-items:flex-start;gap:10px;margin-bottom:16px;color:#374151">
      <i class="ri-megaphone-line" style="font-size:18px;line-height:1.4"></i>
      <small>Publishing will send this notice to all users as <strong>Unread</strong>. They’ll see it under the bell icon.</small>
    </div>

    <div style="display:flex;gap:10px">
      <button type="submit"
              style="padding:10px 14px;border-radius:8px;background:#2563eb;color:#fff;border:none;cursor:pointer">
        Publish Notice
      </button>
      {{-- <a href="{{ route('notices.index') }}"
         style="padding:10px 14px;border-radius:8px;border:1px solid #ddd;text-decoration:none;color:#111827;background:#f9fafb">
        Cancel
      </a> --}}
    </div>
  </form>
</div>
@endsection

@push('scripts')
<script>
  // Simple character counter for body
  const bodyEl = document.getElementById('body');
  const bodyCount = document.getElementById('bodyCount');
  const limit = 2000;

  function updateCount(){
    const len = bodyEl.value.length;
    bodyCount.textContent = `${len} / ${limit}`;
    bodyCount.style.color = len > limit ? '#dc2626' : '#6b7280';
  }
  if (bodyEl && bodyCount){
    bodyEl.addEventListener('input', updateCount);
    updateCount();
  }
</script>
@endpush
