@extends('layouts.app')

@section('title', 'মোবাইল ব্যাংকিং')

@section('content')
<div class="max-w-3xl mx-auto p-4">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-2xl font-bold">মোবাইল ব্যাংকিং</h1>
        <span class="text-sm px-3 py-1 rounded-full bg-gray-100">Balance: {{ number_format(auth()->user()->balance,2) }} ৳</span>
    </div>

    @if(session('success'))
        <div class="mb-4 rounded-lg bg-emerald-50 text-emerald-800 p-3">{{ session('success') }}</div>
    @endif
    @if($errors->any())
        <div class="mb-4 rounded-lg bg-rose-50 text-rose-800 p-3">
            {{ implode(' ', $errors->all()) }}
        </div>
    @endif

    <div class="grid grid-cols-3 gap-4 mb-6">
        @foreach($gateways as $g)
        <button
            x-data
            x-on:click="
                document.getElementById('gateway_id').value='{{ $g->id }}';
                document.querySelectorAll('.gw-card').forEach(c=>c.classList.remove('ring-2','ring-emerald-500'));
                $el.closest('.gw-card').classList.add('ring-2','ring-emerald-500');
                document.getElementById('limits').innerText = 'লিমিট: {{ number_format($g->min_limit,2) }} - {{ number_format($g->max_limit,2) }} ৳';
                "
            class="gw-card w-full rounded-2xl shadow-sm bg-white p-4 hover:shadow-md transition">
            <div class="flex flex-col items-center gap-2">
                <img src="{{ asset('storage/'.$g->logo_path) }}" class="h-12 w-12 object-contain" alt="{{ $g->name }}">
                <div class="text-center">
                    <div class="text-base font-semibold">{{ $g->name }}</div>
                </div>
            </div>
        </button>
        @endforeach
    </div>

    <form method="POST" action="{{ route('user.mobile-banking.store') }}" class="bg-white rounded-2xl shadow p-6 space-y-4">
        @csrf
        <input id="gateway_id" type="hidden" name="gateway_id" value="{{ $gateways->first()->id ?? '' }}">
        <div class="flex items-center gap-2 text-sm text-gray-600">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path d="M2 5a2 2 0 012-2h12a2 2 0 012 2v3H2V5z"/><path d="M2 9h16v6a2 2 0 01-2 2H4a2 2 0 01-2-2V9z"/></svg>
            <span id="limits">লিমিট: {{ optional($gateways->first())->min_limit ?? 0 }} - {{ optional($gateways->first())->max_limit ?? 0 }} ৳</span>
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">নম্বার</label>
            <div class="relative">
                <input name="account_number" type="text" class="w-full rounded-xl border-gray-300 focus:ring-emerald-500 focus:border-emerald-500" placeholder="নম্বার লিখুন">
                <span class="absolute inset-y-0 right-3 flex items-center text-gray-400">📱</span>
            </div>
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">পরিমাণ</label>
            <div class="relative">
                <input name="amount" type="number" step="0.01" class="w-full rounded-xl border-gray-300 focus:ring-emerald-500 focus:border-emerald-500" placeholder="পরিমাণ লিখুন">
                <span class="absolute inset-y-0 right-3 flex items-center text-gray-400">৳</span>
            </div>
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">এজেন্ট/পার্সোনাল</label>
            <select name="channel" class="w-full rounded-xl border-gray-300 focus:ring-emerald-500 focus:border-emerald-500">
                <option value="agent">এজেন্ট</option>
                <option value="personal">পার্সোনাল</option>
            </select>
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">রেফারেন্স (ঐচ্ছিক)</label>
            <input name="reference" type="text" class="w-full rounded-xl border-gray-300 focus:ring-emerald-500 focus:border-emerald-500" placeholder="উদাহরণ: ইনভয়েস #123">
        </div>

        <button class="w-full inline-flex items-center justify-center gap-2 rounded-xl bg-emerald-600 text-white py-3 font-semibold hover:bg-emerald-700">
            <span>পেমেন্ট করুন</span>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path d="M12.293 5.293a1 1 0 011.414 0L18 9.586l-1.414 1.414L14 8.414V17h-2V8.414l-2.586 2.586L8 9.586l4.293-4.293z"/></svg>
        </button>
    </form>
</div>

{{-- Alpine.js (ট্যাব সিলেক্টে হালকা ইন্টার‍্যাকশনের জন্য) --}}
<script src="//unpkg.com/alpinejs" defer></script>
@endsection
