<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
      @php
    $companySetup = \App\Models\CompanySetup::first();
  @endphp
    <title>@yield('title', $companySetup->company_name)</title>
 <link rel="icon" href="{{ asset('storage/'.$companySetup->fav_icon) }}" type="image/png">
        <meta name="csrf-token" content="{{ csrf_token() }}">
    <link
        href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&family=Inter:wght@500;600;700&display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="{{ asset('frontend/css/style.css') }}" />
</head>
<body>
    @if (isset($slot))
        {{ $slot }}
    @else
        @yield('content')
    @endif
    @include('frontend.common.footer')
    </nav>
     <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="{{ asset('frontend/js/app.js') }}"></script>


    <script>
        window.csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        async function fetchUnreadCount() {
            try {
                const res = await fetch(`{{ url('/notices/unread-count') }}`, { headers: { 'X-Requested-With': 'XMLHttpRequest' } });
                const { count } = await res.json();
                const el = document.getElementById('notice-count');
                if (el) el.textContent = count;
            } catch (e) { }
        }
        // প্রথম লোডে ও নির্দিষ্ট বিরতিতে রিফ্রেশ
        fetchUnreadCount();
        setInterval(fetchUnreadCount, 15000);
    </script>



</body>
</html>
