@extends('layouts.app')
@section('title','ডিপোজিট প্যাকেজ')

@push('styles')
    {{-- Same fonts & blob animation --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
@endpush

@section('content')
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    {{-- animated blobs --}}
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <main class="mx-auto max-w-[420px] w-full relative z-10">

        {{-- top nav --}}
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Deposit Packages
            </span>
        </div>

        {{-- glass container --}}
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            {{-- banner --}}
            <div class="relative mb-5 overflow-hidden rounded-2xl bg-gradient-to-br from-emerald-500 via-cyan-500 to-teal-500 p-5 text-white shadow-[0_18px_45px_-20px_rgba(16,185,129,.9)]">
                <div class="mb-1 text-lg sm:text-xl font-bold">{{ $banner['title'] }}</div>
                <div class="text-xs sm:text-sm leading-relaxed opacity-95">{{ $banner['subtitle'] }}</div>
                @if($banner['chip'])
                    <div class="mt-3 inline-flex rounded-full bg-black/15 px-3 py-1 text-[11px] font-semibold backdrop-blur shadow-sm">
                        {{ $banner['chip'] }}
                    </div>
                @endif
                <div class="pointer-events-none absolute -right-12 -bottom-12 h-40 w-40 rounded-full bg-white/15 blur-sm opacity-80"></div>
            </div>

            {{-- packages --}}
            <div class="mb-2 flex items-center gap-2 text-slate-200 text-sm">
                <span>🎁</span>
                <span class="font-semibold">চলমান প্যাকেজ সমূহ</span>
            </div>

            <div class="space-y-3">
                @forelse($packages as $pkg)
                    <div class="relative rounded-2xl border border-slate-700 bg-slate-900/80 p-4 shadow-sm hover:shadow-[0_18px_45px_-28px_rgba(16,185,129,0.8)] hover:border-emerald-500/50 transition">
                        @if($pkg->badge_text)
                            <div class="absolute -right-1 -top-1 rounded-bl-2xl rounded-tr-2xl bg-emerald-500/15 px-2 py-1 text-[11px] font-bold text-emerald-300 shadow-sm border border-emerald-400/40">
                                {{ $pkg->badge_text }}
                            </div>
                        @endif

                        <div class="text-[15px] font-bold text-slate-50">
                            {{ $pkg->title }}
                        </div>

                        <div class="mt-2 flex items-center gap-1 text-sm font-semibold text-emerald-300">
                            <span>💸</span>
                            <span>বোনাস: {{ number_format($pkg->bonus_amount, 2) }} টাকা</span>
                        </div>

                        {{-- CTA row (demo: disabled) --}}
                        <div class="mt-3 flex items-center justify-end gap-2">
                            <button
                                type="button"
                                class="rounded-2xl border border-slate-700 bg-slate-900/70 px-4 py-1.5 text-[11px] font-semibold text-slate-200 hover:border-emerald-500/50 hover:bg-slate-800/90 transition">
                                ডিটেইলস
                            </button>
                            <button
                                type="button"
                                class="rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 px-4 py-1.5 text-sm font-semibold text-slate-950 shadow-[0_14px_35px_-18px_rgba(16,185,129,0.9)]
                                       hover:from-emerald-400 hover:to-cyan-400 disabled:opacity-60 cursor-not-allowed"
                                disabled>
                                সিলেক্ট
                            </button>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-slate-700 bg-slate-900/80 p-5 text-center text-sm text-slate-400 shadow-sm">
                        কোনো প্যাকেজ পাওয়া যায়নি।
                    </div>
                @endforelse
            </div>

            {{-- rules --}}
            <div class="mt-6">
                <div class="mb-2 text-sm font-semibold text-slate-100">ব্যালেন্স যোগ করার নিয়ম</div>
                <div class="rounded-2xl border border-slate-700 bg-slate-900/80 p-4 text-[13px] leading-relaxed text-slate-300 shadow-sm">
                    {!! nl2br(e($rulesText)) !!}
                </div>
            </div>

            {{-- contact --}}
            <div class="mt-4 rounded-2xl border border-slate-700 bg-slate-900/80 p-4 shadow-sm text-sm text-slate-100">
                <div class="mb-3 font-semibold text-slate-100">যোগাযোগ তথ্য</div>

                <div class="flex items-center justify-between border-b border-slate-800 pb-3">
                    <div class="flex items-center gap-2">
                        <span class="rounded-full bg-emerald-500/10 p-2 text-emerald-300 shadow-sm">📞</span>
                        <div>
                            <div class="text-sm font-medium text-slate-50">{{ $contact['phone'] }}</div>
                            <div class="text-[11px] text-slate-400">কল করুন</div>
                        </div>
                    </div>
                    <a href="tel:{{ preg_replace('/\D/','',$contact['phone']) }}"
                       class="text-[12px] font-semibold text-emerald-300 hover:text-emerald-200 hover:underline">
                        কল করুন
                    </a>
                </div>

                <div class="flex items-center justify-between pt-3">
                    <div class="flex items-center gap-2">
                        <span class="rounded-full bg-cyan-500/10 p-2 text-cyan-300 shadow-sm">💳</span>
                        <div>
                            <div class="text-sm font-medium text-slate-50">ওয়ালেট</div>
                            <div class="text-[11px] text-slate-400">{{ $contact['provider'] }}</div>
                        </div>
                    </div>
                    <button type="button"
                            class="text-[12px] font-semibold text-cyan-300 hover:text-cyan-200 hover:underline">
                        ডিটেইলস দেখুন
                    </button>
                </div>
            </div>

        </div>
    </main>
</div>
@endsection
