@extends('frontend.master')

@section('content')
<link rel="stylesheet" href="https://unpkg.com/swiper@9/swiper-bundle.min.css">
<style>
  .swiper { width: 100%; max-width: 100%; }
  .swiper-slide img { width: 100%; height: auto; display: block; }
  /* চাইলে নির্দিষ্ট অনুপাত চান:
  .mySwiper { aspect-ratio: 16 / 6; }
  .mySwiper .swiper-slide { height: 100%; }
  .mySwiper img { height: 100%; object-fit: cover; }
  */
</style>
    <div class="shell">
        @include('frontend.common.header')

        <section class="grid">
            <a class="qi" href="{{ url('/add-money-methods') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/addmoney.jpg') }}" alt=""></span><small>অ্যাড মানি</small></a>
            <a class="qi" href="{{ url('/wallet/send') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/s.jpg') }}" alt=""></span><small>সেন্ড মানি</small></a>
            <a class="qi" href="{{ url('/offers') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/offer.png') }}" alt=""></span><small>ড্রাইভ অফার</small></a>

            <a class="qi" href="{{ url('/recharge') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/r.jpg') }}" alt=""></span><small>মোবাইল রিচার্জ</small></a>
            <a class="qi" href="{{ url('/deposits') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/20240915_220918.png') }}" alt=""></span><small>স্পেশাল
                    অফার</small></a>
            <a class="qi" href="{{ url('/rewards/convert') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/reward.png') }}" alt=""></span><small>কমিশন</small></a>

            <a class="qi" href="{{ url('/loans/apply') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/png-clipart-computer-icons-loan-finance-bank-donate-text-trademark.png') }}"
                        alt=""></span><small>লোন</small></a>
            <a class="qi" href="{{ url('/paybills') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/paybill.png') }}" alt=""></span><small>পে বিল</small></a>
            <a class="qi" href="{{ url('/statement') }}"><span class="round"><img style="width: 100%;"
                        src="{{ asset('frontend/img/offer.png') }}" alt=""></span><small>স্টেটমেন্ট</small></a>


        </section>


        <marquee direction="left" class="markuee_headline">
            @php
                $headline = \App\Models\Headline::first();
              @endphp
            {{ $headline->headline }}
        </marquee>


        <section class="mobile-banking">
            <h3>মোবাইল ব্যাংকিং</h3>

            <div class="wallet-grid" aria-label="quick actions">
                <a class="wallet-item" href="{{ url('/mobile-banking/bkash') }}">
                    <div class="icon-wrap">
                        <img src="{{ asset('frontend/img/bkash.png') }}" alt="bKash" />
                    </div>
                    <span>বিকাশ</span>
                </a>

                <a class="wallet-item" href="{{ url('/mobile-banking/nagad') }}">
                    <div class="icon-wrap">
                        <img src="{{ asset('frontend/img/nagad.png') }}" alt="Nagad" />
                    </div>
                    <span>নগদ</span>
                </a>

                <a class="wallet-item" href="{{ url('/mobile-banking/rocket') }}">
                    <div class="icon-wrap">
                        <img src="{{ asset('frontend/img/rocket.png') }}" alt="Rocket" />
                    </div>
                    <span>রকেট</span>
                </a>

                <a class="wallet-item" href="{{ url('/banks') }}">
                    <div class="icon-wrap">
                        <img src="{{ asset('frontend/img/mobile-banking.png') }}" alt="Bank" />
                    </div>
                    <span>ব্যাংক</span>
                </a>
            </div>
        </section>


        <div class="swiper mySwiper" style="display: inline-block; margin-bottom: 10px !important;">
            <div class="swiper-wrapper">
                @php
                    $banners = \App\Models\Banner::get();
                  @endphp
                @foreach ($banners as $banner)
                    <div class="swiper-slide">
                        <img style="height: 200px!important;" src="{{ asset('storage/' . $banner->image_path) }}" alt="banner">
                    </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
        </div>

        <section class="mobile-banking" style="padding-bottom: 115px;">
            <h4>আজকে আমাদের কোম্পানির চলমান রেট সমূহ</h4>

            <div class="wallet-grid" aria-label="quick actions">

                @foreach(App\Models\ExchangeCountry::get() as $c)
                    <a class="wallet-item" href="{{ route('rates.show', $c) }}">
                        <div class="icon-wrap">
                            <img src="{{ asset('storage/' . $c->flag_path) }}" alt="{{ $c->name }}" alt="bKash" />
                        </div>
                        <span class="text-sm">{{ $c->name }}</span>
                    </a>
                @endforeach

            </div>
        </section>
        @include('frontend.common.sidebar')
    </div>

    <script src="https://unpkg.com/swiper@9/swiper-bundle.min.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    // যদি পেজে একটাই স্লাইডার থাকে:
    const swiper = new Swiper('.mySwiper', {
      slidesPerView: 1,
      spaceBetween: 12,
      loop: true,
      autoplay: { delay: 4000, disableOnInteraction: false },
      pagination: { el: '.swiper-pagination', clickable: true },
      // চাইলে effect: 'fade',
      // navigation: { nextEl: '.swiper-button-next', prevEl: '.swiper-button-prev' },
    });
  });
</script>
@endsection