@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gradient-to-b from-gray-50 to-white py-12">
  <div class="mx-auto max-w-2xl px-4">
    {{-- Card --}}
    <div class="relative overflow-hidden rounded-2xl bg-white shadow-xl ring-1 ring-gray-100">
      {{-- Top Accent --}}
      <div class="h-1 w-full bg-gradient-to-r from-emerald-400 via-teal-500 to-indigo-500"></div>

      <div class="p-8">
        {{-- Header --}}
        <div class="mb-6 flex items-center gap-3">
          {{-- Mail Icon --}}
          <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-teal-600" viewBox="0 0 24 24" fill="currentColor">
            <path d="M1.5 8.67v6.58A2.25 2.25 0 003.75 17.5h16.5a2.25 2.25 0 002.25-2.25V8.67l-8.708 5.234a2.25 2.25 0 01-2.284 0L1.5 8.67z" />
            <path d="M22.5 6.75v-.375A2.25 2.25 0 0020.25 4.125H3.75A2.25 2.25 0 001.5 6.375V6.75l9.208 5.534a.75.75 0 00.784 0L22.5 6.75z" />
          </svg>
          <h1 class="text-2xl font-semibold tracking-tight text-gray-900">Contact Us</h1>
        </div>

        {{-- Success Alert --}}
        @if(session('success'))
          <div class="mb-6 flex items-start gap-3 rounded-xl border border-emerald-200 bg-emerald-50 p-4 text-emerald-800">
            <svg xmlns="http://www.w3.org/2000/svg" class="mt-0.5 h-5 w-5 flex-none" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16Zm3.857-10.809a.75.75 0 00-1.214-.882l-3.39 4.667-1.7-1.7a.75.75 0 10-1.06 1.061l2.25 2.25a.75.75 0 001.158-.095l3.956-5.301z" clip-rule="evenodd" />
            </svg>
            <div class="text-sm font-medium">{{ session('success') }}</div>
          </div>
        @endif

        {{-- Form --}}
        <form method="POST" action="{{ route('contact.submit') }}" novalidate>
          @csrf

          <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
            {{-- Name --}}
            <div class="md:col-span-1">
              <label class="mb-2 block text-sm font-medium text-gray-700">Name</label>
              <div class="relative">
                <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400">
                  {{-- User Icon --}}
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                    <path d="M10 12a5 5 0 100-10 5 5 0 000 10Zm-7 6a7 7 0 1114 0H3z" />
                  </svg>
                </span>
                <input
                  type="text"
                  name="name"
                  value="{{ old('name') }}"
                  required
                  class="block w-full rounded-xl border border-gray-200 bg-white pl-10 pr-3 py-2.5 text-gray-900 placeholder-gray-400 shadow-sm outline-none transition focus:border-teal-400 focus:ring-4 focus:ring-teal-100 @error('name') border-red-300 focus:border-red-400 focus:ring-red-100 @enderror"
                  placeholder="Your full name"
                />
              </div>
              @error('name')
                <p class="mt-1.5 text-sm text-red-600">{{ $message }}</p>
              @enderror
            </div>

            {{-- Email --}}
            <div class="md:col-span-1">
              <label class="mb-2 block text-sm font-medium text-gray-700">Email</label>
              <div class="relative">
                <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400">
                  {{-- Envelope Icon --}}
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M1.5 8.67v6.58A2.25 2.25 0 003.75 17.5h16.5a2.25 2.25 0 002.25-2.25V8.67l-8.708 5.234a2.25 2.25 0 01-2.284 0L1.5 8.67z" />
                    <path d="M22.5 6.75v-.375A2.25 2.25 0 0020.25 4.125H3.75A2.25 2.25 0 001.5 6.375V6.75l9.208 5.534a.75.75 0 00.784 0L22.5 6.75z" />
                  </svg>
                </span>
                <input
                  type="email"
                  name="email"
                  value="{{ old('email') }}"
                  required
                  class="block w-full rounded-xl border border-gray-200 bg-white pl-10 pr-3 py-2.5 text-gray-900 placeholder-gray-400 shadow-sm outline-none transition focus:border-teal-400 focus:ring-4 focus:ring-teal-100 @error('email') border-red-300 focus:border-red-400 focus:ring-red-100 @enderror"
                  placeholder="you@example.com"
                />
              </div>
              @error('email')
                <p class="mt-1.5 text-sm text-red-600">{{ $message }}</p>
              @enderror
            </div>

            {{-- Subject --}}
            <div class="md:col-span-2">
              <label class="mb-2 block text-sm font-medium text-gray-700">Subject</label>
              <div class="relative">
                <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400">
                  {{-- Tag Icon --}}
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                    <path d="M17.707 10.293l-7-7A1 1 0 009.293 3H4a1 1 0 00-1 1v5.293a1 1 0 00.293.707l7 7a1 1 0 001.414 0l6-6a1 1 0 000-1.414zM7 7a1 1 0 110-2 1 1 0 010 2z"/>
                  </svg>
                </span>
                <input
                  type="text"
                  name="subject"
                  value="{{ old('subject') }}"
                  required
                  class="block w-full rounded-xl border border-gray-200 bg-white pl-10 pr-3 py-2.5 text-gray-900 placeholder-gray-400 shadow-sm outline-none transition focus:border-teal-400 focus:ring-4 focus:ring-teal-100 @error('subject') border-red-300 focus:border-red-400 focus:ring-red-100 @enderror"
                  placeholder="How can we help?"
                />
              </div>
              @error('subject')
                <p class="mt-1.5 text-sm text-red-600">{{ $message }}</p>
              @enderror
            </div>

            {{-- WhatsApp --}}
            <div class="md:col-span-1">
              <label class="mb-2 block text-sm font-medium text-gray-700">WhatsApp</label>
              <div class="relative">
                <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400">
                  {{-- Phone Icon --}}
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M2.25 6.75c0 8.008 6.492 14.5 14.5 14.5.93 0 1.84-.09 2.72-.26a1.5 1.5 0 001.18-1.47v-2.74a1.5 1.5 0 00-1.24-1.48l-3.26-.54a1.5 1.5 0 00-1.42.5l-.88 1.02a.75.75 0 01-.77.23 11.5 11.5 0 01-7.3-7.3.75.75 0 01.22-.77l1.03-.88a1.5 1.5 0 00.5-1.42l-.54-3.26A1.5 1.5 0 005.72 2H3a1.5 1.5 0 00-1.5 1.3c-.17.89-.25 1.79-.25 2.7z"/>
                  </svg>
                </span>
                <input
                  type="text"
                  name="whatsapp"
                  value="{{ old('whatsapp') }}"
                  placeholder="+8801XXXXXXXXX"
                  class="block w-full rounded-xl border border-gray-200 bg-white pl-10 pr-3 py-2.5 text-gray-900 placeholder-gray-400 shadow-sm outline-none transition focus:border-teal-400 focus:ring-4 focus:ring-teal-100 @error('whatsapp') border-red-300 focus:border-red-400 focus:ring-red-100 @enderror"
                />
              </div>
              @error('whatsapp')
                <p class="mt-1.5 text-sm text-red-600">{{ $message }}</p>
              @enderror
            </div>

            {{-- Message --}}
            <div class="md:col-span-2">
              <label class="mb-2 block text-sm font-medium text-gray-700">Message</label>
              <div class="relative">
                <span class="pointer-events-none absolute left-0 top-0 flex h-11 items-center pl-3 text-gray-400">
                  {{-- Chat Bubble Icon --}}
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M7.5 3.75A3.75 3.75 0 003.75 7.5v6A3.75 3.75 0 007.5 17.25h4.19l3.56 2.67a.75.75 0 001.2-.6v-2.07h.75a3.75 3.75 0 003.75-3.75v-2.25a3.75 3.75 0 00-3.75-3.75h-10.5z"/>
                  </svg>
                </span>
                <textarea
                  name="message"
                  rows="6"
                  required
                  class="block w-full rounded-xl border border-gray-200 bg-white pl-10 pr-3 py-2.5 text-gray-900 placeholder-gray-400 shadow-sm outline-none transition focus:border-teal-400 focus:ring-4 focus:ring-teal-100 @error('message') border-red-300 focus:border-red-400 focus:ring-red-100 @enderror"
                  placeholder="Write your message…">{{ old('message') }}</textarea>
              </div>
              @error('message')
                <p class="mt-1.5 text-sm text-red-600">{{ $message }}</p>
              @enderror

              {{-- Tiny helper text --}}
              <p class="mt-2 text-xs text-gray-500">
                We typically reply within 1–2 business days.
              </p>
            </div>
          </div>

          {{-- Submit --}}
          <div class="mt-8">
            <button
              type="submit"
              class="group inline-flex w-full items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-emerald-500 to-teal-600 px-5 py-3.5 text-base font-semibold text-white shadow-lg shadow-emerald-200 transition hover:from-emerald-600 hover:to-teal-700 focus:outline-none focus:ring-4 focus:ring-emerald-200 active:scale-[.99]"
            >
              {{-- Paper Airplane Icon --}}
              <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 transition-transform group-hover:-translate-y-0.5" viewBox="0 0 20 20" fill="currentColor">
                <path d="M3.172 7.172a4 4 0 012.121-1.06l9.193-1.84a1 1 0 011.18 1.18l-1.84 9.192a4 4 0 01-1.06 2.122l-1.122 1.121a.5.5 0 01-.707 0l-3.364-3.364a.5.5 0 010-.707l4.243-4.243a1 1 0 10-1.414-1.414L6.437 12.5a2.5 2.5 0 000 3.536l1.768 1.768a2.5 2.5 0 003.536 0l1.121-1.121a6 6 0 001.59-3.183l1.84-9.192A3 3 0 0015.486.86L6.293 2.7a6 6 0 00-3.182 1.59L1.99 5.41a2.5 2.5 0 000 3.536l.475.475a.75.75 0 101.06-1.06l-.353-.353a1 1 0 010-1.414l.001-.001z" />
              </svg>
              Send Message
            </button>
          </div>
        </form>
      </div>
    </div>

    {{-- Footer note --}}
    <p class="mt-6 text-center text-sm text-gray-500">
      By submitting, you agree to our <a href="#" class="font-medium text-teal-600 hover:underline">privacy policy</a>.
    </p>
  </div>
</div>
@endsection
