<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  @php
      $companySetup = \App\Models\CompanySetup::first();
  @endphp
  <title>{{ $companySetup->company_name ?? config('app.name') }} - নিবন্ধন (ধাপ ১/৩)</title>

  @if($companySetup && $companySetup->fav_icon)
      <link rel="icon" href="{{ asset('storage/'.$companySetup->fav_icon) }}" type="image/png">
  @endif

  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            mint: {50:'#effcf7',100:'#d9faf0',200:'#baf4e3',300:'#8febd1',400:'#5fdbba',500:'#34c9a3',600:'#22b08f',700:'#1a8d74',800:'#176f5d',900:'#145a4c'}
          },
          boxShadow: { soft: '0 10px 25px rgba(0,0,0,0.06)' },
          fontFamily: { bangla: ['Noto Sans Bengali','Hind Siliguri','ui-sans-serif','system-ui'] }
        }
      }
    }
  </script>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    .btn-gradient { background-image: linear-gradient(90deg, #22b08f, #176f5d); }
    .btn-gradient:hover { filter: brightness(1.05); }
    .card-dashed { border: 2px dashed rgba(34,176,143,0.30); }
  </style>
</head>
<body class="min-h-screen bg-gradient-to-b from-mint-50 to-white font-bangla">
  <div class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">

      @if(session('success'))
        <div class="mb-4 p-3 rounded-xl bg-mint-100 text-mint-800 border border-mint-200">
          {{ session('success') }}
        </div>
      @endif

      <div class="flex flex-col items-center mb-6">
        <div class="w-16 h-16 rounded-2xl bg-mint-100 flex items-center justify-center shadow-soft">
          <svg viewBox="0 0 24 24" class="w-9 h-9 text-mint-700" fill="currentColor" aria-hidden="true">
            <path d="M6 18a4 4 0 0 1 1.2-7.8A5 5 0 0 1 18 8a4 4 0 0 1 1 7.87V16a3 3 0 0 1-3 3H9a3 3 0 0 1-3-3v2z" opacity=".25"/>
            <path d="M9 11a3 3 0 1 1 6 0v1h.5A2.5 2.5 0 0 1 18 14.5v2A2.5 2.5 0 0 1 15.5 19h-7A2.5 2.5 0 0 1 6 16.5v-2A2.5 2.5 0 0 1 8.5 12H9v-1zm2 1h2v-1a1 1 0 1 0-2 0v1z"/>
          </svg>
        </div>
        <h1 class="mt-3 text-2xl font-bold text-mint-800">নিবন্ধন করুন</h1>
        <p class="text-xs text-mint-700/80 mt-1">ধাপ ১/৩ – মৌলিক তথ্য</p>
        <div class="mt-1 h-1 w-28 bg-mint-200 rounded-full"></div>
      </div>

      <div class="bg-white rounded-3xl shadow-soft p-6 border border-mint-100">
        <form action="{{ route('register.step1.store') }}" method="POST" class="space-y-4" enctype="multipart/form-data">
          @csrf

          @if ($errors->any())
            <div class="p-3 rounded-xl bg-red-50 text-red-700 border border-red-200 text-sm">
              <ul class="list-disc list-inside space-y-1">
                @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
          @endif

          {{-- নাম --}}
          <div>
            <label class="block text-sm font-medium text-mint-800 mb-1">পূর্ণ নাম</label>
            <div class="relative">
              <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-mint-700/70">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="w-5 h-5" fill="currentColor"><path d="M12 12a5 5 0 1 0 0-10 5 5 0 0 0 0 10Zm-2.75 2.5A3.75 3.75 0 0 0 5.5 18.25v.25A1.5 1.5 0 0 0 7 20h10a1.5 1.5 0 0 0 1.5-1.5v-.25a3.75 3.75 0 0 0-3.75-3.75h-5.5Z"/></svg>
              </span>
              <input type="text" name="name" value="{{ old('name') }}" placeholder="আপনার পূর্ণ নাম" class="w-full pl-11 pr-3 py-3 rounded-xl border-2 border-mint-200 bg-mint-50 focus:bg-white focus:outline-none focus:border-mint-500 transition" required>
            </div>
          </div>

          {{-- ফোন --}}
          <div>
            <label class="block text-sm font-medium text-mint-800 mb-1">ফোন নম্বর</label>
            <div class="relative">
              <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-mint-700/70">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="w-5 h-5" fill="currentColor"><path d="M6.62 10.79a15.91 15.91 0 0 0 6.59 6.59l1.82-1.82a1 1 0 0 1 1.04-.24c1.14.38 2.37.59 3.63.59a1 1 0 0 1 1 1V20a2 2 0 0 1-2 2C9.61 22 2 14.39 2 5a2 2 0 0 1 2-2h2.09a1 1 0 0 1 1 1c0 1.26.2 2.49.59 3.63a1 1 0 0 1-.25 1.04l-1.81 1.82Z"/></svg>
              </span>
              <input type="tel" name="phone" value="{{ old('phone') }}" placeholder="আপনার ফোন নম্বর" class="w-full pl-11 pr-3 py-3 rounded-xl border-2 border-mint-200 bg-mint-50 focus:bg-white focus:outline-none focus:border-mint-500 transition" required>
            </div>
          </div>

          {{-- ইমেইল --}}
          <div>
            <label class="block text-sm font-medium text-mint-800 mb-1">ইমেইল</label>
            <div class="relative">
              <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-mint-700/70">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="w-5 h-5" fill="currentColor">
                  <path d="M2.25 6.75A2.25 2.25 0 0 1 4.5 4.5h15a2.25 2.25 0 0 1 2.25 2.25v10.5A2.25 2.25 0 0 1 19.5 19.5h-15A2.25 2.25 0 0 1 2.25 17.25V6.75Zm2.28-.75A.78.78 0 0 0 3.75 6.78l7.47 5.24a1.5 1.5 0 0 0 1.74 0l7.47-5.24a.78.78 0 0 0-.78-0.78h-15Z"/>
                </svg>
              </span>
              <input type="email" name="email" value="{{ old('email') }}" placeholder="আপনার ইমেইল" class="w-full pl-11 pr-3 py-3 rounded-xl border-2 border-mint-200 bg-mint-50 focus:bg-white focus:outline-none focus:border-mint-500 transition" required>
            </div>
          </div>

          {{-- Avatar --}}
          <div>
            <label class="block text-sm font-medium text-mint-800 mb-1">প্রোফাইল ছবি (ঐচ্ছিক)</label>
            <div class="card-dashed rounded-2xl p-5 bg-mint-50/60 flex flex-col items-center text-center">
              <p class="text-sm text-mint-800">একটি ছবি টেনে এনে ছেড়ে দিন বা</p>
              <label class="mt-3 inline-flex items-center gap-2 px-4 py-2 rounded-xl text-white btn-gradient cursor-pointer shadow-soft">
                ছবি আপলোড করুন
                <input type="file" name="avatar" accept="image/*" class="hidden" id="avatarInput">
              </label>
              <p id="fileName" class="mt-2 text-xs text-mint-700/70"></p>
            </div>
          </div>

          <button type="submit" class="btn-gradient w-full text-white font-semibold py-3 rounded-2xl shadow-soft">
            পরবর্তী ধাপ
          </button>

          <p class="text-center text-sm text-mint-800 mt-2">
            ইতিমধ্যে অ্যাকাউন্ট আছে?
            <a href="{{ route('login') }}" class="text-mint-700 font-semibold hover:underline">লগইন করুন</a>
          </p>
        </form>
      </div>
    </div>
  </div>

  <script>
    const input = document.getElementById('avatarInput');
    const nameEl = document.getElementById('fileName');
    if (input) {
      input.addEventListener('change', () => {
        const f = input.files && input.files[0];
        nameEl.textContent = f ? `নির্বাচিত: ${f.name}` : '';
      });
    }
  </script>
</body>
</html>
