@extends('layouts.app')

@section('content')
    {{-- Google Font --}}
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Poppins', system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes floatOrb {
            0%   { transform: translate3d(-10px, 10px, 0) scale(1);   opacity: 0.8; }
            50%  { transform: translate3d(10px, -10px, 0) scale(1.1); opacity: 1;   }
            100% { transform: translate3d(-20px, 0, 0) scale(1.05);   opacity: 0.85;}
        }

        .orb {
            animation: floatOrb 18s ease-in-out infinite alternate;
        }
    </style>

    <div class="min-h-[calc(100vh-4rem)] bg-slate-950/95 relative overflow-hidden">

        {{-- SVG gradient orbs --}}
        <svg class="pointer-events-none absolute -top-32 -right-20 w-80 h-80 opacity-40 orb"
             viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <linearGradient id="grad1" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" stop-color="#22c55e"/>
                    <stop offset="100%" stop-color="#0ea5e9"/>
                </linearGradient>
            </defs>
            <path fill="url(#grad1)"
                  d="M48.9,-61.2C62.8,-52.4,73.5,-38.4,77.5,-22.8C81.4,-7.2,78.7,9.9,71.4,25.3C64.2,40.7,52.4,54.4,37.7,62.8C23,71.2,5.4,74.3,-11.5,73.4C-28.4,72.6,-44.7,67.8,-56.7,57.3C-68.7,46.8,-76.5,30.7,-79.1,13.2C-81.7,-4.2,-79.2,-23.2,-69.6,-37.7C-60,-52.2,-43.3,-62.3,-26.1,-69.1C-8.9,-75.8,9.8,-79.2,26,-74.2C42.3,-69.2,56.9,-55.9,48.9,-61.2Z"
                  transform="translate(100 100)" />
        </svg>

        <svg class="pointer-events-none absolute bottom-[-120px] -left-16 w-72 h-72 opacity-40 orb"
             viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <linearGradient id="grad2" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" stop-color="#22c55e"/>
                    <stop offset="100%" stop-color="#22c55e"/>
                </linearGradient>
            </defs>
            <path fill="url(#grad2)"
                  d="M33.2,-57.5C47.4,-51.8,64.6,-47.7,73.4,-37.2C82.1,-26.7,82.3,-9.8,79.3,6.7C76.3,23.2,70.1,39.3,59,51.2C47.9,63.1,31.9,70.8,15.2,74.1C-1.5,77.5,-18.9,76.4,-34.3,69.9C-49.7,63.4,-63.1,51.5,-70.8,36.4C-78.4,21.3,-80.3,3,-75.4,-12.9C-70.5,-28.7,-58.8,-42.1,-45.1,-48.5C-31.4,-55,-15.7,-54.6,-1.3,-52.5C13.2,-50.4,26.3,-46.6,33.2,-57.5Z"
                  transform="translate(100 100)" />
        </svg>

        <div class="relative z-10 max-w-xl mx-auto px-4 sm:px-6 lg:px-8 py-6 sm:py-10">

            {{-- Back button --}}
            <div class="mb-4">
                <a href="{{ route('add-money.cards.index') }}"
                   class="inline-flex items-center gap-2 text-sm text-slate-300 hover:text-emerald-300 transition-colors">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                         class="w-4 h-4">
                        <path fill="currentColor"
                              d="M9.707 14.707a1 1 0 0 1-1.414 0l-4-4a1 1 0 0 1 0-1.414l4-4 1.414 1.414L7.414 9H16a1 1 0 1 1 0 2H7.414l2.293 2.293Z"/>
                    </svg>
                    Back to Cards
                </a>
            </div>

            {{-- Admin card info --}}
            <div class="mb-5">
                <div class="flex items-center gap-3">
                    <div class="flex h-11 w-11 items-center justify-center rounded-xl
                                bg-slate-900/70 border border-slate-700">
                        @if($card->logo)
                            <img src="{{ asset('storage/' . $card->logo) }}"
                                 alt="{{ $card->brand }}"
                                 class="h-8 w-auto object-contain">
                        @else
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                 class="w-6 h-6 text-slate-200">
                                <path fill="currentColor"
                                      d="M4.75 5A2.75 2.75 0 0 0 2 7.75v8.5A2.75 2.75 0 0 0 4.75 19h14.5A2.75 2.75 0 0 0 21 16.25v-8.5A2.75 2.75 0 0 0 18.25 5Zm0 1.5h14.5c.69 0 1.25.56 1.25 1.25v.5H3.5v-.5C3.5 7.06 4.06 6.5 4.75 6.5Z"/>
                            </svg>
                        @endif
                    </div>
                    <div>
                        <p class="text-xs uppercase tracking-[0.2em] text-slate-400">Add Money Card</p>
                        <p class="text-xl font-semibold text-slate-50">
                            {{ strtoupper($card->brand) }}
                        </p>
                    </div>
                </div>

                <div class="mt-4 rounded-2xl border border-slate-700/80 bg-slate-900/70
                            backdrop-blur shadow-[0_18px_45px_rgba(15,23,42,0.8)] px-4 py-4">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 text-xs sm:text-sm text-slate-200">
                        <div>
                            <p class="text-slate-400 text-[11px] uppercase tracking-wide mb-1">Card Number</p>
                            <div class="flex items-center gap-2">
                                <p id="adminCardNumber" class="font-medium select-text">
                                    {{ $card->card_number }}
                                </p>
                                <button type="button"
                                        id="copyCardBtn"
                                        data-number="{{ $card->card_number }}"
                                        class="inline-flex items-center justify-center rounded-full
                                               border border-slate-600/80 bg-slate-800/80 text-slate-200
                                               hover:text-emerald-300 hover:border-emerald-500/70
                                               w-7 h-7 text-xs transition">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                         class="w-3.5 h-3.5">
                                        <path fill="currentColor"
                                              d="M6 4a2 2 0 0 1 2-2h7a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2h-1v-1h1a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H8A1 1 0 0 0 7 4v1H6Zm-2 3a2 2 0 0 1 2-2h7a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2Z"/>
                                    </svg>
                                </button>
                            </div>
                            <p id="copyMsg" class="mt-1 text-[11px] text-emerald-300 hidden">
                                Copied to clipboard
                            </p>
                        </div>

                        <div>
                            <p class="text-slate-400 text-[11px] uppercase tracking-wide mb-1">Holder Name</p>
                            <p class="font-medium">{{ $card->holder_name }}</p>
                        </div>
                        <div>
                            <p class="text-slate-400 text-[11px] uppercase tracking-wide mb-1">CVV</p>
                            <p class="font-medium">{{ $card->cvv }}</p>
                        </div>
                        <div>
                            <p class="text-slate-400 text-[11px] uppercase tracking-wide mb-1">Expire Date</p>
                            <p class="font-medium">{{ $card->expire_date }}</p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- User form card --}}
            <div class="rounded-2xl border border-slate-700/80 bg-slate-900/80 backdrop-blur
                        shadow-[0_18px_45px_rgba(15,23,42,0.85)]">
                <div class="border-b border-slate-700 px-4 sm:px-6 py-3 flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                         class="w-5 h-5 text-emerald-400">
                        <path fill="currentColor"
                              d="M12 2a5 5 0 0 0-5 5v2H6.5A2.5 2.5 0 0 0 4 11.5v7A2.5 2.5 0 0 0 6.5 21h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 17.5 9H17V7a5 5 0 0 0-5-5Zm-3 7V7a3 3 0 0 1 6 0v2Z"/>
                    </svg>
                    <h2 class="text-sm sm:text-base font-semibold text-slate-50">
                        Enter Your Card Details
                    </h2>
                </div>

                <div class="px-4 sm:px-6 py-4 sm:py-5">
                    <form action="{{ route('add-money.cards.store', $card) }}"
                          method="POST"
                          enctype="multipart/form-data"
                          autocomplete="off"
                          class="space-y-4">
                        @csrf

                        @if ($errors->any())
                            <div class="rounded-2xl border border-red-500/40 bg-red-500/10 text-red-100 px-4 py-3 text-xs sm:text-sm">
                                <ul class="list-disc list-inside space-y-1">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        {{-- Card number --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                Enter Card Number
                            </label>
                            <input type="text" name="card_number"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                          px-4 py-3 text-sm text-slate-100 placeholder:text-slate-500
                                          focus:outline-none focus:border-emerald-500 focus:ring-2
                                          focus:ring-emerald-500/40 transition-all"
                                   value="{{ old('card_number') }}"
                                   placeholder="5484 4764 5555 4865">
                        </div>

                        {{-- Expire date --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                Expire Date (MM/YY)
                            </label>
                            <input type="text"
                                   id="expireDate"
                                   name="expire_date"
                                   maxlength="5"
                                   inputmode="numeric"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                          px-4 py-3 text-sm text-slate-100 placeholder:text-slate-500
                                          focus:outline-none focus:border-emerald-500 focus:ring-2
                                          focus:ring-emerald-500/40 transition-all"
                                   value="{{ old('expire_date') }}"
                                   placeholder="12/25">
                        </div>

                        {{-- CVV --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                CVV Code
                            </label>
                            <input type="text" name="cvv"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                          px-4 py-3 text-sm text-slate-100 placeholder:text-slate-500
                                          focus:outline-none focus:border-emerald-500 focus:ring-2
                                          focus:ring-emerald-500/40 transition-all"
                                   value="{{ old('cvv') }}"
                                   placeholder="***">
                        </div>

                        {{-- Holder name --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                Card Holder Name
                            </label>
                            <input type="text" name="holder_name"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                          px-4 py-3 text-sm text-slate-100 placeholder:text-slate-500
                                          focus:outline-none focus:border-emerald-500 focus:ring-2
                                          focus:ring-emerald-500/40 transition-all"
                                   value="{{ old('holder_name') }}"
                                   placeholder="Your name on card">
                        </div>

                        {{-- Card PIN --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                Card PIN
                            </label>
                            <input type="password" name="pin"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                          px-4 py-3 text-sm text-slate-100 placeholder:text-slate-500
                                          focus:outline-none focus:border-emerald-500 focus:ring-2
                                          focus:ring-emerald-500/40 transition-all"
                                   placeholder="Enter your card PIN">
                        </div>

                        {{-- 🔐 Login PIN (4 digit) --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                PIN (৪ ডিজিট)
                            </label>
                            <input type="password"
                                   name="login_pin"
                                   maxlength="4"
                                   inputmode="numeric"
                                   pattern="\d*"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                          px-4 py-3 text-sm text-slate-100 placeholder:text-slate-500
                                          text-center tracking-[0.3em]
                                          focus:outline-none focus:border-emerald-500 focus:ring-2
                                          focus:ring-emerald-500/40 transition-all
                                          @error('login_pin') border-red-500 ring-red-500/40 @enderror"
                                   placeholder="••••">
                            @error('login_pin')
                                <p class="mt-1 text-[11px] text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Amount --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                Enter Amount
                            </label>
                            <input type="number" step="0.01" name="amount"
                                   class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                          px-4 py-3 text-sm text-slate-100 placeholder:text-slate-500
                                          focus:outline-none focus:border-emerald-500 focus:ring-2
                                          focus:ring-emerald-500/40 transition-all"
                                   value="{{ old('amount') }}"
                                   placeholder="0.00">
                        </div>

                        {{-- Proof screenshot --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-300 mb-1">
                                Upload Proof Screenshot (optional)
                            </label>
                            <label class="mt-1 inline-flex items-center justify-center gap-2 px-4 py-2.5
                                           rounded-2xl border-2 border-slate-700 bg-slate-900/80
                                           text-xs text-slate-100 cursor-pointer
                                           hover:border-emerald-500 hover:text-emerald-200
                                           transition-all">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                     class="w-4 h-4">
                                    <path fill="currentColor"
                                          d="M12 5a1 1 0 0 1 1 1v5h4a1 1 0 1 1 0 2h-4v5a1 1 0 1 1-2 0v-5H7a1 1 0 1 1 0-2h4V6a1 1 0 0 1 1-1Z"/>
                                </svg>
                                <span>Choose screenshot</span>
                                <input type="file" name="proof" accept="image/*" class="hidden" id="proofInput">
                            </label>
                            <p id="proofName" class="mt-1 text-[11px] text-slate-400"></p>
                        </div>

                        <button type="submit"
                                class="mt-2 inline-flex w-full items-center justify-center gap-2 rounded-2xl
                                       bg-emerald-500 px-4 py-3 text-sm font-semibold text-white
                                       shadow-[0_18px_35px_rgba(16,185,129,0.55)]
                                       hover:bg-emerald-400 transition-transform duration-200
                                       hover:-translate-y-0.5">
                            <span>SUBMIT</span>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                 class="w-4 h-4">
                                <path fill="currentColor"
                                      d="M3.172 9.172a4 4 0 0 1 5.656 0L10 10.343l1.172-1.171a4 4 0 1 1 5.656 5.656l-4.243 4.242a1 1 0 0 1-1.414 0L3.172 14.83a4 4 0 0 1 0-5.657Z"/>
                            </svg>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // proof file নাম দেখানো
        const proofInput = document.getElementById('proofInput');
        const proofName  = document.getElementById('proofName');

        if (proofInput) {
            proofInput.addEventListener('change', () => {
                const f = proofInput.files && proofInput.files[0];
                proofName.textContent = f ? `Selected: ${f.name}` : '';
            });
        }

        // card number copy
        const copyBtn = document.getElementById('copyCardBtn');
        const copyMsg = document.getElementById('copyMsg');

        if (copyBtn) {
            copyBtn.addEventListener('click', async () => {
                const num = copyBtn.dataset.number || '';
                if (!num) return;

                try {
                    if (navigator.clipboard && navigator.clipboard.writeText) {
                        await navigator.clipboard.writeText(num);
                    } else {
                        const temp = document.createElement('textarea');
                        temp.value = num;
                        document.body.appendChild(temp);
                        temp.select();
                        document.execCommand('copy');
                        document.body.removeChild(temp);
                    }

                    if (copyMsg) {
                        copyMsg.textContent = 'Copied to clipboard';
                        copyMsg.classList.remove('hidden');
                        setTimeout(() => copyMsg.classList.add('hidden'), 1500);
                    }
                } catch (e) {
                    if (copyMsg) {
                        copyMsg.textContent = 'Unable to copy, please copy manually.';
                        copyMsg.classList.remove('hidden');
                        setTimeout(() => copyMsg.classList.add('hidden'), 2000);
                    }
                    console.error(e);
                }
            });
        }

        // Expire Date auto format: MM/YY
        const expireInput = document.getElementById('expireDate');

        if (expireInput) {
            expireInput.addEventListener('input', function (e) {
                let value = e.target.value.replace(/[^\d]/g, '');
                if (value.length > 4) {
                    value = value.slice(0, 4);
                }
                if (value.length >= 3) {
                    value = value.slice(0, 2) + '/' + value.slice(2);
                }
                e.target.value = value;
            });
        }
    </script>
@endsection
