@extends('layouts.app')
@section('title','আমার ব্যাংক ডিপোজিট')
@section('content')
<div class="max-w-5xl mx-auto px-3 py-4">

  <div class="flex items-center justify-between mb-4">
    <h2 class="text-xl font-semibold text-slate-800">আমার ব্যাংক ডিপোজিট</h2>
    <a href="{{ route('addmoney_bank.methods') }}"
       class="inline-flex items-center gap-2 rounded-xl border border-slate-200 px-3 py-2 text-sm text-slate-700 hover:bg-slate-50">
      <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
        <path d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z"/>
      </svg>
      নতুন ডিপোজিট
    </a>
  </div>

  <div class="overflow-hidden rounded-2xl ring-1 ring-slate-200 bg-white">
    <div class="overflow-x-auto">
      <table class="min-w-full text-left text-sm">
        <thead class="bg-slate-50 text-slate-600">
          <tr>
            <th class="px-4 py-3">#</th>
            <th class="px-4 py-3">রেফারেন্স</th>
            <th class="px-4 py-3">মেথড</th>
            <th class="px-4 py-3">পরিমাণ</th>
            <th class="px-4 py-3">স্ট্যাটাস</th>
            <th class="px-4 py-3">তারিখ</th>
            <th class="px-4 py-3 text-right">প্রুফ</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-slate-100">
          @forelse($banks as $b)
            <tr class="hover:bg-slate-50/60">
              <td class="px-4 py-3">{{ $b->id }}</td>
              <td class="px-4 py-3">
                <code class="px-1 py-0.5 bg-slate-100 rounded">{{ $b->reference }}</code>
              </td>
              <td class="px-4 py-3">{{ $b->method->bank_name ?? '-' }}</td>
              <td class="px-4 py-3 whitespace-nowrap">{{ number_format($b->amount, 2) }}</td>
              <td class="px-4 py-3">
                @php
                  $color = [
                    'pending'  => 'bg-amber-100 text-amber-800',
                    'approved' => 'bg-emerald-100 text-emerald-700',
                    'rejected' => 'bg-rose-100 text-rose-700',
                  ][$b->status] ?? 'bg-slate-100 text-slate-700';
                @endphp
                <span class="uppercase text-[11px] px-2 py-0.5 rounded {{ $color }}">{{ $b->status }}</span>
              </td>
              <td class="px-4 py-3">{{ $b->created_at->format('Y-m-d H:i') }}</td>
              <td class="px-4 py-3 text-right">
                @if($b->proof_screenshot)
                  <a href="{{ asset('storage/'.$b->proof_screenshot) }}" target="_blank"
                     class="inline-flex items-center gap-1 text-teal-700 hover:text-teal-800">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                      <path d="M14 3h3a1 1 0 011 1v3a1 1 0 11-2 0V6.414l-6.293 6.293a1 1 0 01-1.414-1.414L14.586 5H14a1 1 0 110-2z"/>
                      <path d="M5 4a1 1 0 00-1 1v10a1 1 0 001 1h10a1 1 0 001-1v-5a1 1 0 112 0v5a3 3 0 01-3 3H5a3 3 0 01-3-3V5a3 3 0 013-3h5a1 1 0 010 2H5z"/>
                    </svg>
                    দেখুন
                  </a>
                @else
                  <span class="text-slate-400">—</span>
                @endif
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="7" class="px-4 py-8 text-center text-slate-500">
                কোনো ডিপোজিট নেই
              </td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    @if($banks->hasPages())
      <div class="px-4 py-3 border-t border-slate-100">
        {{ $banks->links() }}
      </div>
    @endif
  </div>
</div>
@endsection
