@extends('layouts.app')

@section('content')
  <style>
    /* === Custom look to match screenshot === */
    .card-soft {
      background: #fff;
      border: 1px solid rgba(15, 23, 42, .06);
      box-shadow: 0 8px 24px rgba(2, 13, 20, .08);
    }

    .card-soft.rounded-2xl {
      border-radius: 1rem;
    }

    .card-soft .inner {
      box-shadow: inset 0 1px 0 rgba(255, 255, 255, .7);
    }

    .accent-top {
      position: relative;
    }

    .accent-top::before {
      content: "";
      position: absolute;
      left: 0;
      right: 0;
      top: 0;
      height: 6px;
      background: linear-gradient(90deg, #2dd4bf 0%, #0ea5e9 100%);
      border-top-left-radius: 1rem;
      border-top-right-radius: 1rem;
    }

    .item-row {
      border-radius: 12px;
      transition: .15s ease;
    }

    .item-row:active {
      transform: scale(.996);
    }

    .icon-badge {
      width: 42px;
      height: 42px;
      border-radius: 12px;
      display: grid;
      place-items: center;
      background: linear-gradient(180deg, #eaf7f4 0%, #dff4ef 100%);
      box-shadow: inset 0 1px 0 rgba(255, 255, 255, .9);
    }

    .chev {
      font-weight: 700;
      letter-spacing: .5px;
    }

    .btn-cta {
      border-radius: 12px;
      color: #fff;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: .75rem 1.25rem;
      font-weight: 600;
      box-shadow: 0 12px 28px rgba(0, 0, 0, .08);
    }

    .btn-cta.teal {
      background: linear-gradient(180deg, #10b981, #0e9f6e);
    }

    .btn-cta.blue {
      background: linear-gradient(180deg, #3b82f6, #2563eb);
    }

    /* --- Switch: prettier, smoother, accessible --- */
    .switch {
      --sw-w: 46px;
      --sw-h: 24px;
      --sw-pad: 3px;
      --sw-knob: calc(var(--sw-h) - var(--sw-pad) * 2);

      position: relative;
      width: var(--sw-w);
      height: var(--sw-h);
      border-radius: 999px;
      background: #e5e7eb; /* neutral bg */
      box-shadow: inset 0 1px 2px rgba(2,13,20,.08);
      transition: background .2s ease, box-shadow .2s ease, transform .06s ease;
      display: inline-flex;
      align-items: center;
    }

    .switch:hover { box-shadow: inset 0 1px 2px rgba(2,13,20,.12); }
    .switch:active { transform: scale(.98); }

    .switch .knob {
      position: absolute;
      top: var(--sw-pad);
      left: var(--sw-pad);
      width: var(--sw-knob);
      height: var(--sw-knob);
      border-radius: 999px;
      background: #fff;
      box-shadow: 0 2px 6px rgba(2,13,20,.12), inset 0 1px 0 rgba(255,255,255,.8);
      transition: transform .22s cubic-bezier(.22,.61,.36,1), background .2s ease;
      will-change: transform;
    }

    .switch.on {
      background: linear-gradient(180deg, #10b981, #0e9f6e);
    }

    .switch.on .knob {
      transform: translateX(calc(var(--sw-w) - var(--sw-h)));
    }

    /* Focus ring for keyboard users */
    .switch:focus-visible {
      outline: none;
      box-shadow:
        0 0 0 2px #fff,
        0 0 0 4px rgba(16,185,129,.45);
    }

    /* Reduced motion users */
    @media (prefers-reduced-motion: reduce) {
      .switch,
      .switch .knob { transition: none; }
    }
  </style>

  <div x-data="{ showPwd:false, showUser:false, notify:true }" class="min-h-screen bg-[#e6f3f1] py-6 sm:py-8">
    <div class="mx-auto w-full max-w-sm sm:max-w-md px-3 sm:px-4">

      {{-- =================== Profile Card (same-to-same) =================== --}}
      @php
        $avatar = $user->avatar ?? null;
        if ($avatar && !preg_match('~^https?://~i', $avatar)) {
          $avatarUrl =  asset('storage/' . $user->avatar) ;
        } else {
          $avatarUrl = $avatar ?: 'https://i.pravatar.cc/120?img=5';
        }
        $phoneRaw = $user->phone ?? null;
        $phoneForView = $phoneRaw ?: '—';
      @endphp

      <div @click="showUser=true" role="button" tabindex="0"
        class="accent-top card-soft rounded-2xl mb-5 sm:mb-6 cursor-pointer">
        <div class="inner px-4 py-3 sm:px-5 sm:py-4">
          <div class="flex items-center gap-3">
            <img src="{{ $avatarUrl }}" alt="avatar"
              class="w-12 h-12 rounded-full object-cover ring-2 ring-white shadow" />

            <div class="min-w-0">
              <div class="text-slate-800 font-semibold text-base sm:text-lg truncate">
                {{ $user->name ?? 'Software Developer' }}
              </div>
              <div class="text-emerald-600 text-sm flex items-center gap-1.5">
                <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                  <path
                    d="M6.62 10.79a15.91 15.91 0 0 0 6.59 6.59l2.2-2.2a1 1 0 0 1 1.05-.24c1.12.37 2.33.57 3.54.57a1 1 0 0 1 1 1V21a1 1 0 0 1-1 1A17 17 0 0 1 3 7a1 1 0 0 1 1-1h3.49a1 1 0 0 1 1 1c0 1.21.2 2.42.57 3.54a1 1 0 0 1-.24 1.05l-2.2 2.2Z" />
                </svg>
                <span class="truncate">{{ $phoneForView }}</span>
              </div>
            </div>

            <button @click.stop="showUser=true"
              class="ml-auto inline-flex items-center gap-1.5 border border-emerald-200 bg-white text-slate-700 px-3 py-1.5 rounded-xl text-sm font-semibold shadow">
              <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                <path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5Zm0 2c-4.33 0-8 2.17-8 5v1h16v-1c0-2.83-3.67-5-8-5Z" />
              </svg>
              View
            </button>
          </div>
        </div>
      </div>

      {{-- =================== Settings Card (same-to-same) =================== --}}
      <div class="card-soft rounded-2xl p-4 sm:p-5">
        <h2 class="flex items-center gap-2 text-slate-700 font-semibold mb-2">
          <svg class="w-5 h-5 text-emerald-600" viewBox="0 0 24 24" fill="currentColor">
            <path
              d="M19.14 12.94a7.48 7.48 0 0 0 0-1.88l2.03-1.58a.5.5 0 0 0 .12-.64l-1.92-3.32a.5.5 0 0 0-.6-.22l-2.39.96a7.55 7.55 0 0 0-1.62-.94l-.36-2.54a.5.5 0 0 0-.5-.42h-3.84a.5.5 0 0 0-.5.42l-.36 2.54c-.57.22-1.11.52-1.62.94l-2.39-.96a.5.5 0 0 0-.6.22L2.71 8.84a.5.5 0 0 0 .12.64l2.03 1.58a7.48 7.48 0 0 0 0 1.88l-2.03 1.58a.5.5 0 0 0-.12.64l1.92 3.32a.5.5 0 0 0 .6.22l2.39-.96c.5.41 1.05.72 1.62.94l.36 2.54a.5.5 0 0 0 .5.42h3.84a.5.5 0 0 0 .5-.42l.36-2.54c.57-.22 1.11-.53 1.62-.94l2.39.96a.5.5 0 0 0 .6-.22l1.92-3.32a.5.5 0 0 0-.12-.64l-2.03-1.58Z" />
          </svg>
          Account Settings
        </h2>

        <ul class="divide-y divide-slate-100">

          {{-- PIN Change (static, UI only like screenshot) --}}
          <a href="{{ url('/profile') }}">
            <li class="item-row py-3 px-2 -mx-2 flex items-center hover:bg-slate-50">
              <div class="icon-badge mr-3">
                <svg class="w-5 h-5 text-emerald-700" viewBox="0 0 24 24" fill="currentColor">
                  <path
                    d="M12 1a5 5 0 0 0-5 5v3H5a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2h-2V6a5 5 0 0 0-5-5Zm-3 8V6a3 3 0 1 1 6 0v3H9Z" />
                </svg>
              </div>
              <div class="flex-1">
                <div class="font-semibold text-slate-800">Update Profile </div>
                <div class="text-sm text-slate-500">Update your Profile Info</div>
              </div>
              <span class="chev text-emerald-700">›</span>
            </li>
          </a>

          {{-- Password Change (opens modal) --}}
          <li @click="showPwd=true" role="button" tabindex="0"
            class="item-row py-3 px-2 -mx-2 flex items-center hover:bg-slate-50 cursor-pointer">
            <div class="icon-badge mr-3">
              <svg class="w-5 h-5 text-emerald-700" viewBox="0 0 24 24" fill="currentColor">
                <path
                  d="M12 1a5 5 0 0 0-5 5v3H5a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2h-2V6a5 5 0 0 0-5-5Zm-3 8V6a3 3 0 1 1 6 0v3H9Z" />
              </svg>
            </div>
            <div class="flex-1">
              <div class="font-semibold text-slate-800">Password Change</div>
              <div class="text-sm text-slate-500">Modify your account password</div>
            </div>
            <span class="chev text-emerald-700">›</span>
          </li>

          {{-- Notifications --}}
          <li class="item-row py-3 px-2 -mx-2 flex items-center">
            <div class="icon-badge mr-3">
              <svg class="w-5 h-5 text-emerald-700" viewBox="0 0 24 24" fill="currentColor">
                <path
                  d="M18 8a6 6 0 1 0-12 0c0 7-3 7-3 9h18c0-2-3-2-3-9Zm-6 13a2.99 2.99 0 0 0 2.816-2H9.184A2.99 2.99 0 0 0 12 21Z" />
              </svg>
            </div>
            <div class="flex-1">
              <div class="font-semibold text-slate-800">Notifications</div>
              <div class="text-sm text-slate-500">Manage your alert preferences</div>
            </div>
            <button
              @click="notify=!notify"
              class="ml-2"
              role="switch"
              :aria-checked="notify.toString()"
              :aria-label="notify ? 'Disable notifications' : 'Enable notifications'"
            >
              <span :class="notify ? 'switch on' : 'switch'"><span class="knob"></span></span>
            </button>
          </li>

          {{-- Rewards --}}
          <a href="{{ url('/rewards/convert') }}">
            <button style="cursor: pointer;" class="text-dark"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();"></button>
            <li class="item-row py-3 px-2 -mx-2 flex items-center hover:bg-slate-50">
              <div class="icon-badge mr-3">
                <svg class="w-5 h-5 text-emerald-700" viewBox="0 0 24 24" fill="currentColor">
                  <path
                    d="M12 2 9.19 8.63 2 9.27l5.46 4.73L5.82 21 12 17.77 18.18 21l-1.64-6.99L22 9.27l-7.19-.64L12 2Z" />
                </svg>
              </div>
              <div class="flex-1">
                <div class="font-semibold text-slate-800">Rewards</div>
                <div class="text-sm text-slate-500">Rewards Coin Convert in Balance</div>
              </div>
              <span class="chev text-slate-400">›</span>
            </li>
          </a>

          {{-- Logout --}}
          <li onclick="document.getElementById('logout-form').submit();"
              class="item-row py-3 px-2 -mx-2 flex items-center hover:bg-slate-50 cursor-pointer select-none">
              <div class="icon-badge mr-3" style="background:linear-gradient(180deg,#fde8e8,#ffe8e8)">
                  <svg class="w-5 h-5 text-rose-600" viewBox="0 0 24 24" fill="currentColor">
                      <path
                          d="M16 13v-2H7V8l-5 4 5 4v-3h9Z M20 3h-8a2 2 0 0 0-2 2v3h2V5h8v14h-8v-3h-2v3a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2Z" />
                  </svg>
              </div>
              <div class="flex-1">
                  <div class="font-semibold text-rose-600">Logout</div>
                  <div class="text-sm text-slate-500">Sign out of your account</div>
              </div>
              <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display:none;">
                  @csrf
              </form>
          </li>

        </ul>

        {{-- Bottom Buttons --}}
        <div class="mt-4 space-y-2">
          <a href="{{ url('/download-app') }}" class="btn-cta teal w-full">
            <svg class="w-5 h-5 mr-2" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 3 4 9v12h6v-7h4v7h6V9l-8-6Z" />
            </svg>
            Download App
          </a>
          <a href="{{ url('/contact') }}" class="btn-cta blue w-full">
            <svg class="w-5 h-5 mr-2" viewBox="0 0 24 24" fill="currentColor">
              <path d="M21 8V7l-3 2-2-1-3 2-2-1-3 2-2-1-3 2v1l3-2 2 1 3-2 2 1 3-2Z" />
            </svg>
            Contact Us
          </a>
        </div>
      </div>

      {{-- Flash --}}
      @if (session('status'))
        <div class="mt-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-3 shadow">
          {{ session('status') }}
        </div>
      @endif

      {{-- Errors --}}
      @if ($errors->any())
        <div class="mt-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 px-4 py-3 shadow">
          <ul class="list-disc pl-5 space-y-1">
            @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif
    </div>

    {{-- ======= Change Password Modal ======= --}}
    <div x-show="showPwd" x-cloak class="fixed inset-0 z-50 flex items-center justify-center p-3 sm:p-4"
      @keydown.escape.window="showPwd=false">
      <div @click="showPwd=false" x-transition.opacity.duration.120ms class="absolute inset-0 bg-black/40"></div>

      <div @click.outside="showPwd=false" x-transition.scale.origin.center.duration.140ms
        class="relative w-full max-w-md card-soft rounded-2xl p-5 sm:p-6" role="dialog" aria-modal="true">
        <div class="text-center font-extrabold text-teal-700 text-xl mb-4 flex items-center justify-center gap-2">
          <svg class="w-5 h-5" viewBox="0 0 24 24" fill="currentColor">
            <path
              d="M12 1a5 5 0 0 0-5 5v3H5a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2h-2V6a5 5 0 0 0-5-5Zm-3 8V6a3 3 0 1 1 6 0v3H9Z" />
          </svg>
          Change Password
        </div>

        <form method="POST" action="{{ route('account.change-password') }}" class="space-y-3.5">
          @csrf
          <div class="relative">
            <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2">
              <svg class="w-5 h-5 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                <path
                  d="M12 1a5 5 0 0 0-5 5v3H5a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2h-2V6a5 5 0 0 0-5-5Z" />
              </svg>
            </span>
            <input name="old_password" type="password" placeholder="Old Password"
              class="w-full pl-11 pr-3 py-3 rounded-xl border border-slate-300 bg-slate-50 focus:outline-none focus:ring-2 focus:ring-emerald-200 focus:border-emerald-400"
              required>
          </div>
          <div class="relative">
            <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2">
              <svg class="w-5 h-5 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                <path d="M5 12h14v2H5zM5 8h14v2H5zM5 16h10v2H5z" />
              </svg>
            </span>
            <input name="password" type="password" placeholder="New Password"
              class="w-full pl-11 pr-3 py-3 rounded-xl border border-slate-300 bg-slate-50 focus:outline-none focus:ring-2 focus:ring-emerald-200 focus:border-emerald-400"
              required>
          </div>
          <div class="relative">
            <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2">
              <svg class="w-5 h-5 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                <path d="M9 12l2 2 4-4 1.5 1.5L11 16l-3.5-3.5z" />
              </svg>
            </span>
            <input name="password_confirmation" type="password" placeholder="Confirm Password"
              class="w-full pl-11 pr-3 py-3 rounded-xl border border-slate-300 bg-slate-50 focus:outline-none focus:ring-2 focus:ring-emerald-200 focus:border-emerald-400"
              required>
          </div>

          <div class="grid grid-cols-2 gap-2 pt-1.5">
            <button class="btn-cta teal w-full">Update Password</button>
            <button type="button" @click="showPwd=false"
              class="w-full border border-slate-300 bg-white rounded-xl font-semibold py-3">
              Cancel
            </button>
          </div>
        </form>
      </div>
    </div>

    {{-- ======= User Data Modal ======= --}}
    <div x-show="showUser" x-cloak class="fixed inset-0 z-50 flex items-center justify-center p-3 sm:p-4"
      @keydown.escape.window="showUser=false">
      <div @click="showUser=false" x-transition.opacity.duration.120ms class="absolute inset-0 bg-black/40"></div>

      <div @click.outside="showUser=false" x-transition.scale.origin.center.duration.140ms
        class="relative w-full max-w-sm card-soft rounded-2xl p-5 sm:p-6" role="dialog" aria-modal="true">
        <div class="flex items-center gap-3 mb-4">
          <img src="{{ $avatarUrl }}" alt="avatar" class="w-14 h-14 rounded-full ring-2 ring-white shadow" />
          <div class="min-w-0">
            <div class="text-slate-800 font-semibold truncate">{{ $user->name }}</div>
            <div class="text-slate-500 text-sm">{{ $user->role }}</div>
          </div>
        </div>
        <dl class="space-y-2 text-sm">
          <div class="flex justify-between">
            <dt class="text-slate-500">Phone</dt>
            <dd class="font-medium">{{ $phoneForView }}</dd>
          </div>
          <div class="flex justify-between">
            <dt class="text-slate-500">Email</dt>
            <dd class="font-medium break-all">{{ $user->email ?? '—' }}</dd>
          </div>
          <div class="flex justify-between">
            <dt class="text-slate-500">Balance</dt>
            <dd class="font-medium">{{ number_format($user->balance, 2) }}</dd>
          </div>
          <div class="flex justify-between">
            <dt class="text-slate-500">Role</dt>
            <dd class="font-medium capitalize">{{ $user->role }}</dd>
          </div>
        </dl>
        <div class="mt-5 text-right">
          <button @click="showUser=false"
            class="inline-flex items-center rounded-xl px-4 py-2 border border-slate-300 bg-white font-semibold hover:bg-slate-50">
            Close
          </button>
        </div>
      </div>
    </div>
  </div>

  {{-- Alpine.js --}}
  <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
@endsection
