@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-gear me-2"></i> Settings</h5>
  </div>

  @if(session('success'))
    <div class="alert alert-success card-edge p-2"><i class="fa-regular fa-circle-check me-1"></i>{{ session('success') }}</div>
  @endif

  {{-- Add new setting (POST -> admin.settings.store) --}}
  <div class="card-edge p-3 mb-3">
    <form class="row g-2 align-items-end" action="{{ route('admin.settings.store') }}" method="POST">
      @csrf
      <div class="col-md-3">
        <label class="form-label">Key *</label>
        <input name="key" class="form-control" placeholder="page.notice_bn" value="{{ old('key') }}" required>
      </div>
      <div class="col-md-7">
        <label class="form-label">Value</label>
        <input name="value" class="form-control" placeholder="আপনার বার্তা..." value="{{ old('value') }}">
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-primary"><i class="fa-solid fa-plus me-1"></i> Add</button>
      </div>
    </form>
    @error('key')<div class="text-danger small mt-1">{{ $message }}</div>@enderror
  </div>

  {{-- Bulk edit existing (PUT -> admin.settings.update) --}}
  <form id="bulk-update-form" class="card-edge p-0" action="{{ route('admin.settings.update') }}" method="POST">
    @csrf
    @method('PUT')

    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Key</th>
            <th>Value</th>
            <th class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
          @forelse($settings as $s)
          <tr>
            <td data-label="#" class="text-muted">{{ $s->id }}</td>
            <td data-label="Key" style="min-width:220px;">
              <input name="items[{{ $s->id }}][key]" class="form-control" value="{{ old('items.'.$s->id.'.key', $s->key) }}">
            </td>
            <td data-label="Value">
              <input name="items[{{ $s->id }}][value]" class="form-control" value="{{ old('items.'.$s->id.'.value', $s->value) }}">
            </td>
            <td data-label="Actions" class="text-end">
              {{-- No nested form! Use a button bound to a hidden form below --}}
              <button
                type="submit"
                form="delete-form-{{ $s->id }}"
                class="btn btn-danger btn-sm"
                onclick="return confirm('Delete this setting?')"
              >
                <i class="fa-regular fa-trash-can"></i> Delete
              </button>
            </td>
          </tr>
          @empty
            <tr><td colspan="4" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No settings</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>

    <div class="p-3 border-top d-flex justify-content-end">
      <button class="btn btn-success"><i class="fa-regular fa-circle-check me-1"></i> Save Changes</button>
    </div>
  </form>

  {{-- Hidden delete forms outside the bulk form to avoid nesting --}}
  @foreach($settings as $s)
    <form id="delete-form-{{ $s->id }}" action="{{ route('admin.settings.destroy', $s->id) }}" method="POST" class="d-none">
      @csrf
      @method('DELETE')
    </form>
  @endforeach

</div>
@endsection
