@extends('backend.master')
@section('content')
<div class="container py-3">
  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/payment-methods') }}" class="btn btn-light border">
      <i class="fa-solid fa-arrow-left"></i>
    </a>
    <h4 class="mb-0"><i class="fa-regular fa-credit-card me-2"></i>Payment Method Details</h4>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <div class="d-flex align-items-center gap-3">
        @if($pm->logo)
          <img src="{{ asset('storage/'.$pm->logo) }}" alt="" style="height:64px;width:64px;object-fit:cover;border-radius:12px;border:1px solid #eee;">
        @else
          <div class="p-3 rounded bg-light text-muted"><i class="fa-regular fa-image fa-2x"></i></div>
        @endif
        <div>
          <h5 class="mb-1">{{ $pm->name }}</h5>
          <span class="badge text-bg-light">Slug: {{ $pm->slug }}</span>
        </div>
      </div>

      <hr>

      <div class="row g-3">
        <div class="col-md-4">
          <div class="small text-muted mb-1"><i class="fa-solid fa-tag me-1"></i> Type</div>
          <div class="fw-semibold">{{ $pm->type }}</div>
        </div>
        <div class="col-md-4">
          <div class="small text-muted mb-1"><i class="fa-regular fa-id-card me-1"></i> Account No</div>
          <div class="fw-semibold">{{ $pm->account_no ?? '—' }}</div>
        </div>
        <div class="col-md-4">
          <div class="small text-muted mb-1"><i class="fa-solid fa-gauge-high me-1"></i> Daily Limits</div>
          <div class="fw-semibold">
            {{ $pm->daily_min !== null ? number_format($pm->daily_min) : '—' }}
            —
            {{ $pm->daily_max !== null ? number_format($pm->daily_max) : '—' }}
          </div>
        </div>
        <div class="col-md-4">
          <div class="small text-muted mb-1"><i class="fa-solid fa-toggle-on me-1"></i> Status</div>
          <div class="fw-semibold">{{ $pm->is_active ? 'Active' : 'Inactive' }}</div>
        </div>
        <div class="col-md-8">
          <div class="small text-muted mb-1"><i class="fa-regular fa-note-sticky me-1"></i> Meta</div>
          <pre class="mb-0 bg-light p-2 rounded" style="max-height:260px;overflow:auto;">{{ json_encode($pm->meta, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES) }}</pre>
        </div>
      </div>

      <div class="mt-3 d-flex gap-2">
        <a class="btn btn-outline-primary" href="{{ url('/payment-methods/'.$pm->id.'/edit') }}">
          <i class="fa-regular fa-pen-to-square me-1"></i> Edit
        </a>
        <form action="{{ url('/payment-methods/'.$pm->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
          @csrf @method('DELETE')
          <button class="btn btn-outline-danger">
            <i class="fa-regular fa-trash-can me-1"></i> Delete
          </button>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
