@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .pm-card{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px;width:56px;border-radius:12px;object-fit:cover;border:1px solid #e5e7eb }
    .btn-save{ background:#5b21b6; border-color:#5b21b6 }
    .btn-save:hover{ background:#4c1d95; border-color:#4c1d95 }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/payment-methods') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit: {{ $pm->name }}</h5>
  </div>

  <form action="{{ url('/admin/payment-methods/'.$pm->id) }}" method="POST" enctype="multipart/form-data" class="pm-card p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    {{-- Basics --}}
    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input type="text" name="name" class="form-control" value="{{ old('name', $pm->name) }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Slug <span class="text-muted">(auto if empty)</span></label>
        <input type="text" name="slug" class="form-control" value="{{ old('slug', $pm->slug) }}">
      </div>
      <div class="col-md-6">
        <label class="form-label">Type *</label>
        <input type="text" name="type" class="form-control" value="{{ old('type', $pm->type) }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Account No</label>
        <input type="text" name="account_no" class="form-control" value="{{ old('account_no', $pm->account_no) }}">
      </div>
    </div>

    {{-- Limits & Status --}}
    <div class="section-title mb-2"><i class="fa-solid fa-gauge-high me-1"></i> Limits & Status</div>
    <div class="row g-3 mb-3">
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Daily Min</label>
        <input type="number" name="daily_min" class="form-control" min="0" value="{{ old('daily_min', $pm->daily_min) }}">
      </div>
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Daily Max</label>
        <input type="number" name="daily_max" class="form-control" min="0" value="{{ old('daily_max', $pm->daily_max) }}">
      </div>
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Active</label>
        <select name="is_active" class="form-select">
          <option value="1" @selected(old('is_active', $pm->is_active)==1)>Active</option>
          <option value="0" @selected(old('is_active', $pm->is_active)==0)>Inactive</option>
        </select>
      </div>
    </div>

    {{-- Branding --}}
    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Branding</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Logo (image)</label>
        <input type="file" id="logoInput" name="logo" class="form-control" accept="image/*">
        <div class="d-flex align-items-center gap-3 mt-2">
          @if($pm->logo)
            <img id="logoPreview" class="logo-preview" src="{{ asset('storage/'.$pm->logo) }}" alt="current">
          @else
            <img id="logoPreview" class="logo-preview d-none" src="#" alt="preview">
          @endif
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remove_logo" value="1" id="removeLogo">
            <label class="form-check-label" for="removeLogo">Remove current logo</label>
          </div>
        </div>
      </div>
    </div>

    {{-- Meta --}}
    <div class="section-title mb-2"><i class="fa-regular fa-note-sticky me-1"></i> Meta (JSON)</div>
    <div class="mb-3">
      <textarea name="meta" rows="4" class="form-control">{{ old('meta', $pm->meta ? json_encode($pm->meta, JSON_UNESCAPED_SLASHES) : '') }}</textarea>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-save text-white btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/payment-methods') }}">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('logoInput')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('logoPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
@endsection
