@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .pm-card{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155; letter-spacing:.2px }
    .hint{ font-size:.8rem; color:#64748b }
    .logo-preview{ height:56px;width:56px;border-radius:12px;object-fit:cover;border:1px solid #e5e7eb }
    .btn-save{ background:#5b21b6; border-color:#5b21b6 }
    .btn-save:hover{ background:#4c1d95; border-color:#4c1d95 }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/payment-methods') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-solid fa-plus me-2"></i>Create Payment Method</h5>
  </div>

  <form action="{{ url('/admin/payment-methods') }}" method="POST" enctype="multipart/form-data" class="pm-card p-3">
    @csrf

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    {{-- Section: Basics --}}
    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Slug <span class="hint">(auto if empty)</span></label>
        <input type="text" name="slug" class="form-control" value="{{ old('slug') }}" placeholder="bkash-personal">
      </div>
      <div class="col-md-6">
        <label class="form-label">Type *</label>
        <input type="text" name="type" class="form-control" value="{{ old('type','mobile_wallet') }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Account No</label>
        <input type="text" name="account_no" class="form-control" value="{{ old('account_no') }}">
      </div>
    </div>

    {{-- Section: Limits & Status --}}
    <div class="section-title mb-2"><i class="fa-solid fa-gauge-high me-1"></i> Limits & Status</div>
    <div class="row g-3 mb-3">
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Daily Min</label>
        <input type="number" name="daily_min" class="form-control" value="{{ old('daily_min') }}" min="0">
      </div>
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Daily Max</label>
        <input type="number" name="daily_max" class="form-control" value="{{ old('daily_max') }}" min="0">
      </div>
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Active</label>
        <select name="is_active" class="form-select">
          <option value="1" @selected(old('is_active',1)==1)>Active</option>
          <option value="0" @selected(old('is_active',1)==0)>Inactive</option>
        </select>
      </div>
    </div>

    {{-- Section: Branding --}}
    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Branding</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Logo (image)</label>
        <input type="file" id="logoInput" name="logo" class="form-control" accept="image/*">
        <div class="mt-2 d-none" id="previewWrap">
          <img id="logoPreview" class="logo-preview" src="#" alt="preview">
        </div>
        <div class="hint mt-1">Recommended: square 256×256 PNG/JPG</div>
      </div>
    </div>

    {{-- Section: Meta --}}
    <div class="section-title mb-2"><i class="fa-regular fa-note-sticky me-1"></i> Meta (JSON)</div>
    <div class="mb-3">
      <textarea name="meta" rows="4" class="form-control" placeholder='{"fee":"1.5%","note":"limit…"}'>{{ old('meta') }}</textarea>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-save text-white btn-wide"><i class="fa-solid fa-floppy-disk me-1"></i> Save</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/payment-methods') }}">Cancel</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('logoInput')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('logoPreview');
    img.src = url; document.getElementById('previewWrap').classList.remove('d-none');
  });
</script>
@endsection
