@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .logo-64{ height:64px; width:64px; border-radius:14px; background:#fff; border:1px solid #e5e7eb; object-fit:contain; padding:6px }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/operators') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Operator Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="d-flex align-items-center gap-3">
      @if($operator->logo)
        <img class="logo-64" src="{{ asset('storage/'.$operator->logo) }}" alt="">
      @else
        <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>No logo</span>
      @endif

      <div>
        <h5 class="mb-1">{{ $operator->name }}</h5>
        <div class="d-flex flex-wrap gap-2">
          <span class="badge-soft gray">Code: {{ $operator->code }}</span>
          <span class="badge-soft {{ $operator->status==='active' ? 'green' : 'red' }}">
            <i class="fa-solid {{ $operator->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>
            {{ ucfirst($operator->status) }}
          </span>
          <span class="badge-soft gray">Sort: {{ $operator->sort_order }}</span>
        </div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/operators/'.$operator->id.'/edit') }}"><i class="fa-regular fa-pen-to-square me-1"></i> Edit</a>
      <form action="{{ url('/admin/operators/'.$operator->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
