@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .logo-42{ height:42px; width:42px; border-radius:10px; background:#fff; border:1px solid #e5e7eb; object-fit:contain; padding:4px }
    .btn-create{ background:#5b21b6; border-color:#5b21b6 } .btn-create:hover{ background:#4c1d95; border-color:#4c1d95 }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-signal me-2"></i> Operators</h5>
    <a class="btn btn-create text-white" href="{{ url('/admin/operators/create') }}">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <form class="card-edge p-3 mb-3" method="GET" action="{{ url('/admin/operators') }}">
    <div class="row g-2">
      <div class="col-md-5">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="{{ request('q') }}" class="form-control" placeholder="Search name/code">
        </div>
      </div>
      <div class="col-md-3">
        <select name="status" class="form-select">
          <option value="">Any status</option>
          <option value="active"   @selected(request('status')==='active')>Active</option>
          <option value="inactive" @selected(request('status')==='inactive')>Inactive</option>
        </select>
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-outline-secondary">
          <i class="fa-solid fa-filter me-1"></i> Filter
        </button>
      </div>
    </div>
  </form>

  @if(session('success'))
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i>{{ session('success') }}
    </div>
  @endif

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Logo</th>
          <th>Name</th>
          <th>Code</th>
          <th>Sort</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        @forelse($operators as $op)
        <tr>
          <td data-label="#" class="text-muted">{{ $op->id }}</td>
          <td data-label="Logo">
            @if($op->logo)
              <img class="logo-42" src="{{ asset('storage/'.$op->logo) }}" alt="{{ $op->name }}">
            @else
              <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>None</span>
            @endif
          </td>
          <td data-label="Name" class="fw-semibold">
            <a class="text-decoration-none" href="{{ url('/admin/operators/'.$op->id) }}">
              <i class="fa-solid fa-tower-broadcast me-1 text-secondary"></i>{{ $op->name }}
            </a>
          </td>
          <td data-label="Code"><span class="badge-soft gray">{{ $op->code }}</span></td>
          <td data-label="Sort">{{ $op->sort_order }}</td>
          <td data-label="Status">
            <span class="badge-soft {{ $op->status==='active' ? 'green' : 'red' }}">
              <i class="fa-solid {{ $op->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>
              {{ ucfirst($op->status) }}
            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <form action="{{ url('/admin/operators/'.$op->id.'/toggle') }}" method="POST">
                @csrf @method('PATCH')
                <button class="btn btn-warning btn-sm">
                  <i class="fa-solid fa-arrows-rotate"></i> Toggle
                </button>
              </form>

              <a class="btn btn-primary btn-sm" href="{{ url('/admin/operators/'.$op->id.'/edit') }}">
                <i class="fa-regular fa-pen-to-square"></i> Edit
              </a>

              <form action="{{ url('/admin/operators/'.$op->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
                @csrf @method('DELETE')
                <button class="btn btn-danger btn-sm">
                  <i class="fa-regular fa-trash-can"></i> Delete
                </button>
              </form>
            </div>
          </td>
        </tr>
        @empty
          <tr>
            <td colspan="7" class="text-center text-muted py-4">
              <i class="fa-regular fa-folder-open me-1"></i>No operators
            </td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div class="mt-3">{{ $operators->links() }}</div>
</div>
@endsection
