@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px; width:56px; border-radius:12px; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    .btn-save{ background:#5b21b6; border-color:#5b21b6 } .btn-save:hover{ background:#4c1d95; border-color:#4c1d95 }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/operators') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit: {{ $operator->name }}</h5>
  </div>

  <form action="{{ url('/admin/operators/'.$operator->id) }}" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="{{ old('name', $operator->name) }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Code (unique) *</label>
        <input name="code" class="form-control" value="{{ old('code', $operator->code) }}" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Status *</label>
        <select name="status" class="form-select" required>
          <option value="active"   @selected(old('status', $operator->status)==='active')>Active</option>
          <option value="inactive" @selected(old('status', $operator->status)==='inactive')>Inactive</option>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Sort Order</label>
        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', $operator->sort_order) }}" min="0">
      </div>
      <div class="col-md-4">
        <label class="form-label">Logo (image)</label>
        <input type="file" id="logoInput" name="logo" class="form-control" accept="image/*">
        <div class="d-flex align-items-center gap-3 mt-2">
          @if($operator->logo)
            <img id="logoPreview" class="logo-preview" src="{{ asset('storage/'.$operator->logo) }}" alt="current">
          @else
            <img id="logoPreview" class="logo-preview d-none" src="#" alt="preview">
          @endif
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remove_logo" value="1" id="removeLogo">
            <label class="form-check-label" for="removeLogo">Remove current logo</label>
          </div>
        </div>
        <div class="form-text">Recommended: 256×256 PNG/JPG/WebP/SVG</div>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-save text-white btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/operators') }}">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('logoInput')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('logoPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
@endsection
