@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .pm-card { border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray { background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red  { background:#fee2e2; color:#991b1b }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/offers') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Offer Details</h5>
  </div>

  <div class="pm-card p-3">
    <div class="d-flex flex-wrap align-items-center gap-2">
      <h5 class="mb-0">{{ $offer->title }}</h5>
      <span class="badge-soft gray"><i class="fa-solid fa-signal me-1"></i>{{ $offer->operator?->name }}</span>
      <span class="badge-soft {{ $offer->status==='active' ? 'green' : 'red' }}">
        <i class="fa-solid {{ $offer->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ ucfirst($offer->status) }}
      </span>
    </div>

    <hr>

    <div class="row g-3">
      <div class="col-md-4">
        <div class="text-muted small mb-1">Prices</div>
        <div class="fw-semibold">
          Regular: {{ number_format($offer->regular_price,2) }}<br>
          Sale: {{ number_format($offer->sale_price,2) }}
        </div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Data / Minutes</div>
        <div class="fw-semibold">{{ $offer->data_gb ?? 0 }} GB / {{ $offer->minutes ?? 0 }} Min</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Validity</div>
        <div class="fw-semibold">{{ $offer->validity_days ?? '—' }} days</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Sort Order</div>
        <div class="fw-semibold">{{ $offer->sort_order }}</div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/offers/'.$offer->id.'/edit') }}"><i class="fa-regular fa-pen-to-square me-1"></i> Edit</a>
      <form action="{{ url('/admin/offers/'.$offer->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
