@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .pm-card { border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    @media (max-width:576px){ .btn-wide{ width:100% } }
    .btn-save{ background:#5b21b6; border-color:#5b21b6 }
    .btn-save:hover{ background:#4c1d95; border-color:#4c1d95 }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/offers') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-solid fa-plus me-2"></i>Create Offer</h5>
  </div>

  <form action="{{ url('/admin/offers') }}" method="POST" class="pm-card p-3">
    @csrf

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    {{-- Basics --}}
    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Operator *</label>
        <select name="operator_id" class="form-select" required>
          <option value="">Select operator</option>
          @foreach($operators as $op)
            <option value="{{ $op->id }}" @selected(old('operator_id')==$op->id)>{{ $op->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Title *</label>
        <input name="title" class="form-control" value="{{ old('title') }}" required placeholder="50 GB + 700 Min">
      </div>
    </div>

    {{-- Pricing --}}
    <div class="section-title mb-2"><i class="fa-solid fa-tags me-1"></i> Pricing</div>
    <div class="row g-3 mb-3">
      <div class="col-md-4">
        <label class="form-label">Regular Price *</label>
        <input type="number" step="0.01" name="regular_price" class="form-control" value="{{ old('regular_price', 0) }}" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Sale Price *</label>
        <input type="number" step="0.01" name="sale_price" class="form-control" value="{{ old('sale_price', 0) }}" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Sort Order</label>
        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', 0) }}" min="0">
      </div>
    </div>

    {{-- Specs --}}
    <div class="section-title mb-2"><i class="fa-solid fa-sliders me-1"></i> Specs</div>
    <div class="row g-3 mb-3">
      <div class="col-md-4">
        <label class="form-label">Data (GB)</label>
        <input type="number" name="data_gb" class="form-control" value="{{ old('data_gb') }}" min="0">
      </div>
      <div class="col-md-4">
        <label class="form-label">Minutes</label>
        <input type="number" name="minutes" class="form-control" value="{{ old('minutes') }}" min="0">
      </div>
      <div class="col-md-4">
        <label class="form-label">Validity (days)</label>
        <input type="number" name="validity_days" class="form-control" value="{{ old('validity_days') }}" min="0">
      </div>
      <div class="col-md-4">
        <label class="form-label">Status *</label>
        <select name="status" class="form-select" required>
          <option value="active"   @selected(old('status','active')==='active')>Active</option>
          <option value="inactive" @selected(old('status')==='inactive')>Inactive</option>
        </select>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-save text-white btn-wide"><i class="fa-solid fa-floppy-disk me-1"></i> Save</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/offers') }}">Cancel</a>
    </div>
  </form>
</div>
@endsection
