@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef;border-radius:16px;background:#fff;box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .badge-soft.gray{ background:#f1f5f9;color:#334155;border-radius:999px;padding:.35rem .6rem;font-weight:600 }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/notices') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Notice Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="d-flex justify-content-between align-items-start">
      <div>
        <h5 class="mb-1">{{ $notice->title }}</h5>
        <div class="small text-muted">
          By <span class="badge-soft gray">{{ optional($notice->creator)->name ?? 'User #'.$notice->created_by }}</span>
          • {{ $notice->created_at->format('Y-m-d H:i') }}
        </div>
      </div>
      <div class="d-flex gap-2">
        <a class="btn btn-primary btn-sm" href="{{ url('/admin/notices/'.$notice->id.'/edit') }}"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
        <form action="{{ url('/admin/notices/'.$notice->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
          @csrf @method('DELETE')
          <button class="btn btn-outline-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
        </form>
      </div>
    </div>

    <hr>
    <div class="lh-base" style="white-space:pre-wrap">{{ $notice->body }}</div>
  </div>
</div>
@endsection
