@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef;border-radius:16px;background:#fff;box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700;color:#0f172a;border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft.gray{ background:#f1f5f9;color:#334155;border-radius:999px;padding:.35rem .6rem;font-weight:600 }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block;margin:12px 0;border:1px solid #e5e7eb;border-radius:12px;padding:10px }
      .table td{ display:flex;justify-content:space-between;border:0;padding:.45rem .6rem }
      .table td::before{ content: attr(data-label);font-weight:600;color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-regular fa-bell me-2"></i> Notices</h5>
    <a class="btn btn-primary" href="{{ url('/admin/notices/create') }}">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <form class="card-edge p-3 mb-3" method="GET" action="{{ url('/admin/notices') }}">
    <div class="row g-2">
      <div class="col-md-7">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="{{ request('q') }}" class="form-control" placeholder="Search title or body">
        </div>
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-outline-secondary"><i class="fa-solid fa-filter me-1"></i> Filter</button>
      </div>
    </div>
  </form>

  @if(session('success'))
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i>{{ session('success') }}
    </div>
  @endif

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Title</th>
          <th>Author</th>
          <th>Created</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        @forelse($notices as $n)
        <tr>
          <td data-label="#" class="text-muted">{{ $n->id }}</td>
          <td data-label="Title" class="fw-semibold">
            <a class="text-decoration-none" href="{{ url('/admin/notices/'.$n->id) }}">
              <i class="fa-regular fa-bell text-secondary me-1"></i>{{ $n->title }}
            </a>
            @if($n->body)
              <div class="small text-muted text-truncate" style="-webkit-line-clamp:1;display:-webkit-box;-webkit-box-orient:vertical;overflow:hidden;">
                {{ strip_tags($n->body) }}
              </div>
            @endif
          </td>
          <td data-label="Author">
            <span class="badge-soft gray">{{ optional($n->creator)->name ?? 'User #'.$n->created_by }}</span>
          </td>
          <td data-label="Created">{{ $n->created_at->format('Y-m-d H:i') }}</td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <a class="btn btn-outline-secondary btn-sm" href="{{ url('/admin/notices/'.$n->id) }}"><i class="fa-regular fa-eye"></i> View</a>
              <a class="btn btn-primary btn-sm" href="{{ url('/admin/notices/'.$n->id.'/edit') }}"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
              <form action="{{ url('/admin/notices/'.$n->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
                @csrf @method('DELETE')
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        @empty
          <tr><td colspan="5" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No notices</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div class="mt-3">{{ $notices->links() }}</div>
</div>
@endsection
