@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef;border-radius:16px;background:#fff;box-shadow:0 4px 18px rgba(17,24,39,.06) }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/notices') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-solid fa-plus me-2"></i>Create Notice</h5>
  </div>

  <form action="{{ url('/admin/notices') }}" method="POST" class="card-edge p-3">
    @csrf

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="mb-3">
      <label class="form-label">Title *</label>
      <input name="title" class="form-control" value="{{ old('title') }}" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Body</label>
      <textarea name="body" rows="6" class="form-control" placeholder="Notice details...">{{ old('body') }}</textarea>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-primary btn-wide"><i class="fa-solid fa-floppy-disk me-1"></i> Save</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/notices') }}">Cancel</a>
    </div>
  </form>
</div>
@endsection
