@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .logo-42{ height:42px; width:42px; border-radius:50%; border:1px solid #e5e7eb; object-fit:contain; background:#fff; padding:4px }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.45rem .6rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-signal me-2"></i> Mobile Gateways</h5>
    <a class="btn btn-primary" href="{{ url('/admin/mobile-gateways/create') }}">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <form class="card-edge p-3 mb-3" method="GET" action="{{ url('/admin/mobile-gateways') }}">
    <div class="row g-2">
      <div class="col-md-5">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="{{ request('q') }}" class="form-control" placeholder="Search name / code">
        </div>
      </div>
      <div class="col-md-3">
        <select name="active" class="form-select">
          <option value="">Any status</option>
          <option value="1" @selected(request('active')==='1')>Active</option>
          <option value="0" @selected(request('active')==='0')>Inactive</option>
        </select>
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-outline-secondary"><i class="fa-solid fa-filter me-1"></i> Filter</button>
      </div>
    </div>
  </form>

  @if(session('success'))
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i>{{ session('success') }}
    </div>
  @endif

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Logo</th>
          <th>Name</th>
          <th>Code</th>
          <th>Limits</th>
          <th>Fees</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        @forelse($gateways as $g)
        <tr>
          <td data-label="#" class="text-muted">{{ $g->id }}</td>
          <td data-label="Logo">
            @php
              $p = $g->logo_path;
              $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
              $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
            @endphp
            @if($isStored)
              <img class="logo-42" src="{{ asset('storage/'.$p) }}" alt="logo">
            @elseif($isUrl)
              <img class="logo-42" src="{{ $p }}" alt="logo">
            @elseif($p)
              <div class="logo-42 d-flex align-items-center justify-content-center" style="font-size:18px;border-style:dashed">{{ $p }}</div>
            @else
              <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>None</span>
            @endif
          </td>
          <td data-label="Name" class="fw-semibold">{{ $g->name }}</td>
          <td data-label="Code"><span class="badge-soft gray">{{ $g->code }}</span></td>
          <td data-label="Limits">৳{{ number_format($g->min_limit,2) }} — ৳{{ number_format($g->max_limit,2) }}</td>
          <td data-label="Fees">
            <div class="small text-muted">Flat: ৳{{ number_format($g->flat_fee,2) }}</div>
            <div class="small text-muted">%: {{ number_format($g->percent_fee,2) }}</div>
            <div class="small text-muted">Min/Max: ৳{{ number_format($g->min_commission,2) }} / ৳{{ number_format($g->max_commission,2) }}</div>
          </td>
          <td data-label="Status">
            <span class="badge-soft {{ $g->is_active ? 'green' : 'red' }}">
              <i class="fa-solid {{ $g->is_active ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ $g->is_active ? 'Active' : 'Inactive' }}
            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <form action="{{ url('/admin/mobile-gateways/'.$g->id.'/toggle') }}" method="POST">@csrf @method('PATCH')
                <button class="btn btn-warning btn-sm"><i class="fa-solid fa-arrows-rotate"></i> Toggle</button>
              </form>
              <a class="btn btn-primary btn-sm" href="{{ url('/admin/mobile-gateways/'.$g->id.'/edit') }}"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
              <a class="btn btn-outline-secondary btn-sm" href="{{ url('/admin/mobile-gateways/'.$g->id) }}"><i class="fa-regular fa-eye"></i> View</a>
              <form action="{{ url('/admin/mobile-gateways/'.$g->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
                @csrf @method('DELETE')
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        @empty
          <tr><td colspan="8" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No gateways</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div class="mt-3">{{ $gateways->links() }}</div>
</div>
@endsection
