@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px; width:56px; border-radius:50%; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/mobile-gateways') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit: {{ $gw->name }}</h5>
  </div>

  <form action="{{ url('/admin/mobile-gateways/'.$gw->id) }}" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="{{ old('name',$gw->name) }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Code (unique) *</label>
        <input name="code" class="form-control" value="{{ old('code',$gw->code) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Min Limit *</label>
        <input type="number" step="0.01" name="min_limit" class="form-control" value="{{ old('min_limit',$gw->min_limit) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Max Limit *</label>
        <input type="number" step="0.01" name="max_limit" class="form-control" value="{{ old('max_limit',$gw->max_limit) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Active *</label>
        <select name="is_active" class="form-select">
          <option value="1" @selected(old('is_active',$gw->is_active)==1)>Active</option>
          <option value="0" @selected(old('is_active',$gw->is_active)==0)>Inactive</option>
        </select>
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Logo</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Logo URL / Emoji / Text</label>
        <input name="logo_path" class="form-control" value="{{ old('logo_path',$gw->logo_path) }}" placeholder="https://... or ⚡">
        <div class="form-text">ফাইল দিলে এটি ইগনোর হবে।</div>
      </div>
      <div class="col-md-6">
        <label class="form-label">Upload Image</label>
        <input type="file" id="logoFile" name="logo_file" class="form-control" accept="image/*">
        <div class="d-flex align-items-center gap-3 mt-2">
          @php
            $p = $gw->logo_path;
            $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
            $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
          @endphp
          @if($isStored)
            <img id="logoPreview" class="logo-preview" src="{{ asset('storage/'.$p) }}" alt="current">
          @elseif($isUrl)
            <img id="logoPreview" class="logo-preview" src="{{ $p }}" alt="current">
          @else
            <img id="logoPreview" class="logo-preview d-none" src="#" alt="preview">
          @endif

          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remove_logo" value="1" id="removeLogo">
            <label class="form-check-label" for="removeLogo">Remove stored logo</label>
          </div>
        </div>
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-solid fa-chart-line me-1"></i> Fees & Commission</div>
    <div class="row g-3 mb-2">
      <div class="col-md-3">
        <label class="form-label">Flat Fee *</label>
        <input type="number" step="0.01" name="flat_fee" class="form-control" value="{{ old('flat_fee',$gw->flat_fee) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Percent Fee (%) *</label>
        <input type="number" step="0.01" name="percent_fee" class="form-control" value="{{ old('percent_fee',$gw->percent_fee) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Min Commission *</label>
        <input type="number" step="0.01" name="min_commission" class="form-control" value="{{ old('min_commission',$gw->min_commission) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Max Commission *</label>
        <input type="number" step="0.01" name="max_commission" class="form-control" value="{{ old('max_commission',$gw->max_commission) }}" required>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-primary btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/mobile-gateways') }}">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('logoFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('logoPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
@endsection
