@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .chip{ display:inline-flex; align-items:center; gap:6px; background:#f1f5f9; color:#334155; border-radius:999px; padding:.25rem .6rem; font-size:.8rem; margin:.1rem }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/loan-settings') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Loan Setting Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="row g-3">
      <div class="col-md-4">
        <div class="text-muted small mb-1">Interest Rate</div>
        <div class="fw-semibold">{{ number_format($row->interest_rate,2) }}%</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Eligibility Min Turnover</div>
        <div class="fw-semibold">৳{{ number_format($row->eligibility_min_turnover,2) }}</div>
      </div>
      <div class="col-md-12">
        <div class="text-muted small mb-1">Loan Options</div>
        <div>
          @forelse(($row->loan_options ?? []) as $opt)
            <span class="chip">৳{{ number_format($opt,0) }}</span>
          @empty
            <span class="text-muted">—</span>
          @endforelse
        </div>
      </div>
      <div class="col-md-12">
        <div class="text-muted small mb-1">Loan Periods (months)</div>
        <div>
          @forelse(($row->loan_periods ?? []) as $m)
            <span class="chip">{{ $m }}m</span>
          @empty
            <span class="text-muted">—</span>
          @endforelse
        </div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/loan-settings/'.$row->id.'/edit') }}">
        <i class="fa-regular fa-pen-to-square me-1"></i> Edit
      </a>
      <form action="{{ url('/admin/loan-settings/'.$row->id) }}" method="POST" onsubmit="return confirm('Delete this setting?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
