@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .chip{ display:inline-flex; align-items:center; gap:6px; background:#f1f5f9; color:#334155; border-radius:999px; padding:.25rem .6rem; font-size:.8rem; margin:.1rem }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-sack-dollar me-2"></i> Loan Settings</h5>
    <a class="btn btn-primary" href="{{ url('/admin/loan-settings/create') }}">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  @if(session('success'))
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i>{{ session('success') }}
    </div>
  @endif

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Interest Rate (%)</th>
          <th>Min Turnover</th>
          <th>Loan Options</th>
          <th>Periods (months)</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        @forelse($settings as $s)
        <tr>
          <td data-label="#" class="text-muted">{{ $s->id }}</td>
          <td data-label="Interest Rate" class="fw-semibold">{{ number_format($s->interest_rate,2) }}</td>
          <td data-label="Min Turnover">৳{{ number_format($s->eligibility_min_turnover,2) }}</td>
          <td data-label="Loan Options" style="max-width:300px">
            @forelse(($s->loan_options ?? []) as $opt)
              <span class="chip">৳{{ number_format($opt,0) }}</span>
            @empty — @endforelse
          </td>
          <td data-label="Periods" style="max-width:220px">
            @forelse(($s->loan_periods ?? []) as $m)
              <span class="chip">{{ $m }}m</span>
            @empty — @endforelse
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <a class="btn btn-primary btn-sm" href="{{ url('/admin/loan-settings/'.$s->id.'/edit') }}">
                <i class="fa-regular fa-pen-to-square"></i> Edit
              </a>
              <a class="btn btn-outline-secondary btn-sm" href="{{ url('/admin/loan-settings/'.$s->id) }}">
                <i class="fa-regular fa-eye"></i> View
              </a>
              <form action="{{ url('/admin/loan-settings/'.$s->id) }}" method="POST" onsubmit="return confirm('Delete this setting?')">
                @csrf @method('DELETE')
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        @empty
          <tr><td colspan="6" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No loan settings</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div class="mt-3">{{ $settings->links() }}</div>
</div>
@endsection
