@extends('backend.master')
@section('content')
@php
  $optCsv = $row->loan_options ? implode(',', $row->loan_options) : '';
  $perCsv = $row->loan_periods ? implode(',', $row->loan_periods) : '';
@endphp
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/loan-settings') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit Loan Setting</h5>
  </div>

  <form action="{{ url('/admin/loan-settings/'.$row->id) }}" method="POST" class="card-edge p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Interest Rate (%) *</label>
        <input type="number" step="0.01" name="interest_rate" class="form-control" value="{{ old('interest_rate',$row->interest_rate) }}" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Eligibility Min Turnover (৳) *</label>
        <input type="number" step="0.01" name="eligibility_min_turnover" class="form-control" value="{{ old('eligibility_min_turnover',$row->eligibility_min_turnover) }}" required>
      </div>
      <div class="col-md-12">
        <label class="form-label">Loan Options (comma separated)</label>
        <input name="loan_options" class="form-control" value="{{ old('loan_options',$optCsv) }}">
      </div>
      <div class="col-md-12">
        <label class="form-label">Loan Periods in Months (comma separated)</label>
        <input name="loan_periods" class="form-control" value="{{ old('loan_periods',$perCsv) }}">
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap mt-3">
      <button class="btn btn-primary btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/loan-settings') }}">Back</a>
    </div>
  </form>
</div>
@endsection
