@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .flag-56{ height:56px; width:56px; border-radius:50%; border:1px solid #e5e7eb; background:#fff; object-fit:contain; padding:6px }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .color-dot{ width:18px; height:18px; border-radius:50%; border:1px solid #e5e7eb; display:inline-block; vertical-align:middle }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/exchange-countries') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Country Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="d-flex align-items-center gap-3">
      @php
        $p = $row->flag_path;
        $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
        $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
      @endphp
      @if($isStored)
        <img class="flag-56" src="{{ asset('storage/'.$p) }}" alt="">
      @elseif($isUrl)
        <img class="flag-56" src="{{ $p }}" alt="">
      @elseif($p)
        <div class="flag-56 d-flex align-items-center justify-content-center" style="font-size:22px;border-style:dashed">{{ $p }}</div>
      @else
        <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>No flag</span>
      @endif

      <div>
        <h5 class="mb-1">{{ $row->name }}</h5>
        <div class="d-flex flex-wrap gap-2">
          <span class="badge-soft gray">Slug: {{ $row->slug }}</span>
          <span class="badge-soft gray">Currency: {{ $row->currency_name }}</span>
          <span class="badge-soft {{ $row->is_active ? 'green' : 'red' }}">
            <i class="fa-solid {{ $row->is_active ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ $row->is_active ? 'Active' : 'Inactive' }}
          </span>
        </div>
      </div>
    </div>

    <hr>

    <div class="row g-3">
      <div class="col-md-3"><div class="text-muted small mb-1">Unit</div><div class="fw-semibold">{{ $row->unit_label ?: '1' }}</div></div>
      <div class="col-md-3"><div class="text-muted small mb-1">Rate (BDT)</div><div class="fw-semibold">৳{{ number_format($row->rate_bdt,2) }}</div></div>
      <div class="col-md-3"><div class="text-muted small mb-1">Position</div><div class="fw-semibold">{{ $row->position }}</div></div>
      <div class="col-md-3">
        <div class="text-muted small mb-1">Header BG</div>
        @if($row->header_bg)
          <span class="color-dot" style="background: {{ $row->header_bg }}"></span>
          <span class="small text-muted ms-1">{{ $row->header_bg }}</span>
        @else
          <span class="text-muted">—</span>
        @endif
      </div>

      <div class="col-md-6">
        <div class="text-muted small mb-1">Share Title (BN)</div>
        <div class="fw-semibold">{{ $row->share_title_bn ?? '—' }}</div>
      </div>
      <div class="col-md-6">
        <div class="text-muted small mb-1">Share Title (EN)</div>
        <div class="fw-semibold">{{ $row->share_title_en ?? '—' }}</div>
      </div>

      <div class="col-md-6">
        <div class="text-muted small mb-1">Share Desc (BN)</div>
        <pre class="bg-light p-2 rounded" style="max-height:220px;overflow:auto">{{ $row->share_desc_bn }}</pre>
      </div>
      <div class="col-md-6">
        <div class="text-muted small mb-1">Share Desc (EN)</div>
        <pre class="bg-light p-2 rounded" style="max-height:220px;overflow:auto">{{ $row->share_desc_en }}</pre>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/exchange-countries/'.$row->id.'/edit') }}">
        <i class="fa-regular fa-pen-to-square me-1"></i> Edit
      </a>
      <form action="{{ url('/admin/exchange-countries/'.$row->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
