@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .flag-preview{ height:56px; width:56px; border-radius:50%; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/exchange-countries') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit: {{ $row->name }}</h5>
  </div>

  <form action="{{ url('/admin/exchange-countries/'.$row->id) }}" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="{{ old('name',$row->name) }}" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Slug (optional)</label>
        <input name="slug" class="form-control" value="{{ old('slug',$row->slug) }}" placeholder="auto if empty">
      </div>
      <div class="col-md-4">
        <label class="form-label">Currency Name *</label>
        <input name="currency_name" class="form-control" value="{{ old('currency_name',$row->currency_name) }}" required>
      </div>

      <div class="col-md-3">
        <label class="form-label">Unit Label</label>
        <input name="unit_label" class="form-control" value="{{ old('unit_label',$row->unit_label) }}">
      </div>
      <div class="col-md-3">
        <label class="form-label">Rate (BDT) *</label>
        <input type="number" step="0.01" name="rate_bdt" class="form-control" value="{{ old('rate_bdt',$row->rate_bdt) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Position</label>
        <input type="number" name="position" class="form-control" value="{{ old('position',$row->position) }}" min="0">
      </div>
      <div class="col-md-3">
        <label class="form-label">Active *</label>
        <select name="is_active" class="form-select">
          <option value="1" @selected(old('is_active',$row->is_active)==1)>Active</option>
          <option value="0" @selected(old('is_active',$row->is_active)==0)>Inactive</option>
        </select>
      </div>

      {{-- <div class="col-md-6">
        <label class="form-label">Flag URL / Emoji / Text</label>
        <input name="flag_path" class="form-control" value="{{ old('flag_path',$row->flag_path) }}" placeholder="https://... or 🇶🇦">
        <div class="form-text">ফাইল দিলে এটি ইগনোর হবে।</div>
      </div> --}}
      <div class="col-md-12">
        <label class="form-label">Upload Flag</label>
        <input type="file" id="flagFile" name="flag_file" class="form-control" accept="image/*">
        <div class="d-flex align-items-center gap-3 mt-2">
          @php
            $p = $row->flag_path;
            $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
            $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
          @endphp
          @if($isStored)
            <img id="flagPreview" class="flag-preview" src="{{ asset('storage/'.$p) }}" alt="current">
          @elseif($isUrl)
            <img id="flagPreview" class="flag-preview" src="{{ $p }}" alt="current">
          @else
            <img id="flagPreview" class="flag-preview d-none" src="#" alt="preview">
          @endif

          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remove_flag" value="1" id="removeFlag">
            <label class="form-check-label" for="removeFlag">Remove stored flag</label>
          </div>
        </div>
      </div>

      <div class="col-md-4">
        <label class="form-label">Header BG (color/gradient)</label>
        <input name="header_bg" class="form-control" value="{{ old('header_bg',$row->header_bg) }}" placeholder="#4C0519">
      </div>

      <div class="col-md-4">
        <label class="form-label">Share Title (BN)</label>
        <input name="share_title_bn" class="form-control" value="{{ old('share_title_bn',$row->share_title_bn) }}">
      </div>
      <div class="col-md-4">
        <label class="form-label">Share Title (EN)</label>
        <input name="share_title_en" class="form-control" value="{{ old('share_title_en',$row->share_title_en) }}">
      </div>

      <div class="col-md-6">
        <label class="form-label">Share Description (BN)</label>
        <textarea name="share_desc_bn" rows="3" class="form-control">{{ old('share_desc_bn',$row->share_desc_bn) }}</textarea>
      </div>
      <div class="col-md-6">
        <label class="form-label">Share Description (EN)</label>
        <textarea name="share_desc_en" rows="3" class="form-control">{{ old('share_desc_en',$row->share_desc_en) }}</textarea>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap mt-3">
      <button class="btn btn-primary btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/exchange-countries') }}">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('flagFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('flagPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
@endsection
