@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/deposit-packages') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Package Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="d-flex flex-wrap align-items-center gap-2">
      <h5 class="mb-0">{{ $package->title }}</h5>
      @if($package->badge_text)
        <span class="badge-soft gray">{{ $package->badge_text }}</span>
      @endif
      <span class="badge-soft {{ $package->status==='active' ? 'green' : 'red' }}">
        <i class="fa-solid {{ $package->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ ucfirst($package->status) }}
      </span>
    </div>

    <hr>

    <div class="row g-3">
      <div class="col-md-4">
        <div class="text-muted small mb-1">Principal Amount</div>
        <div class="fw-semibold">{{ number_format($package->principal_amount,2) }}</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Bonus Percent</div>
        <div class="fw-semibold">{{ number_format($package->bonus_percent,2) }}%</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Sort Order</div>
        <div class="fw-semibold">{{ $package->sort_order }}</div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/deposit-packages/'.$package->id.'/edit') }}"><i class="fa-regular fa-pen-to-square me-1"></i> Edit</a>
      <form action="{{ url('/admin/deposit-packages/'.$package->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
