{{-- resources/views/backend/partials/sidebar.blade.php --}}
@php
  /**
   * Return true if current request path matches any of the given patterns.
   * Usage: isActive(['admin/users*','admin/roles*'])
   */
  function isActive($patterns): bool
  {
    foreach ((array) $patterns as $p) {
      if (request()->is($p))
        return true;
    }
    return false;
  }
@endphp

<style>
  .sidebar_logo_ad {
    height: 100px;
    width: 100px !important;
    border-radius: 50%;
    margin: -14px 10px -20px 46px;
    box-shadow: rgba(50, 50, 93, .25) 0 50px 100px -20px, rgba(0, 0, 0, .3) 0 30px 60px -30px;
    border: 2px solid #64C5B1;
    object-fit: cover;
  }

  @media (max-width:768px) {
    .sidebar_logo_ad {
      height: 105px !important;
      width: 105px !important;
      border-radius: 50% !important;
      box-shadow: rgba(50, 50, 93, .25) 0 50px 100px -20px, rgba(0, 0, 0, .3) 0 30px 60px -30px;
      margin-left: 6px !important;
      margin-bottom: -30px !important;
      margin-top: -40px !important;
    }
  }

  .icon_menu i {
    font-size: 18px;
    color: #334155;
  }

  #sidebar_menu>li>a {
    display: flex;
    align-items: center;
    gap: 10px;
  }

  #sidebar_menu ul li a {
    padding-left: 42px;
  }

  /* Active visuals */
  #sidebar_menu li.mm-active>a span,
  #sidebar_menu li a.active span {
    font-weight: 700;
  }

  #sidebar_menu li a.active,
  #sidebar_menu li.mm-active>a {
    color: #111827;
  }

  #sidebar_menu li a.active {
    position: relative;
  }

  #sidebar_menu li a.active::after {
    content: "";
    position: absolute;
    right: 16px;
    top: 50%;
    width: 6px;
    height: 6px;
    transform: translateY(-50%);
    border-radius: 50%;
    background: #10b981;
  }
</style>







<nav class="sidebar vertical-scroll ps-container ps-theme-default ps-active-y">
  <div class="logo d-flex justify-content-between">
    <a href="{{ url('/admin/dashboard') }}">
      @php $companySetup = \App\Models\CompanySetup::first(); @endphp
      <img class="sidebar_logo_ad"
        src="{{ $companySetup?->logo ? asset('storage/' . $companySetup->logo) : asset('images/default-logo.png') }}"
        alt="Logo">
    </a>
    <div class="sidebar_close_icon d-lg-none">
      {{-- Themify এর ti-close বাদ দিয়ে Font Awesome ব্যবহার --}}
      <i class="fa-solid fa-xmark"></i>
    </div>
  </div>

  <ul id="sidebar_menu">
    {{-- Dashboard --}}
    <li class="{{ request()->is('admin/dashboard') ? 'mm-active' : '' }}">
      <a href="{{ url('/admin/dashboard') }}" class="{{ request()->is('admin/dashboard') ? 'active' : '' }}"
        aria-current="{{ request()->is('admin/dashboard') ? 'page' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-gauge"></i></div>
        <span>Dashboard</span>
      </a>
    </li>

    {{-- All History --}}
    @php
      $allManagerOpen = isActive([
        'admin/deposits*',
        'add-money*',
        'admin/transfers*',
        'admin/purchases*',
        'admin/recharges*',
        'admin/reward-conversions*',
        'admin/bill-payments*',
        'admin/loans*',
        'admin/mobile-transactions*',
        'admin/bank-transfers*',
        'admin/contact-inbox*'
      ]);
    @endphp

    <li class="{{ $allManagerOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $allManagerOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-clock-rotate-left"></i></div>
        <span>All History</span>
      </a>

      <ul class="{{ $allManagerOpen ? 'mm-show' : '' }}">

        {{-- Mobile Deposits --}}
        <li>
          <a href="{{ url('/admin/deposits') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/deposits*') ? 'active' : '' }}">
            <span>Mobile Deposits</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-emerald-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\Deposit::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Bank Deposits --}}
        <li>
          <a href="{{ url('/admin/bank-deposits') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/bank-deposits*') ? 'active' : '' }}">
            <span>Bank Deposits</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-sky-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\AddmoneyBank::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Card Deposits --}}
        <li>
          <a href="{{ url('/admin/card-deposits') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/card-deposits*') ? 'active' : '' }}">
            <span>Card Deposits</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-fuchsia-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\AddMoneyCardSubmit::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Send Money --}}
        <li>
          <a href="{{ url('/admin/transfers') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/transfers*') ? 'active' : '' }}">
            <span>Send Money Req.</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-amber-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\Transfer::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Offer Purchases --}}
        <li>
          <a href="{{ url('/admin/purchases') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/purchases*') ? 'active' : '' }}">
            <span>Offer Purchases</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-rose-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\Purchase::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Mobile Recharges --}}
        <li>
          <a href="{{ url('/admin/recharges') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/recharges*') ? 'active' : '' }}">
            <span>Mobile Recharges</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-indigo-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\Recharge::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Reward Conversions --}}
        <li>
          <a href="{{ url('/admin/reward-conversions') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/reward-conversions*') ? 'active' : '' }}">
            <span>Reward Conversions</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-teal-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\RewardConversion::count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Bill Payments --}}
        <li>
          <a href="{{ url('/admin/bill-payments') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/bill-payments*') ? 'active' : '' }}">
            <span>Bill Payments</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-lime-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\BillPayment::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Loans --}}
        <li>
          <a href="{{ url('/admin/loans') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/loans*') ? 'active' : '' }}">
            <span>Loan Requests</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-orange-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\LoanApplication::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Mobile Banking Transfers --}}
        <li>
          <a href="{{ url('/admin/mobile-transactions') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/mobile-transactions*') ? 'active' : '' }}">
            <span>Mobile Transfers</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-cyan-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\MobileTransaction::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

        {{-- Bank Transfers --}}
        <li>
          <a href="{{ url('/admin/bank-transfers') }}"
            class="flex items-center justify-between gap-2 text-[13px] {{ request()->is('admin/bank-transfers*') ? 'active' : '' }}">
            <span>Bank Transfers</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-pink-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              {{ App\Models\BankTransfer::where('status', 'pending')->count() ?? 0 }}
            </span>
          </a>
        </li>

      </ul>
    </li>



    {{-- Balance Adjust --}}
    @php $pmOpen = isActive(['admin/users/balance*']); @endphp
    <li class="{{ $pmOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $pmOpen ? 'true' : 'false' }}">
        <div class="icon_menu">
          <i class="fa-solid fa-scale-balanced"></i>
        </div>
        <span>Balance Adjust</span>
      </a>
      <ul class="{{ $pmOpen ? 'mm-show' : '' }}">
        <li>
          <a href="{{ url('/admin/users/balance') }}"
            class="{{ request()->is('admin/users/balance') ? 'active' : '' }}">
            Balance Add/Return
          </a>
        </li>
      </ul>
    </li>


    {{-- Payment Methods --}}
    @php $pmOpen = isActive(['admin/payment-methods*']); @endphp
    <li class="{{ $pmOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $pmOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-credit-card"></i></div>
        <span>Pmt. Method</span>
      </a>
      <ul class="{{ $pmOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/payment-methods') }}"
            class="{{ request()->is('admin/payment-methods') ? 'active' : '' }}">All Methods</a></li>
        <li><a href="{{ url('/admin/payment-methods/create') }}"
            class="{{ request()->is('admin/payment-methods/create') ? 'active' : '' }}">Add Method</a></li>
        <li><a href="{{ url('/bank-methods') }}"
            class="{{ request()->is('admin/payment-methods') ? 'active' : '' }}">bank List</a></li>
        <li><a href="{{ url('/bank-methods/create') }}"
            class="{{ request()->is('admin/payment-methods/create') ? 'active' : '' }}">Add bank</a></li>

        <li><a href="{{ url('/admin/add-money-cards') }}"
            class="{{ request()->is('admin/add-money-cards') ? 'active' : '' }}">Card List</a></li>
        <li><a href="{{ url('/admin/add-money-cards/create') }}"
            class="{{ request()->is('admin/add-money-cards/create') ? 'active' : '' }}">Add Card</a></li>
      </ul>
    </li>

    {{-- Operators --}}
    @php $opOpen = isActive(['admin/operators*']); @endphp
    <li class="{{ $opOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $opOpen ? 'true' : 'false' }}">
        {{-- sim-card ফ্রি না হলে বিকল্প হিসেবে fa-tower-broadcast ব্যবহার করুন --}}
        <div class="icon_menu"><i class="fa-solid fa-sim-card"></i></div>
        <span>Operators</span>
      </a>
      <ul class="{{ $opOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/operators') }}" class="{{ request()->is('admin/operators') ? 'active' : '' }}">All
            Operators</a></li>
        <li><a href="{{ url('/admin/operators/create') }}"
            class="{{ request()->is('admin/operators/create') ? 'active' : '' }}">Add Operator</a></li>
      </ul>
    </li>

    @php $opOpen = isActive(['admin/offers*']); @endphp
    <li class="{{ $opOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $opOpen ? 'true' : 'false' }}">
        {{-- sim-card ফ্রি না হলে বিকল্প হিসেবে fa-tower-broadcast ব্যবহার করুন --}}
        <div class="icon_menu"><i class="fa-solid fa-sim-card"></i></div>
        <span>Drive Offer</span>
      </a>
      <ul class="{{ $opOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('admin/offers') }}" class="{{ request()->is('admin/offers') ? 'active' : '' }}">All Drive
            Offers</a></li>
        <li><a href="{{ url('admin/offers/create') }}"
            class="{{ request()->is('admin/offers/create') ? 'active' : '' }}">Add Drive Offer</a></li>
      </ul>
    </li>

    {{-- Promotions --}}
    @php $promoOpen = isActive(['admin/deposit-packages*', 'admin/settings']); @endphp
    <li class="{{ $promoOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $promoOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-tags"></i></div>
        <span>Promotions</span>
      </a>
      <ul class="{{ $promoOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/deposit-packages') }}"
            class="{{ request()->is('admin/deposit-packages') ? 'active' : '' }}">All Deals</a></li>
        <li><a href="{{ url('/admin/deposit-packages/create') }}"
            class="{{ request()->is('admin/deposit-packages/create') ? 'active' : '' }}">Add Deal</a></li>
        <li><a href="{{ url('/admin/settings') }}" class="{{ request()->is('admin/settings') ? 'active' : '' }}">Promo
            Settings</a></li>
      </ul>
    </li>

    {{-- Bill Category --}}
    @php $catOpen = isActive(['admin/biller-categories*']); @endphp
    <li class="{{ $catOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $catOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-layer-group"></i></div>
        <span>Bill Category</span>
      </a>
      <ul class="{{ $catOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/biller-categories') }}"
            class="{{ request()->is('admin/biller-categories') ? 'active' : '' }}">All Category</a></li>
        <li><a href="{{ url('/admin/biller-categories/create') }}"
            class="{{ request()->is('admin/biller-categories/create') ? 'active' : '' }}">Add Category</a></li>
      </ul>
    </li>

    {{-- Billers --}}
    @php $billersOpen = isActive(['admin/billers*']); @endphp
    <li class="{{ $billersOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $billersOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-file-invoice"></i></div>
        <span>Billers</span>
      </a>
      <ul class="{{ $billersOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/billers') }}" class="{{ request()->is('admin/billers') ? 'active' : '' }}">All
            Billers</a></li>
        <li><a href="{{ url('/admin/billers/create') }}"
            class="{{ request()->is('admin/billers/create') ? 'active' : '' }}">Add Biller</a></li>
      </ul>
    </li>

    {{-- Loan Config --}}
    @php $loanOpen = isActive(['admin/loan-settings*']); @endphp
    <li class="{{ $loanOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $loanOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-sliders"></i></div>
        <span>Loan Config</span>
      </a>
      <ul class="{{ $loanOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/loan-settings') }}"
            class="{{ request()->is('admin/loan-settings') ? 'active' : '' }}">All Settings</a></li>
        <li><a href="{{ url('/admin/loan-settings/create') }}"
            class="{{ request()->is('admin/loan-settings/create') ? 'active' : '' }}">Add Setting</a></li>
      </ul>
    </li>

    {{-- Mobile Banking --}}
    @php $mobOpen = isActive(['admin/mobile-gateways*']); @endphp
    <li class="{{ $mobOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $mobOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-mobile-screen-button"></i></div>
        <span>Mobile Banking</span>
      </a>
      <ul class="{{ $mobOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/mobile-gateways') }}"
            class="{{ request()->is('admin/mobile-gateways') ? 'active' : '' }}">All Method</a></li>
        <li><a href="{{ url('/admin/mobile-gateways/create') }}"
            class="{{ request()->is('admin/mobile-gateways/create') ? 'active' : '' }}">Add Methods</a></li>
      </ul>
    </li>

    {{-- Banks --}}
    @php $banksOpen = isActive(['admin/banks*']); @endphp
    <li class="{{ $banksOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $banksOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-building-columns"></i></div>
        <span>Bank Config</span>
      </a>
      <ul class="{{ $banksOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/banks') }}" class="{{ request()->is('admin/banks') ? 'active' : '' }}">All Banks</a>
        </li>
        <li><a href="{{ url('/admin/banks/create') }}"
            class="{{ request()->is('admin/banks/create') ? 'active' : '' }}">Add Bank</a></li>
      </ul>
    </li>

    {{-- FX Countries --}}
    @php $fxOpen = isActive(['admin/exchange-countries*']); @endphp
    <li class="{{ $fxOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $fxOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-globe"></i></div>
        <span>FX Country</span>
      </a>
      <ul class="{{ $fxOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/exchange-countries') }}"
            class="{{ request()->is('admin/exchange-countries') ? 'active' : '' }}">All Country</a></li>
        <li><a href="{{ url('/admin/exchange-countries/create') }}"
            class="{{ request()->is('admin/exchange-countries/create') ? 'active' : '' }}">Add Country</a></li>
      </ul>
    </li>

    {{-- Banners --}}
    @php $banOpen = isActive(['admin/banners*']); @endphp
    <li class="{{ $banOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $banOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-image"></i></div>
        <span>Banner Setup</span>
      </a>
      <ul class="{{ $banOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/banners') }}" class="{{ request()->is('admin/banners') ? 'active' : '' }}">All
            Banners</a></li>
        <li><a href="{{ url('/admin/banners/create') }}"
            class="{{ request()->is('admin/banners/create') ? 'active' : '' }}">Add Banner</a></li>
      </ul>
    </li>

    {{-- Notices --}}
    @php $notOpen = isActive(['admin/notices*']); @endphp
    <li class="{{ $notOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $notOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-bell"></i></div>
        <span>Notices</span>
      </a>
      <ul class="{{ $notOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/notices') }}" class="{{ request()->is('admin/notices') ? 'active' : '' }}">All
            Notices</a></li>
        <li><a href="{{ url('/admin/notices/create') }}"
            class="{{ request()->is('admin/notices/create') ? 'active' : '' }}">Add Notice</a></li>
      </ul>
    </li>

    {{-- Reward Settings --}}
    @php $rwOpen = isActive(['reward-settings*']); @endphp
    <li class="{{ $rwOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $rwOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-gift"></i></div>
        <span>Reward Settings</span>
      </a>
      <ul class="{{ $rwOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/reward-settings') }}"
            class="{{ request()->is('reward-settings') ? 'active' : '' }}">Reward Settings</a></li>
      </ul>
    </li>

    {{-- Messages --}}
    @php $msgOpen = isActive(['admin/contact-inbox*']); @endphp
    <li class="{{ $msgOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $msgOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-envelope"></i></div>
        <span>Messages</span>
      </a>
      <ul class="{{ $msgOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/contact-inbox') }}"
            class="{{ request()->is('admin/contact-inbox*') ? 'active' : '' }}">Manage Inbox</a></li>
      </ul>
    </li>

    {{-- Manage Users --}}
    @php $usersOpen = isActive(['admin/users*']); @endphp
    <li class="{{ $usersOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $usersOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-users"></i></div>
        <span>Manage Users</span>
      </a>
      <ul class="{{ $usersOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/admin/users') }}" class="{{ request()->is('admin/users*') ? 'active' : '' }}">All
            Users</a></li>
      </ul>
    </li>

    {{-- Company Setup --}}
    @php $companyOpen = isActive(['company-setups*']); @endphp
    <li class="{{ $companyOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $companyOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-building"></i></div>
        <span>Company Setup</span>
      </a>
      <ul class="{{ $companyOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/company-setups') }}" class="{{ request()->is('company-setups*') ? 'active' : '' }}">Manage
            Company</a></li>
      </ul>
    </li>

    {{-- Headline Setup --}}
    @php $headlineOpen = isActive(['headlines*']); @endphp
    <li class="{{ $headlineOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $headlineOpen ? 'true' : 'false' }}">
        <div class="icon_menu"><i class="fa-solid fa-heading"></i></div>
        <span>Headline Setup</span>
      </a>
      <ul class="{{ $headlineOpen ? 'mm-show' : '' }}">
        <li><a href="{{ url('/headlines') }}" class="{{ request()->is('headlines*') ? 'active' : '' }}">Manage
            Headline</a></li>
      </ul>
    </li>


    @php $headlineOpen = isActive(['admin/upload-apps*']); @endphp
    <li class="{{ $headlineOpen ? 'mm-active' : '' }}">
      <a class="has-arrow" href="#" aria-expanded="{{ $headlineOpen ? 'true' : 'false' }}">
        <div class="icon_menu">
          <i class="fa-solid fa-cloud-arrow-up"></i>
        </div>
        <span>Upload App</span>
      </a>
      <ul class="{{ $headlineOpen ? 'mm-show' : '' }}">
        <li>
          <a href="{{ url('admin/upload-apps') }}" class="{{ request()->is('admin/upload-apps*') ? 'active' : '' }}">
            Manage upload-apps
          </a>
        </li>
      </ul>
    </li>


    @php 
      $artisanActive = isActive(['storage-link*']); 
    @endphp

    <li class="nav-item {{ $artisanActive ? 'mm-active' : '' }}">
      <a class="has-arrow d-flex align-items-center" href="#" aria-expanded="{{ $artisanActive ? 'true' : 'false' }}">
        <div class="icon_menu me-2">
          <i class="fa-solid fa-terminal"></i>
        </div>
        <span>Artisan Call</span>
      </a>
      <ul class="nav flex-column {{ $artisanActive ? 'mm-show' : '' }}">
        <li>
          <a href="{{ url('/storage-link') }}" class="{{ request()->is('storage-link*') ? 'active' : '' }}">
            <i class="fa-solid fa-link me-1"></i> Storage Link
          </a>
        </li>
      </ul>
    </li>




  </ul>
</nav>