@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .logo-56{ height:56px; width:56px; border-radius:50%; background:#fff; border:1px solid #e5e7eb; object-fit:contain; padding:6px }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .badge-soft.blue{ background:#e0f2fe; color:#075985 }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/billers') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Biller Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="d-flex align-items-center gap-3">
      @php
        $logo = $biller->logo;
        $isStored = $logo && \Illuminate\Support\Facades\Storage::disk('public')->exists($logo);
        $isUrl = $logo && \Illuminate\Support\Str::startsWith($logo, ['http://','https://']);
      @endphp

      @if($isStored)
        <img class="logo-56" src="{{ asset('storage/'.$logo) }}" alt="">
      @elseif($isUrl)
        <img class="logo-56" src="{{ $logo }}" alt="">
      @elseif($logo)
        <div class="logo-56 d-flex align-items-center justify-content-center" style="font-size:22px;border-style:dashed">{{ $logo }}</div>
      @else
        <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>No logo</span>
      @endif

      <div>
        <h5 class="mb-1">{{ $biller->name }}</h5>
        <div class="d-flex flex-wrap gap-2">
          <span class="badge-soft gray">Code: {{ $biller->code }}</span>
          <span class="badge-soft gray">Category: {{ $biller->category?->name }}</span>
          @if($biller->type)
            <span class="badge-soft blue">{{ ucfirst($biller->type) }}</span>
          @endif
          <span class="badge-soft {{ $biller->status==='active' ? 'green' : 'red' }}">
            <i class="fa-solid {{ $biller->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ ucfirst($biller->status) }}
          </span>
        </div>
        @if($biller->provider)
          <div class="text-muted small mt-1">Provider: {{ $biller->provider }}</div>
        @endif
      </div>
    </div>

    <hr>

    <div class="row g-3">
      <div class="col-md-4">
        <div class="text-muted small mb-1">Min Amount</div>
        <div class="fw-semibold">{{ number_format($biller->min_amount,2) }}</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Max Amount</div>
        <div class="fw-semibold">{{ number_format($biller->max_amount,2) }}</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Sort Order</div>
        <div class="fw-semibold">{{ $biller->sort_order }}</div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/billers/'.$biller->id.'/edit') }}">
        <i class="fa-regular fa-pen-to-square me-1"></i> Edit
      </a>
      <form action="{{ url('/admin/billers/'.$biller->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
