@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .badge-soft.blue{ background:#e0f2fe; color:#075985 }
    .logo-42{ height:42px; width:42px; border-radius:50%; background:#fff; border:1px solid #e5e7eb; object-fit:contain; padding:4px }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-file-invoice-dollar me-2"></i> Billers</h5>
    <a class="btn btn-primary" href="{{ url('/admin/billers/create') }}">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <form class="card-edge p-3 mb-3" method="GET" action="{{ url('/admin/billers') }}">
    <div class="row g-2">
      <div class="col-md-4">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="{{ request('q') }}" class="form-control" placeholder="Search name / code / provider">
        </div>
      </div>
      <div class="col-md-3">
        <select name="category_id" class="form-select">
          <option value="">All categories</option>
          @foreach($categories as $cat)
            <option value="{{ $cat->id }}" @selected(request('category_id')==$cat->id)>{{ $cat->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-2">
        <select name="type" class="form-select">
          <option value="">Any type</option>
          <option value="prepaid"  @selected(request('type')==='prepaid')>Prepaid</option>
          <option value="postpaid" @selected(request('type')==='postpaid')>Postpaid</option>
        </select>
      </div>
      <div class="col-md-2">
        <select name="status" class="form-select">
          <option value="">Any status</option>
          <option value="active"   @selected(request('status')==='active')>Active</option>
          <option value="inactive" @selected(request('status')==='inactive')>Inactive</option>
        </select>
      </div>
      <div class="col-md-1 d-grid">
        <button class="btn btn-outline-secondary"><i class="fa-solid fa-filter me-1"></i> Go</button>
      </div>
    </div>
  </form>

  @if(session('success'))
    <div class="alert alert-success card-edge p-2"><i class="fa-regular fa-circle-check me-1"></i>{{ session('success') }}</div>
  @endif

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Logo</th>
          <th>Name</th>
          <th>Code</th>
          <th>Category</th>
          <th>Type</th>
          <th>Limits</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        @forelse($billers as $b)
        <tr>
          <td data-label="#" class="text-muted">{{ $b->id }}</td>
          <td data-label="Logo">
            @php
              $logo = $b->logo;
              $isStored = $logo && \Illuminate\Support\Facades\Storage::disk('public')->exists($logo);
              $isUrl = $logo && \Illuminate\Support\Str::startsWith($logo, ['http://','https://']);
            @endphp
            @if($isStored)
              <img class="logo-42" src="{{ asset('storage/'.$logo) }}" alt="logo">
            @elseif($isUrl)
              <img class="logo-42" src="{{ $logo }}" alt="logo">
            @elseif($logo)
              <div class="logo-42 d-flex align-items-center justify-content-center" style="font-size:18px;border-style:dashed">{{ $logo }}</div>
            @else
              <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>None</span>
            @endif
          </td>
          <td data-label="Name" class="fw-semibold">
            <a class="text-decoration-none" href="{{ url('/admin/billers/'.$b->id) }}">
              <i class="fa-solid fa-money-check-dollar text-secondary me-1"></i>{{ $b->name }}
            </a>
            @if($b->provider)
              <div class="small text-muted">{{ $b->provider }}</div>
            @endif
          </td>
          <td data-label="Code"><span class="badge-soft gray">{{ $b->code }}</span></td>
          <td data-label="Category">{{ $b->category?->name }}</td>
          <td data-label="Type">
            @if($b->type)
              <span class="badge-soft blue">{{ ucfirst($b->type) }}</span>
            @else
              —
            @endif
          </td>
          <td data-label="Limits">
            {{ number_format($b->min_amount,2) }} — {{ number_format($b->max_amount,2) }}
          </td>
          <td data-label="Status">
            <span class="badge-soft {{ $b->status==='active' ? 'green' : 'red' }}">
              <i class="fa-solid {{ $b->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ ucfirst($b->status) }}
            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <form action="{{ url('/admin/billers/'.$b->id.'/toggle') }}" method="POST">@csrf @method('PATCH')
                <button class="btn btn-warning btn-sm"><i class="fa-solid fa-arrows-rotate"></i> Toggle</button>
              </form>
              <a class="btn btn-primary btn-sm" href="{{ url('/admin/billers/'.$b->id.'/edit') }}"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
              <form action="{{ url('/admin/billers/'.$b->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
                @csrf @method('DELETE')
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        @empty
          <tr><td colspan="9" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No billers</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div class="mt-3">{{ $billers->links() }}</div>
</div>
@endsection
