@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px; width:56px; border-radius:50%; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/billers') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-solid fa-plus me-2"></i>Create Biller</h5>
  </div>

  <form action="{{ url('/admin/billers') }}" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    @csrf

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Category *</label>
        <select name="biller_category_id" class="form-select" required>
          <option value="">Select</option>
          @foreach($categories as $cat)
            <option value="{{ $cat->id }}" @selected(old('biller_category_id')==$cat->id)>{{ $cat->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="{{ old('name') }}" required placeholder="Palli Bidyut (Prepaid)">
      </div>
      <div class="col-md-6">
        <label class="form-label">Code (unique) *</label>
        <input name="code" class="form-control" value="{{ old('code') }}" required placeholder="BIDYUT_PREPAID">
      </div>
      <div class="col-md-3">
        <label class="form-label">Provider</label>
        <input name="provider" class="form-control" value="{{ old('provider') }}" placeholder="BIDYUT / Gas / Water">
      </div>
      <div class="col-md-3">
        <label class="form-label">Type</label>
        <select name="type" class="form-select">
          <option value="">—</option>
          <option value="prepaid"  @selected(old('type')==='prepaid')>Prepaid</option>
          <option value="postpaid" @selected(old('type')==='postpaid')>Postpaid</option>
        </select>
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Logo</div>
    <div class="row g-3 mb-3">
      {{-- <div class="col-md-6">
        <label class="form-label">Logo URL / Emoji / Text</label>
        <input name="logo" class="form-control" value="{{ old('logo') }}" placeholder="https://... or ⚡">
        <div class="form-text">ফাইল দিলে এটি ইগনোর হবে।</div>
      </div> --}}
      <div class="col-md-12">
        <label class="form-label">Upload Image</label>
        <input type="file" id="logoFile" name="logo_file" class="form-control" accept="image/*">
        <div class="mt-2 d-none" id="previewWrap">
          <img id="logoPreview" class="logo-preview" src="#" alt="preview">
        </div>
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-solid fa-scale-balanced me-1"></i> Limits & Status</div>
    <div class="row g-3 mb-3">
      <div class="col-md-3">
        <label class="form-label">Min Amount *</label>
        <input type="number" step="0.01" name="min_amount" class="form-control" value="{{ old('min_amount',10) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Max Amount *</label>
        <input type="number" step="0.01" name="max_amount" class="form-control" value="{{ old('max_amount',100000) }}" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Sort Order</label>
        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order',0) }}" min="0">
      </div>
      <div class="col-md-3">
        <label class="form-label">Status *</label>
        <select name="status" class="form-select" required>
          <option value="active"   @selected(old('status','active')==='active')>Active</option>
          <option value="inactive" @selected(old('status')==='inactive')>Inactive</option>
        </select>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-primary btn-wide"><i class="fa-solid fa-floppy-disk me-1"></i> Save</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/billers') }}">Cancel</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('logoFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('logoPreview');
    img.src = url; document.getElementById('previewWrap').classList.remove('d-none');
  });
</script>
@endsection
