@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .logo-56{ height:56px; width:56px; border-radius:12px; background:#fff; border:1px solid #e5e7eb; object-fit:contain; padding:6px }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/biller-categories') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Category Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="d-flex align-items-center gap-3">
      @php
        $icon = $cat->icon;
        $isStored = $icon && \Illuminate\Support\Facades\Storage::disk('public')->exists($icon);
        $isUrl = $icon && \Illuminate\Support\Str::startsWith($icon,['http://','https://']);
      @endphp

      @if($isStored)
        <img class="logo-56" src="{{ asset('storage/'.$icon) }}" alt="">
      @elseif($isUrl)
        <img class="logo-56" src="{{ $icon }}" alt="">
      @elseif($icon)
        <div class="logo-56 d-flex align-items-center justify-content-center" style="font-size:24px;border-style:dashed">
          {{ $icon }}
        </div>
      @else
        <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>No icon</span>
      @endif

      <div>
        <h5 class="mb-1">{{ $cat->name }}</h5>
        <div class="d-flex flex-wrap gap-2">
          <span class="badge-soft gray">Slug: {{ $cat->slug }}</span>
          <span class="badge-soft {{ $cat->status==='active' ? 'green' : 'red' }}">
            <i class="fa-solid {{ $cat->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ ucfirst($cat->status) }}
          </span>
          <span class="badge-soft gray">Sort: {{ $cat->sort_order }}</span>
        </div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/biller-categories/'.$cat->id.'/edit') }}">
        <i class="fa-regular fa-pen-to-square me-1"></i> Edit
      </a>
      <form action="{{ url('/admin/biller-categories/'.$cat->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
