@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px; width:56px; border-radius:12px; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/biller-categories') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit: {{ $cat->name }}</h5>
  </div>

  <form action="{{ url('/admin/biller-categories/'.$cat->id) }}" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="{{ old('name',$cat->name) }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Slug</label>
        <input name="slug" class="form-control" value="{{ old('slug',$cat->slug) }}" placeholder="auto from name if empty">
      </div>
      <div class="col-md-4">
        <label class="form-label">Status *</label>
        <select name="status" class="form-select" required>
          <option value="active"   @selected(old('status',$cat->status)==='active')>Active</option>
          <option value="inactive" @selected(old('status',$cat->status)==='inactive')>Inactive</option>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Sort Order</label>
        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order',$cat->sort_order) }}" min="0">
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Icon</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Icon Text / Emoji / Image URL</label>
        <input name="icon" class="form-control" value="{{ old('icon',$cat->icon) }}" placeholder="e.g. ⚡ or https://.../icon.png">
        <div class="form-text">ফাইল দিলে এটি ইগনোর হবে।</div>
      </div>
      <div class="col-md-6">
        <label class="form-label">Upload Image</label>
        <input type="file" id="iconFile" name="icon_file" class="form-control" accept="image/*">
        <div class="d-flex align-items-center gap-3 mt-2">
          @php
            $icon = $cat->icon;
            $isStored = $icon && \Illuminate\Support\Facades\Storage::disk('public')->exists($icon);
          @endphp
          @if($isStored)
            <img id="iconPreview" class="logo-preview" src="{{ asset('storage/'.$cat->icon) }}" alt="current">
          @elseif($icon && \Illuminate\Support\Str::startsWith($icon,['http://','https://']))
            <img id="iconPreview" class="logo-preview" src="{{ $cat->icon }}" alt="current">
          @else
            <img id="iconPreview" class="logo-preview d-none" src="#" alt="preview">
          @endif

          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remove_icon" value="1" id="removeIcon">
            <label class="form-check-label" for="removeIcon">Remove stored icon</label>
          </div>
        </div>
        <div class="form-text">Recommended: 256×256 PNG/JPG/WebP/SVG</div>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-primary btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/biller-categories') }}">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('iconFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('iconPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
@endsection
