@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .preview{ height:160px; width:100%; max-width:420px; object-fit:cover; border-radius:12px; border:1px solid #e5e7eb; background:#f8fafc }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/banners') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Banner Details</h5>
  </div>

  <div class="card-edge p-3">
    @php
      $p = $row->image_path;
      $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
      $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
      $src      = $isStored ? asset('storage/'.$p) : ($isUrl ? $p : null);
    @endphp

    @if($src)
      <img class="preview mb-2" src="{{ $src }}" alt="banner">
    @elseif($p)
      <div class="preview d-flex align-items-center justify-content-center" style="border-style:dashed">{{ $p }}</div>
    @else
      <div class="text-muted"><i class="fa-regular fa-image me-1"></i>No image</div>
    @endif

    <div class="row g-3 mt-2">
      <div class="col-md-3">
        <div class="text-muted small mb-1">Status</div>
        <div>
          <span class="badge-soft {{ $row->is_active ? 'green' : 'red' }}">
            <i class="fa-solid {{ $row->is_active ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>
            {{ $row->is_active ? 'Active' : 'Inactive' }}
          </span>
        </div>
      </div>
      <div class="col-md-3">
        <div class="text-muted small mb-1">Sort Order</div>
        <div class="fw-semibold">{{ $row->sort_order }}</div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/banners/'.$row->id.'/edit') }}">
        <i class="fa-regular fa-pen-to-square me-1"></i> Edit
      </a>
      <form action="{{ url('/admin/banners/'.$row->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
