@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .thumb-48{ height:48px; width:48px; border-radius:12px; border:1px solid #e5e7eb; object-fit:cover; background:#fff }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.45rem .6rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-regular fa-images me-2"></i> Banner Manager</h5>
    <a class="btn btn-primary" href="{{ url('/admin/banners/create') }}">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  @if(session('success'))
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i>{{ session('success') }}
    </div>
  @endif

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Image</th>
          <th>Sort</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        @forelse($banners as $b)
        <tr>
          <td data-label="#" class="text-muted">{{ $b->id }}</td>
          <td data-label="Image">
            @php
              $p = $b->image_path;
              $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
              $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
            @endphp
            @if($isStored)
              <img class="thumb-48" src="{{ asset('storage/'.$p) }}" alt="banner">
            @elseif($isUrl)
              <img class="thumb-48" src="{{ $p }}" alt="banner">
            @elseif($p)
              <div class="thumb-48 d-flex align-items-center justify-content-center" style="border-style:dashed">{{ $p }}</div>
            @else
              <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>None</span>
            @endif
          </td>
          <td data-label="Sort">{{ $b->sort_order }}</td>
          <td data-label="Status">
            <span class="badge-soft {{ $b->is_active ? 'green' : 'red' }}">
              <i class="fa-solid {{ $b->is_active ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>
              {{ $b->is_active ? 'Active' : 'Inactive' }}
            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <form action="{{ url('/admin/banners/'.$b->id.'/toggle') }}" method="POST">@csrf @method('PATCH')
                <button class="btn btn-warning btn-sm"><i class="fa-solid fa-arrows-rotate"></i> Toggle</button>
              </form>
              <a class="btn btn-primary btn-sm" href="{{ url('/admin/banners/'.$b->id.'/edit') }}"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
              <a class="btn btn-outline-secondary btn-sm" href="{{ url('/admin/banners/'.$b->id) }}"><i class="fa-regular fa-eye"></i> View</a>
              <form action="{{ url('/admin/banners/'.$b->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
                @csrf @method('DELETE')
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        @empty
          <tr><td colspan="5" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No banners</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div class="mt-3">{{ $banners->links() }}</div>
</div>
@endsection
